/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class SynchronizedCollection<T>
implements Collection<T> {
    private final Collection<T> baseCollection;
    private Collection<T> copyCollection;

    public SynchronizedCollection(@NotNull Collection<T> collection) {
        this.baseCollection = collection;
    }

    @NotNull
    private synchronized Collection<T> getCopy() {
        if (this.copyCollection == null) {
            this.copyCollection = Collections.unmodifiableCollection(new ArrayList<T>(this.baseCollection));
        }
        return this.copyCollection;
    }

    private synchronized void clearCopy() {
        this.copyCollection = null;
    }

    @Override
    public synchronized int size() {
        return this.baseCollection.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.baseCollection.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.getCopy().contains(object);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        final Iterator<T> iterator = this.getCopy().iterator();
        return new Iterator<T>(){
            private T current;
            private boolean hasCurrent;

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                this.current = iterator.next();
                this.hasCurrent = true;
                return this.current;
            }

            @Override
            public void remove() {
                if (!this.hasCurrent) {
                    throw new IllegalStateException("Cannot delete w/o iterating!");
                }
                SynchronizedCollection.this.remove(this.current);
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.getCopy().toArray();
    }

    @Override
    @NotNull
    public <U> U[] toArray(@NotNull U[] UArray) {
        return this.getCopy().toArray(UArray);
    }

    @Override
    public synchronized boolean add(T t) {
        if (this.baseCollection.add(t)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean remove(Object object) {
        if (this.baseCollection.remove(object)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.getCopy().containsAll(collection);
    }

    @Override
    public synchronized boolean addAll(@NotNull Collection<? extends T> collection) {
        if (this.baseCollection.addAll(collection)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll(@NotNull Collection<?> collection) {
        if (this.baseCollection.removeAll(collection)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean retainAll(@NotNull Collection<?> collection) {
        if (this.baseCollection.retainAll(collection)) {
            this.clearCopy();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void clear() {
        if (!this.baseCollection.isEmpty()) {
            this.baseCollection.clear();
            this.clearCopy();
        }
    }
}

