/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Indexable;
import de.caff.generics.Subjective;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Subjectivity {
    private final boolean deep;
    @NotNull
    private final Map<Class<?>, Subjective<?>> subjectMapping = new HashMap();

    public Subjectivity(boolean bl, @NotNull Iterable<Subjective<?>> iterable) {
        iterable.forEach(subjective -> this.subjectMapping.put(subjective.type(), (Subjective<?>)subjective));
        this.deep = bl;
    }

    public Subjectivity(boolean bl, Subjective<?> ... subjectiveArray) {
        this(bl, Indexable.viewArray(subjectiveArray));
    }

    private Object possibleDeepWrap(@NotNull Object object) {
        if (!this.deep) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object;
        }
        Class<?> clazz2 = clazz.getComponentType();
        if (clazz2.isPrimitive()) {
            if (object instanceof int[]) {
                return new IntArrayWrap((int[])object);
            }
            if (object instanceof double[]) {
                return new DoubleArrayWrap((double[])object);
            }
            if (object instanceof byte[]) {
                return new ByteArrayWrap((byte[])object);
            }
            if (object instanceof long[]) {
                return new LongArrayWrap((long[])object);
            }
            if (object instanceof short[]) {
                return new ShortArrayWrap((short[])object);
            }
            if (object instanceof char[]) {
                return new CharArrayWrap((char[])object);
            }
            if (object instanceof boolean[]) {
                return new BooleanArrayWrap((boolean[])object);
            }
        }
        return new ArrayWrap((Object[])object);
    }

    @NotNull
    public Object substitute(@NotNull Object object) {
        Class<?> clazz = object.getClass();
        Subjective<?> subjective = this.subjectMapping.get(clazz);
        if (subjective != null) {
            return this.possibleDeepWrap(subjective.subjectFrom(object));
        }
        if (clazz.isArray()) {
            return this.possibleDeepWrap(this.substituteArray(clazz.getComponentType(), object, 1));
        }
        return object;
    }

    @Nullable
    public Object substitute0(@Nullable Object object) {
        return object == null ? null : this.substitute(object);
    }

    @NotNull
    private Object substituteArray(@NotNull Class<?> clazz, @NotNull Object object, int n) {
        Subjective<?> subjective = this.subjectMapping.get(clazz);
        if (subjective != null) {
            return this.repackArray(object, subjective, n);
        }
        if (this.deep && clazz.isArray()) {
            return this.substituteArray(clazz.getComponentType(), object, n + 1);
        }
        if (this.deep && !clazz.isPrimitive()) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = null;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                Object object3 = this.substitute0(object2);
                if (objectArray2 != null) {
                    objectArray2[i] = object3;
                    continue;
                }
                if (object3 == object2) continue;
                objectArray2 = new Object[objectArray.length];
                if (i > 0) {
                    System.arraycopy(objectArray, 0, objectArray2, 0, i);
                }
                objectArray2[i] = object3;
            }
            if (objectArray2 != null) {
                return objectArray2;
            }
        }
        return object;
    }

    @NotNull
    private Object[] repackArray(@NotNull Object object, @NotNull Subjective<?> subjective, int n) {
        Object[] objectArray = (Object[])object;
        Object[] objectArray2 = new Object[objectArray.length];
        if (n == 1) {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                objectArray2[i] = subjective.subjectFrom(objectArray[i]);
            }
        } else {
            int n2 = n - 1;
            for (int i = objectArray.length - 1; i >= 0; --i) {
                objectArray2[i] = this.repackArray(objectArray[i], subjective, n2);
            }
        }
        return objectArray2;
    }

    private static class BooleanArrayWrap
    implements Cloneable {
        @NotNull
        private final boolean[] array;

        public BooleanArrayWrap(@NotNull boolean[] blArray) {
            this.array = blArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            boolean[] blArray;
            if (object == this) {
                return true;
            }
            if (object instanceof BooleanArrayWrap) {
                blArray = ((BooleanArrayWrap)object).array;
            } else if (object instanceof boolean[]) {
                blArray = (boolean[])object;
            } else {
                return false;
            }
            return Arrays.equals(this.array, blArray);
        }

        public String toString() {
            return String.format("WRAP{%s}", Arrays.toString(this.array));
        }

        public BooleanArrayWrap clone() {
            try {
                return (BooleanArrayWrap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    private static class CharArrayWrap
    implements Cloneable {
        @NotNull
        private final char[] array;

        public CharArrayWrap(@NotNull char[] cArray) {
            this.array = cArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            char[] cArray;
            if (object == this) {
                return true;
            }
            if (object instanceof CharArrayWrap) {
                cArray = ((CharArrayWrap)object).array;
            } else if (object instanceof char[]) {
                cArray = (char[])object;
            } else {
                return false;
            }
            return Arrays.equals(this.array, cArray);
        }

        public String toString() {
            return String.format("WRAP{%s}", Arrays.toString(this.array));
        }

        public CharArrayWrap clone() {
            try {
                return (CharArrayWrap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    private static class ByteArrayWrap
    implements Cloneable {
        @NotNull
        private final byte[] array;

        public ByteArrayWrap(@NotNull byte[] byArray) {
            this.array = byArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            byte[] byArray;
            if (object == this) {
                return true;
            }
            if (object instanceof ByteArrayWrap) {
                byArray = ((ByteArrayWrap)object).array;
            } else if (object instanceof byte[]) {
                byArray = (byte[])object;
            } else {
                return false;
            }
            return Arrays.equals(this.array, byArray);
        }

        public String toString() {
            return String.format("WRAP{%s}", Arrays.toString(this.array));
        }

        public ByteArrayWrap clone() {
            try {
                return (ByteArrayWrap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    private static class ShortArrayWrap
    implements Cloneable {
        @NotNull
        private final short[] array;

        public ShortArrayWrap(@NotNull short[] sArray) {
            this.array = sArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            short[] sArray;
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayWrap) {
                sArray = ((ShortArrayWrap)object).array;
            } else if (object instanceof short[]) {
                sArray = (short[])object;
            } else {
                return false;
            }
            return Arrays.equals(this.array, sArray);
        }

        public String toString() {
            return String.format("WRAP{%s}", Arrays.toString(this.array));
        }

        public ShortArrayWrap clone() {
            try {
                return (ShortArrayWrap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    private static class LongArrayWrap
    implements Cloneable {
        @NotNull
        private final long[] array;

        public LongArrayWrap(@NotNull long[] lArray) {
            this.array = lArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            long[] lArray;
            if (object == this) {
                return true;
            }
            if (object instanceof LongArrayWrap) {
                lArray = ((LongArrayWrap)object).array;
            } else if (object instanceof long[]) {
                lArray = (long[])object;
            } else {
                return false;
            }
            return Arrays.equals(this.array, lArray);
        }

        public String toString() {
            return String.format("WRAP{%s}", Arrays.toString(this.array));
        }

        public LongArrayWrap clone() {
            try {
                return (LongArrayWrap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    private static class FloatArrayWrap
    implements Cloneable {
        @NotNull
        private final float[] array;

        public FloatArrayWrap(@NotNull float[] fArray) {
            this.array = fArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            float[] fArray;
            if (object == this) {
                return true;
            }
            if (object instanceof FloatArrayWrap) {
                fArray = ((FloatArrayWrap)object).array;
            } else if (object instanceof float[]) {
                fArray = (float[])object;
            } else {
                return false;
            }
            return Arrays.equals(this.array, fArray);
        }

        public String toString() {
            return String.format("WRAP{%s}", Arrays.toString(this.array));
        }

        public FloatArrayWrap clone() {
            try {
                return (FloatArrayWrap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    private static class DoubleArrayWrap
    implements Cloneable {
        @NotNull
        private final double[] array;

        public DoubleArrayWrap(@NotNull double[] dArray) {
            this.array = dArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            double[] dArray;
            if (object == this) {
                return true;
            }
            if (object instanceof DoubleArrayWrap) {
                dArray = ((DoubleArrayWrap)object).array;
            } else if (object instanceof double[]) {
                dArray = (double[])object;
            } else {
                return false;
            }
            return Arrays.equals(this.array, dArray);
        }

        public String toString() {
            return String.format("WRAP{%s}", Arrays.toString(this.array));
        }

        public DoubleArrayWrap clone() {
            try {
                return (DoubleArrayWrap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    private static class IntArrayWrap
    implements Cloneable {
        @NotNull
        private final int[] array;

        public IntArrayWrap(@NotNull int[] nArray) {
            this.array = nArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.array);
        }

        public boolean equals(Object object) {
            int[] nArray;
            if (object == this) {
                return true;
            }
            if (object instanceof IntArrayWrap) {
                nArray = ((IntArrayWrap)object).array;
            } else if (object instanceof int[]) {
                nArray = (int[])object;
            } else {
                return false;
            }
            return Arrays.equals(this.array, nArray);
        }

        public String toString() {
            return String.format("WRAP{%s}", Arrays.toString(this.array));
        }

        public IntArrayWrap clone() {
            try {
                return (IntArrayWrap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }

    private static class ArrayWrap
    implements Cloneable {
        @NotNull
        private final Object[] array;

        public ArrayWrap(@NotNull Object[] objectArray) {
            this.array = objectArray;
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.array);
        }

        public boolean equals(Object object) {
            Object[] objectArray;
            if (object == this) {
                return true;
            }
            if (object instanceof ArrayWrap) {
                objectArray = ((ArrayWrap)object).array;
            } else if (object instanceof Object[]) {
                objectArray = (Object[])object;
            } else {
                return false;
            }
            return Arrays.deepEquals(this.array, objectArray);
        }

        public String toString() {
            return String.format("WRAP{%s}", Arrays.toString(this.array));
        }

        public ArrayWrap clone() {
            try {
                return (ArrayWrap)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }
}

