/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.SoftReference;

public class SoftPropertyChangeListener
implements PropertyChangeListener {
    private SoftReference<PropertyChangeListener> wrapped;

    public SoftPropertyChangeListener(@NotNull PropertyChangeListener propertyChangeListener) {
        this.wrapped = new SoftReference<PropertyChangeListener>(propertyChangeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PropertyChangeListener propertyChangeListener = this.getListener();
        if (propertyChangeListener != null) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public boolean isValid() {
        return this.getListener() != null;
    }

    @Nullable
    private PropertyChangeListener getListener() {
        PropertyChangeListener propertyChangeListener = this.wrapped.get();
        if (propertyChangeListener == null) {
            this.wrapped = null;
        }
        return propertyChangeListener;
    }
}

