/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class SingletonIterator<T>
implements Iterator<T> {
    private final T element;
    private boolean finished;

    public SingletonIterator(T t) {
        this.element = t;
    }

    @Override
    public boolean hasNext() {
        return !this.finished;
    }

    @Override
    public T next() {
        if (this.finished) {
            throw new NoSuchElementException("Only 1 element in a singleton iterator!");
        }
        this.finished = true;
        return this.element;
    }
}

