/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.IntPair;
import de.caff.generics.Primitives;
import de.caff.generics.ShortIndexable;
import de.caff.generics.function.ShortFunction2;
import de.caff.generics.function.ShortOperator2;
import de.caff.generics.function.ShortPredicate2;
import de.caff.generics.tuple.Tuple;
import de.caff.generics.tuple.Tuple2;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public final class ShortPair
implements Serializable,
ShortIndexable {
    private static final long serialVersionUID = -4898033497781881954L;
    public final short first;
    public final short second;

    public ShortPair(short s, short s2) {
        this.first = s;
        this.second = s2;
    }

    @NotNull
    public IntPair toIntPair() {
        return new IntPair(this.first, this.second);
    }

    @NotNull
    public IntPair toUnsignedIntPair() {
        return new IntPair(Primitives.unsigned(this.first), Primitives.unsigned(this.second));
    }

    @NotNull
    public ShortPair withFirst(short s) {
        if (s == this.first) {
            return this;
        }
        return new ShortPair(s, this.second);
    }

    @NotNull
    public ShortPair withSecond(short s) {
        if (s == this.second) {
            return this;
        }
        return new ShortPair(this.first, s);
    }

    @NotNull
    public ShortPair swapped() {
        if (this.first == this.second) {
            return this;
        }
        return new ShortPair(this.second, this.first);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public short get(int n) {
        switch (n) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Pair has only 2 elements, so %d is out of bounds!", n));
    }

    public <T> T applyAsShorts(@NotNull ShortFunction2<T> shortFunction2) {
        return shortFunction2.applyAsShort(this.first, this.second);
    }

    public short operate(@NotNull ShortOperator2 shortOperator2) {
        return shortOperator2.applyAsShort(this.first, this.second);
    }

    public boolean test(@NotNull ShortPredicate2 shortPredicate2) {
        return shortPredicate2.testShorts(this.first, this.second);
    }

    @NotNull
    public Tuple2<Short, Short> toTuple() {
        return Tuple.of(this.first, this.second);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ShortPair shortPair = (ShortPair)object;
        return shortPair.first == this.first && shortPair.second == this.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @NotNull
    public String toString() {
        return String.format(Locale.US, "ShortPair(%s, %s)", this.first, this.second);
    }
}

