/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.ByteIndexable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.MutableIntIndexable;
import de.caff.generics.MutableShortIndexable;
import de.caff.generics.Order;
import de.caff.generics.PrimitiveShortIterable;
import de.caff.generics.PrimitiveShortIterator;
import de.caff.generics.Primitives;
import de.caff.generics.Pythonesque;
import de.caff.generics.Sizeable;
import de.caff.generics.Types;
import de.caff.generics.function.FragileShortConsumer;
import de.caff.generics.function.IntToShortFunction1;
import de.caff.generics.function.ShortConsumer;
import de.caff.generics.function.ShortFunction1;
import de.caff.generics.function.ShortOperator1;
import de.caff.generics.function.ShortOperator2;
import de.caff.generics.function.ShortOrdering;
import de.caff.generics.function.ShortPredicate1;
import de.caff.generics.function.ToShortFunction;
import de.caff.generics.range.Range;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;

public interface ShortIndexable
extends PrimitiveShortIterable,
Sizeable {
    public static final ShortIndexable SINGLE_0 = ShortIndexable.singleton((short)0);
    public static final Base EMPTY = new Base(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public short get(int n) {
            throw new IndexOutOfBoundsException("Empty indexable has no elements!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int addToArray(@NotNull short[] sArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull short[] sArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public short[] toArray() {
            return Empty.SHORT_ARRAY;
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        @NotNull
        public ShortIndexable rotated(int n) {
            return this;
        }

        @Override
        @NotNull
        public ShortIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public Iterator<Short> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public ListIterator<Short> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public PrimitiveShortIterator shortIterator() {
            return Types.EMPTY_SHORT_ITERATOR;
        }

        @Override
        public int compareTo(@NotNull ShortIndexable shortIndexable) {
            return shortIndexable.isEmpty() ? 0 : -1;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ShortIndexable && ((ShortIndexable)object).isEmpty();
        }

        @Override
        public void forEachShort(@NotNull ShortConsumer shortConsumer) {
        }

        @Override
        public <E extends Exception> void forEachShortFragile(@NotNull FragileShortConsumer<E> fragileShortConsumer) throws E {
        }

        @Override
        public boolean containsShort(short s) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Short> consumer) {
        }

        @Override
        @NotNull
        public IntIndexable.Base asIntIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable.Base asUnsignedIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        public short foldLeft(short s, @NotNull ShortOperator2 shortOperator2) {
            return s;
        }
    };

    public short get(int var1);

    default public short gyt(int n) {
        return this.get(Pythonesque.mapX(n, this));
    }

    default public short getMod(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw new IndexOutOfBoundsException("No element for empty indexable!");
        }
        return this.gyt(n % n2);
    }

    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }

            @Override
            public short get(int n) {
                return ShortIndexable.this.get(ShortIndexable.this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return ShortIndexable.this.asBase();
            }
        };
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @NotNull
    default public PrimitiveIterator.OfInt intIterator() {
        return new PrimitiveIterator.OfInt(){
            private int index = 0;

            @Override
            public int nextInt() {
                if (this.index >= ShortIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return ShortIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < ShortIndexable.this.size();
            }
        };
    }

    @Override
    @NotNull
    default public PrimitiveShortIterator shortIterator() {
        return this.shortIterator(0, this.size());
    }

    @NotNull
    default public PrimitiveShortIterator shortIterator(final int n, final int n2) {
        return new PrimitiveShortIterator(){
            private int index;
            {
                this.index = n;
            }

            @Override
            public short nextShort() {
                if (this.index >= n2) {
                    throw new NoSuchElementException(String.format("Index %s out of allowed range [%d, %d[!", this.index, n, n2));
                }
                return ShortIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < n2;
            }
        };
    }

    @Override
    @NotNull
    default public Iterator<Short> iterator() {
        return this.listIterator();
    }

    @NotNull
    default public ListIterator<Short> listIterator() {
        return new ListIterator<Short>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ShortIndexable.this.size();
            }

            @Override
            public Short next() {
                if (this.index >= ShortIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return ShortIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Short previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                return ShortIndexable.this.get(--this.index);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Short s) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Short s) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    default public Base subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return n3 == 0 ? EMPTY : new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public short get(int n2) {
                if (n2 >= n3) {
                    throw new IndexOutOfBoundsException("No such element: " + n2);
                }
                return ShortIndexable.this.get(n2 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > n3) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return ShortIndexable.this.subSet(n + n4, n + n2);
            }
        };
    }

    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @NotNull
    default public <T> Indexable<T> view(final @NotNull ShortFunction1<? extends T> shortFunction1) {
        return new Indexable.Base<T>(){

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }

            @Override
            public T get(int n) {
                return shortFunction1.applyAsShort(ShortIndexable.this.get(n));
            }
        };
    }

    @NotNull
    default public Collection<Short> asCollection() {
        return new AbstractCollection<Short>(){

            @Override
            @NotNull
            public Iterator<Short> iterator() {
                return ShortIndexable.this.iterator();
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public List<Short> asList() {
        return new AbstractList<Short>(){

            @Override
            public Short get(int n) {
                return ShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }

            @Override
            @NotNull
            public Iterator<Short> iterator() {
                return ShortIndexable.this.iterator();
            }
        };
    }

    @NotNull
    default public ArrayList<Short> toList() {
        ArrayList<Short> arrayList = new ArrayList<Short>(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    default public void addAllTo(@NotNull Collection<? super Short> collection) {
        for (Short s : this) {
            collection.add(s);
        }
    }

    @NotNull
    default public Indexable<Short> asIndexable() {
        return new Indexable.Base<Short>(){

            @Override
            public Short get(int n) {
                return ShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public short[] toArray() {
        if (this.isEmpty()) {
            return Empty.SHORT_ARRAY;
        }
        short[] sArray = new short[this.size()];
        this.addToArray(sArray, 0);
        return sArray;
    }

    default public int addToArray(@NotNull short[] sArray, int n) {
        return this.addToArray(sArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull short[] sArray, int n, int n2, int n3) {
        PrimitiveShortIterator primitiveShortIterator = this.shortIterator(n2, n2 + n3);
        while (primitiveShortIterator.hasNext()) {
            sArray[n++] = primitiveShortIterator.nextShort();
        }
        return n;
    }

    default public int[] toIntArray() {
        if (this.isEmpty()) {
            return Empty.INT_ARRAY;
        }
        int[] nArray = new int[this.size()];
        this.addToArray(nArray, 0);
        return nArray;
    }

    default public int addToArray(@NotNull int[] nArray, int n) {
        return this.addToArray(nArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull int[] nArray, int n, int n2, int n3) {
        PrimitiveShortIterator primitiveShortIterator = this.shortIterator(n2, n2 + n3);
        while (primitiveShortIterator.hasNext()) {
            nArray[n++] = primitiveShortIterator.nextShort();
        }
        return n;
    }

    @NotNull
    default public Iterable<Integer> indexes() {
        return Range.indexes(this.size());
    }

    @NotNull
    default public IntIndexable intIndexes() {
        return IntIndexable.rangeFromSize(this.size());
    }

    @NotNull
    default public IntIndexable.Base asIntIndexable() {
        return new IntIndexable.Base(){

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }

            @Override
            public int get(int n) {
                return ShortIndexable.this.get(n);
            }
        };
    }

    @NotNull
    default public IntIndexable.Base asUnsignedIndexable() {
        return new IntIndexable.Base(){

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }

            @Override
            public int get(int n) {
                return ShortIndexable.this.get(n) & 0xFFFF;
            }
        };
    }

    default public short foldLeft(short s, @NotNull ShortOperator2 shortOperator2) {
        short s2 = s;
        PrimitiveShortIterator primitiveShortIterator = this.shortIterator();
        while (primitiveShortIterator.hasNext()) {
            s2 = shortOperator2.applyAsShort(s2, primitiveShortIterator.nextShort());
        }
        return s2;
    }

    @NotNull
    default public ShortIndexable withInsertedValueAt(int n, final short s) {
        final int n2 = n;
        final int n3 = this.size() + 1;
        if (n2 == 0) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public short get(int n) {
                    return n == 0 ? s : ShortIndexable.this.get(n - 1);
                }
            };
        }
        if (n2 == n3 - 1) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public short get(int n) {
                    return n == n3 - 1 ? s : ShortIndexable.this.get(n);
                }
            };
        }
        return new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public short get(int n) {
                if (n == n2) {
                    return s;
                }
                return ShortIndexable.this.get(n < n2 ? n : n - 1);
            }
        };
    }

    @NotNull
    default public ShortIndexable withAppendedValue(short s) {
        return this.withInsertedValueAt(this.size(), s);
    }

    @NotNull
    default public ShortIndexable withExchangedValueAt(int n, final short s) {
        final int n2 = Pythonesque.mapX(n, this);
        return new Base(){

            @Override
            public short get(int n) {
                return n == n2 ? s : ShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ShortIndexable withRemovedValueAt(int n) {
        final int n2 = Pythonesque.mapX(n, this);
        if (n2 == 0) {
            return this.tailSet(1);
        }
        final int n3 = this.size() - 1;
        if (n2 == n3) {
            return this.headSet(-1);
        }
        return new Base(){

            @Override
            public short get(int n) {
                return n < n2 ? ShortIndexable.this.get(n) : ShortIndexable.this.get(n + 1);
            }

            @Override
            public int size() {
                return n3;
            }
        };
    }

    @NotNull
    default public ShortIndexable withSwappedValuesAt(int n, int n2) {
        int n3;
        final int n4 = Pythonesque.mapX(n, this);
        if (n4 == (n3 = Pythonesque.mapX(n2, this))) {
            return this;
        }
        return new Base(){

            @Override
            public short get(int n) {
                if (n == n4) {
                    return ShortIndexable.this.get(n3);
                }
                if (n == n3) {
                    return ShortIndexable.this.get(n4);
                }
                return ShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ShortIndexable rotated(int n) {
        if ((n %= this.size()) == 0) {
            return this;
        }
        if (n < 0) {
            n += this.size();
        }
        final int n2 = n;
        return new Base(){

            @Override
            public short get(int n) {
                return ShortIndexable.this.get((n + n2) % this.size());
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }

            @Override
            @NotNull
            public ShortIndexable rotated(int n) {
                return ShortIndexable.this.rotated(n2 + n);
            }
        };
    }

    @NotNull
    default public ShortIndexable viewOp(@NotNull ShortOperator1 shortOperator1) {
        return ShortIndexable.viewByIndex(this.size(), n -> shortOperator1.applyAsShort(this.get(n)));
    }

    @NotNull
    default public DoubleIndexable viewAsDouble() {
        return new DoubleIndexable.Base(){

            @Override
            public double get(int n) {
                return ShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public FloatIndexable viewAsFloat() {
        return new FloatIndexable.Base(){

            @Override
            public float get(int n) {
                return ShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsLong() {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return ShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsUnsignedLong() {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return ShortIndexable.this.get(n) & 0xFFFF;
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable viewAsInt() {
        return new IntIndexable.Base(){

            @Override
            public int get(int n) {
                return ShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable viewAsUnsignedInt() {
        return new IntIndexable.Base(){

            @Override
            public int get(int n) {
                return ShortIndexable.this.get(n) & 0xFFFF;
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ByteIndexable viewAsByte() {
        return new ByteIndexable.Base(){

            @Override
            public byte get(int n) {
                return (byte)ShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    default public BooleanIndexable viewAsBoolean(final @NotNull ShortPredicate1 shortPredicate1) {
        return new BooleanIndexable.Base(){

            @Override
            public boolean get(int n) {
                return shortPredicate1.testShort(ShortIndexable.this.get(n));
            }

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public short get(int n) {
                return ((Number)list.get(n)).shortValue();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list, final short s) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public short get(int n) {
                Number number = (Number)list.get(n);
                return number != null ? number.shortValue() : s;
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static <T> Base viewList(final @NotNull List<T> list, final @NotNull ToShortFunction<? super T> toShortFunction) {
        return new Base(){

            @Override
            public short get(int n) {
                return toShortFunction.applyAsShort(list.get(n));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public short get(int n) {
                return ((Number)indexable.get(n)).shortValue();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable, final short s) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public short get(int n) {
                Number number = (Number)indexable.get(n);
                return number != null ? number.shortValue() : s;
            }
        };
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToShortFunction<? super T> toShortFunction) {
        return new Base(){

            @Override
            public short get(int n) {
                return toShortFunction.applyAsShort(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean isEmpty() {
                return indexable.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewNumberArray(final Number ... numberArray) {
        return new Base(){

            @Override
            public int size() {
                return numberArray.length;
            }

            @Override
            public short get(int n) {
                return numberArray[n].shortValue();
            }
        };
    }

    @NotNull
    public static Base viewArray(final short ... sArray) {
        return new Base(){

            @Override
            public int size() {
                return sArray.length;
            }

            @Override
            public short get(int n) {
                return sArray[n];
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull short[] sArray, final int n, final int n2) {
        if (n < 0 || n2 < 0 || n + n2 > sArray.length) {
            throw new IndexOutOfBoundsException("Start or end outside of range!");
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            public short get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("Index %d outside range [0, %d[!", n3, n2));
                }
                return sArray[n3 + n];
            }
        };
    }

    @NotNull
    public static <T> Base viewArray(final @NotNull T[] TArray, final @NotNull ToShortFunction<? super T> toShortFunction) {
        if (TArray.length == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public short get(int n) {
                return toShortFunction.applyAsShort(TArray[n]);
            }

            @Override
            public int size() {
                return TArray.length;
            }
        };
    }

    @NotNull
    public static Base singleton(final short s) {
        return new Base(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public short get(int n) {
                if (n != 0) {
                    throw new IndexOutOfBoundsException(String.format("Index %d for indexable of size 1!", n));
                }
                return s;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Base reverse() {
                return this;
            }

            @Override
            @NotNull
            public ShortIndexable rotated(int n) {
                return this;
            }

            @Override
            @NotNull
            public Collection<Short> asCollection() {
                return Collections.singleton(s);
            }

            @Override
            @NotNull
            public List<Short> asList() {
                return Collections.singletonList(s);
            }

            @Override
            @NotNull
            public short[] toArray() {
                return new short[]{s};
            }

            @Override
            public int addToArray(@NotNull short[] sArray, int n) {
                sArray[n] = s;
                return n + 1;
            }

            @Override
            @NotNull
            public Iterable<Integer> indexes() {
                return IntIndexable.SINGLE_0;
            }

            @Override
            @NotNull
            public IntIndexable intIndexes() {
                return IntIndexable.SINGLE_0;
            }
        };
    }

    @NotNull
    public static Base init(final int n, final short s) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public short get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return s;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            @NotNull
            public ShortIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    public static Base viewByIndex(final int n, final @NotNull IntToShortFunction1 intToShortFunction1) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public short get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return intToShortFunction1.applyAsShort(n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public static ShortIndexable initByIndex(int n, @NotNull IntToShortFunction1 intToShortFunction1) {
        return ShortIndexable.viewByIndex(n, intToShortFunction1).frozen();
    }

    @NotNull
    public static Base emptyIndexable() {
        return EMPTY;
    }

    @NotNull
    public static String toString(@NotNull ShortIndexable shortIndexable) {
        if (shortIndexable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(shortIndexable.get(0));
        PrimitiveShortIterator primitiveShortIterator = shortIndexable.tailSet(1).shortIterator();
        while (primitiveShortIterator.hasNext()) {
            stringBuilder.append(',').append(primitiveShortIterator.nextShort());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static boolean equal(@NotNull ShortIndexable shortIndexable, @NotNull ShortIndexable shortIndexable2) {
        if (shortIndexable == shortIndexable2) {
            return true;
        }
        if (shortIndexable.size() != shortIndexable2.size()) {
            return false;
        }
        PrimitiveShortIterator primitiveShortIterator = shortIndexable.shortIterator();
        PrimitiveShortIterator primitiveShortIterator2 = shortIndexable2.shortIterator();
        while (primitiveShortIterator.hasNext() && primitiveShortIterator2.hasNext()) {
            if (primitiveShortIterator.nextShort() == primitiveShortIterator2.nextShort()) continue;
            return false;
        }
        return !primitiveShortIterator.hasNext() && !primitiveShortIterator2.hasNext();
    }

    public static boolean equal(@NotNull ShortIndexable shortIndexable, @Nullable Object object) {
        if (object instanceof ShortIndexable) {
            return ShortIndexable.equal(shortIndexable, (ShortIndexable)object);
        }
        return false;
    }

    public static int compare(@NotNull ShortIndexable shortIndexable, @NotNull ShortIndexable shortIndexable2) {
        PrimitiveShortIterator primitiveShortIterator = shortIndexable.shortIterator();
        PrimitiveShortIterator primitiveShortIterator2 = shortIndexable2.shortIterator();
        while (primitiveShortIterator.hasNext() && primitiveShortIterator2.hasNext()) {
            int n = Short.compare(primitiveShortIterator.nextShort(), primitiveShortIterator2.nextShort());
            if (n == 0) continue;
            return n;
        }
        if (primitiveShortIterator.hasNext()) {
            return 1;
        }
        if (primitiveShortIterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int compareUnsigned(@NotNull ShortIndexable shortIndexable, @NotNull ShortIndexable shortIndexable2) {
        PrimitiveShortIterator primitiveShortIterator = shortIndexable.shortIterator();
        PrimitiveShortIterator primitiveShortIterator2 = shortIndexable2.shortIterator();
        while (primitiveShortIterator.hasNext() && primitiveShortIterator2.hasNext()) {
            int n = Primitives.compareUnsigned(primitiveShortIterator.nextShort(), primitiveShortIterator2.nextShort());
            if (n == 0) continue;
            return n;
        }
        if (primitiveShortIterator.hasNext()) {
            return 1;
        }
        if (primitiveShortIterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int hash(@NotNull ShortIndexable shortIndexable) {
        int n = 1;
        PrimitiveShortIterator primitiveShortIterator = shortIndexable.shortIterator();
        while (primitiveShortIterator.hasNext()) {
            n = 31 * n + Short.hashCode(primitiveShortIterator.next());
        }
        return n;
    }

    @NotNull
    public static Base withCachedHash(final @NotNull ShortIndexable shortIndexable) {
        final int n = ShortIndexable.hash(shortIndexable);
        return new Base(){

            @Override
            public int size() {
                return shortIndexable.size();
            }

            @Override
            public short get(int n2) {
                return shortIndexable.get(n2);
            }

            @Override
            @NotNull
            public PrimitiveShortIterator shortIterator() {
                return shortIndexable.shortIterator();
            }

            @Override
            @NotNull
            public PrimitiveShortIterator shortIterator(int n3, int n2) {
                return shortIndexable.shortIterator(n3, n2);
            }

            @Override
            @NotNull
            public Iterator<Short> iterator() {
                return shortIndexable.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Short> listIterator() {
                return shortIndexable.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n2) {
                return shortIndexable.subSet(n3, n2);
            }

            @Override
            public int addToArray(@NotNull short[] sArray, int n2) {
                return shortIndexable.addToArray(sArray, n2);
            }

            @Override
            public int addToArray(@NotNull short[] sArray, int n4, int n2, int n3) {
                return shortIndexable.addToArray(sArray, n4, n2, n3);
            }

            @Override
            public int hashCode() {
                return n;
            }

            @Override
            public boolean equals(Object object) {
                return ShortIndexable.equal(shortIndexable, object);
            }

            @Override
            public String toString() {
                return ShortIndexable.toString(shortIndexable);
            }
        };
    }

    default public int nextMatch(int n, @NotNull ShortPredicate1 shortPredicate1) {
        int n2 = this.size();
        for (int i = Pythonesque.mapX(n, this); i < n2; ++i) {
            if (!shortPredicate1.testShort(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int firstMatch(@NotNull ShortPredicate1 shortPredicate1) {
        return this.nextMatch(0, shortPredicate1);
    }

    default public int previousMatch(int n, @NotNull ShortPredicate1 shortPredicate1) {
        for (int i = Pythonesque.mapX(n, this); i >= 0; --i) {
            if (!shortPredicate1.testShort(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int lastMatch(@NotNull ShortPredicate1 shortPredicate1) {
        return this.previousMatch(-1, shortPredicate1);
    }

    @NotNull
    default public ShortIndexable frozen() {
        return IndexableHelper.frozenFromArray(this.toArray());
    }

    default public boolean isOrdered(@NotNull ShortOrdering shortOrdering) {
        boolean bl = true;
        if (this.size() >= 2) {
            short s = this.gyt(-1);
            for (int i = this.size() - 2; i >= 0; --i) {
                short s2 = this.get(i);
                if (shortOrdering.checkShort(s2, s) == Order.Descending) {
                    bl = false;
                    break;
                }
                s = s2;
            }
        }
        return bl;
    }

    default public boolean isOrdered() {
        if (this.size() < 2) {
            return true;
        }
        short s = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            short s2 = this.get(i);
            if (s2 < s) {
                return false;
            }
            s = s2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered(@NotNull ShortOrdering shortOrdering) {
        if (this.size() < 2) {
            return true;
        }
        short s = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            short s2 = this.get(i);
            if (shortOrdering.checkShort(s2, s) != Order.Ascending) {
                return false;
            }
            s = s2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered() {
        if (this.size() < 2) {
            return true;
        }
        short s = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            short s2 = this.get(i);
            if (s2 >= s) {
                return false;
            }
            s = s2;
        }
        return true;
    }

    default public int binarySearch(short s) {
        short s2 = s;
        int n = 0;
        int n2 = this.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            short s3 = this.get(n3);
            if (s3 < s2) {
                n = n3 + 1;
                continue;
            }
            if (s3 > s2) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    default public int binarySearch(short s, @NotNull ShortOrdering shortOrdering) {
        int n = 0;
        int n2 = this.size() - 1;
        block4: while (n <= n2) {
            int n3 = n + n2 >>> 1;
            short s2 = this.get(n3);
            switch (shortOrdering.checkShort(s2, s)) {
                case Ascending: {
                    n = n3 + 1;
                    continue block4;
                }
                case Descending: {
                    n2 = n3 - 1;
                    continue block4;
                }
            }
            return n3;
        }
        return -(n + 1);
    }

    @NotNull
    default public MutableShortIndexable ordered(@NotNull ShortOrdering shortOrdering) {
        MutableShortIndexable.Base base = MutableShortIndexable.fromShortIndexable(this);
        base.order(shortOrdering);
        return base;
    }

    @NotNull
    default public MutableIntIndexable ordered() {
        MutableIntIndexable.Base base = MutableIntIndexable.fromShortIndexable(this);
        base.order();
        return base;
    }

    @NotNull
    default public Base asBase() {
        return new Base(){

            @Override
            public int size() {
                return ShortIndexable.this.size();
            }

            @Override
            public short get(int n) {
                return ShortIndexable.this.get(n);
            }

            @Override
            @NotNull
            public Base reverse() {
                return ShortIndexable.this.reverse();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator() {
                return ShortIndexable.this.intIterator();
            }

            @Override
            @NotNull
            public PrimitiveShortIterator shortIterator() {
                return ShortIndexable.this.shortIterator();
            }

            @Override
            @NotNull
            public PrimitiveShortIterator shortIterator(int n, int n2) {
                return ShortIndexable.this.shortIterator(n, n2);
            }

            @Override
            @NotNull
            public Iterator<Short> iterator() {
                return ShortIndexable.this.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Short> listIterator() {
                return ShortIndexable.this.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return ShortIndexable.this.subSet(n, n2);
            }

            @Override
            @NotNull
            public short[] toArray() {
                return ShortIndexable.this.toArray();
            }

            @Override
            public int addToArray(@NotNull short[] sArray, int n) {
                return ShortIndexable.this.addToArray(sArray, n);
            }

            @Override
            public int addToArray(@NotNull short[] sArray, int n, int n2, int n3) {
                return ShortIndexable.this.addToArray(sArray, n, n2, n3);
            }

            @Override
            @NotNull
            public IntIndexable.Base asIntIndexable() {
                return ShortIndexable.this.asIntIndexable();
            }

            @Override
            @NotNull
            public IntIndexable.Base asUnsignedIndexable() {
                return ShortIndexable.this.asUnsignedIndexable();
            }

            @Override
            public short foldLeft(short s, @NotNull ShortOperator2 shortOperator2) {
                return s;
            }
        };
    }

    public static abstract class Base
    implements ShortIndexable,
    Comparable<ShortIndexable> {
        @Override
        public int compareTo(@NotNull ShortIndexable shortIndexable) {
            Objects.requireNonNull(shortIndexable);
            return ShortIndexable.compare(this, shortIndexable);
        }

        public int hashCode() {
            return ShortIndexable.hash(this);
        }

        public boolean equals(Object object) {
            return ShortIndexable.equal((ShortIndexable)this, object);
        }

        public String toString() {
            return ShortIndexable.toString(this);
        }

        @Override
        @NotNull
        public Base asBase() {
            return this;
        }
    }
}

