/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.function.Ordering;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiPredicate;

public class Sequences {
    public static final BiPredicate<Object, Object> IDENTICAL = (object, object2) -> object == object2;

    private Sequences() {
    }

    public static boolean areEqual(@NotNull Iterable<?> iterable, @NotNull Iterable<?> iterable2) {
        return iterable == iterable2 || Sequences.areEqual(iterable, iterable2, Objects::deepEquals);
    }

    public static boolean areEqual(@NotNull Iterator<?> iterator, @NotNull Iterator<?> iterator2) {
        return Sequences.areEqual(iterator, iterator2, Objects::deepEquals);
    }

    public static boolean areIdentical(@NotNull Iterable<?> iterable, @NotNull Iterable<?> iterable2) {
        return iterable == iterable2 || Sequences.areEqual(iterable, iterable2, IDENTICAL);
    }

    public static boolean areIdentical(@NotNull Iterator<?> iterator, @NotNull Iterator<?> iterator2) {
        return Sequences.areEqual(iterator, iterator2, IDENTICAL);
    }

    public static <T1, T2> boolean areEqual(@NotNull Iterable<T1> iterable, @NotNull Iterable<T2> iterable2, @NotNull BiPredicate<? super T1, ? super T2> biPredicate) {
        return Sequences.areEqual(iterable.iterator(), iterable2.iterator(), biPredicate);
    }

    public static <T1, T2> boolean areEqual(@NotNull T1[] T1Array, @NotNull T2[] T2Array, @NotNull BiPredicate<? super T1, ? super T2> biPredicate) {
        return Sequences.areEqual(T1Array, 0, T1Array.length, T2Array, 0, T2Array.length, biPredicate);
    }

    public static <T1, T2> boolean areEqual(@NotNull T1[] T1Array, int n, int n2, @NotNull T2[] T2Array, int n3, int n4, @NotNull BiPredicate<? super T1, ? super T2> biPredicate) {
        if (n2 != n4) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (biPredicate.test(T1Array[n + i], T2Array[n3 + i])) continue;
            return false;
        }
        return true;
    }

    public static <T1, T2> boolean areEqual(@NotNull Iterator<T1> iterator, @NotNull Iterator<T2> iterator2, @NotNull BiPredicate<? super T1, ? super T2> biPredicate) {
        while (iterator.hasNext() && iterator2.hasNext()) {
            T2 T2;
            T1 T1 = iterator.next();
            if (biPredicate.test(T1, T2 = iterator2.next())) continue;
            return false;
        }
        return iterator.hasNext() == iterator2.hasNext();
    }

    @NotNull
    public static <T extends Comparable<T>> Order compare(@NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2) {
        return Sequences.compare(iterable.iterator(), iterable2.iterator(), Ordering.natural());
    }

    @NotNull
    public static <T extends Comparable<T>> Order compare(@NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2, @NotNull Order order) {
        return Sequences.compare(iterable.iterator(), iterable2.iterator(), order, Ordering.natural());
    }

    @NotNull
    public static <T> Order compare(@NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2, @NotNull Ordering<? super T> ordering) {
        return Sequences.compare(iterable.iterator(), iterable2.iterator(), ordering);
    }

    @NotNull
    public static <T> Order compare(@NotNull Iterable<? extends T> iterable, @NotNull Iterable<? extends T> iterable2, @NotNull Order order, @NotNull Ordering<? super T> ordering) {
        return Sequences.compare(iterable.iterator(), iterable2.iterator(), order, ordering);
    }

    @NotNull
    public static <T> Order compare(@NotNull Iterator<? extends T> iterator, @NotNull Iterator<? extends T> iterator2, @NotNull Ordering<? super T> ordering) {
        return Sequences.compare(iterator, iterator2, Order.Ascending, ordering);
    }

    @NotNull
    public static <T extends Comparable<T>> Order compare(@NotNull Iterator<? extends T> iterator, @NotNull Iterator<? extends T> iterator2) {
        return Sequences.compare(iterator, iterator2, Order.Ascending, Ordering.natural());
    }

    @NotNull
    public static <T extends Comparable<T>> Order compare(@NotNull Iterator<? extends T> iterator, @NotNull Iterator<? extends T> iterator2, @NotNull Order order) {
        return Sequences.compare(iterator, iterator2, order, Ordering.natural());
    }

    @NotNull
    public static <T> Order compare(@NotNull Iterator<? extends T> iterator, @NotNull Iterator<? extends T> iterator2, @NotNull Order order, @NotNull Ordering<? super T> ordering) {
        while (iterator.hasNext() && iterator2.hasNext()) {
            T t;
            T t2 = iterator.next();
            Order order2 = ordering.check(t2, t = iterator2.next());
            if (order2 == Order.Same) continue;
            return order2;
        }
        boolean bl = iterator.hasNext();
        if (bl == iterator2.hasNext()) {
            return Order.Same;
        }
        return bl ? order.inverse() : order;
    }
}

