/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ReferenceCreator;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;

public final class References {
    private References() {
    }

    @NotNull
    public static <V> ReferenceCreator<SoftReference<V>, V> getSoftReferenceCreator() {
        return SoftReference::new;
    }

    @NotNull
    public static <V> ReferenceCreator<SoftReference<V>, V> getSoftReferenceCreator(@NotNull ReferenceQueue<? super V> referenceQueue) {
        return object -> new SoftReference<Object>(object, referenceQueue);
    }

    @NotNull
    public static <V> ReferenceCreator<WeakReference<V>, V> getWeakReferenceCreator() {
        return WeakReference::new;
    }

    @NotNull
    public static <V> ReferenceCreator<WeakReference<V>, V> getWeakReferenceCreator(@NotNull ReferenceQueue<? super V> referenceQueue) {
        return object -> new WeakReference<Object>(object, referenceQueue);
    }
}

