/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ReferenceCreator;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class RefWrapperList<V>
implements List<V> {
    private final ReferenceCreator<? extends Reference<V>, V> referenceCreator;
    private final List<Reference<V>> wrappedList;

    public RefWrapperList(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator) {
        this.referenceCreator = referenceCreator;
        this.wrappedList = new LinkedList<Reference<V>>();
    }

    public RefWrapperList(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, Collection<? extends V> collection) {
        this(referenceCreator);
        this.addAll(collection);
    }

    protected RefWrapperList(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, @NotNull List<Reference<V>> list) {
        this.referenceCreator = referenceCreator;
        this.wrappedList = list;
    }

    @Override
    public int size() {
        return this.wrappedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedList.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        for (Reference<V> reference : this.wrappedList) {
            V v;
            if (!(reference == null ? object == null : (v = reference.get()) != null && v.equals(object))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.toDirectList().iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toDirectList().toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] TArray) {
        return this.toDirectList().toArray(TArray);
    }

    @Override
    public boolean add(V v) {
        Reference<V> reference = this.createReference(v);
        return this.wrappedList.add(reference);
    }

    @Override
    public boolean remove(Object object) {
        ListIterator<Reference<V>> listIterator = this.wrappedList.listIterator();
        while (listIterator.hasNext()) {
            Reference<V> reference = listIterator.next();
            if (reference == null) {
                if (object != null) continue;
                listIterator.remove();
                return true;
            }
            if (!reference.equals(object)) continue;
            listIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> collection) {
        boolean bl = false;
        for (V v : collection) {
            if (!this.add(v)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, @NotNull Collection<? extends V> collection) {
        ArrayList<Reference<V>> arrayList = new ArrayList<Reference<V>>(collection.size());
        for (V v : collection) {
            arrayList.add(this.createReference(v));
        }
        return this.wrappedList.addAll(n, arrayList);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        boolean bl = false;
        ListIterator<Reference<V>> listIterator = this.wrappedList.listIterator();
        while (listIterator.hasNext()) {
            Reference<V> reference = listIterator.next();
            Object var5_5 = reference == null ? null : reference.get();
            if (!collection.contains(var5_5)) continue;
            listIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        boolean bl = false;
        ListIterator<Reference<V>> listIterator = this.wrappedList.listIterator();
        while (listIterator.hasNext()) {
            Reference<V> reference = listIterator.next();
            Object var5_5 = reference == null ? null : reference.get();
            if (collection.contains(var5_5)) continue;
            listIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.wrappedList.clear();
    }

    @Override
    public V get(int n) {
        Reference<V> reference = this.wrappedList.get(n);
        return reference == null ? null : (V)reference.get();
    }

    @Override
    public V set(int n, V v) {
        Reference<V> reference = this.wrappedList.set(n, this.createReference(v));
        return reference == null ? null : (V)reference.get();
    }

    @Override
    public void add(int n, V v) {
        this.wrappedList.add(n, this.createReference(v));
    }

    @Override
    public V remove(int n) {
        Reference<V> reference = this.wrappedList.remove(n);
        return reference == null ? null : (V)reference.get();
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        for (Reference<V> reference : this.wrappedList) {
            if (reference == null ? object == null : reference.equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = 0;
        int n2 = -1;
        for (Reference<V> reference : this.wrappedList) {
            if (reference == null) {
                if (object == null) {
                    n2 = n;
                }
            } else if (reference.equals(object)) {
                n2 = n;
            }
            ++n;
        }
        return n2;
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator() {
        return this.toDirectList().listIterator();
    }

    @Override
    @NotNull
    public ListIterator<V> listIterator(int n) {
        return this.toDirectList().listIterator(n);
    }

    @Override
    @NotNull
    public List<V> subList(int n, int n2) {
        return new RefWrapperList<V>(this.referenceCreator, this.wrappedList.subList(n, n2));
    }

    private List<V> toDirectList() {
        ArrayList<V> arrayList = new ArrayList<V>(this.wrappedList.size());
        ListIterator<Reference<V>> listIterator = this.wrappedList.listIterator();
        while (listIterator.hasNext()) {
            Reference<V> reference = listIterator.next();
            if (reference == null) {
                arrayList.add(null);
                continue;
            }
            V v = reference.get();
            if (v == null) {
                listIterator.remove();
                continue;
            }
            arrayList.add(v);
        }
        return arrayList;
    }

    private Reference<V> createReference(V v) {
        return v == null ? null : this.referenceCreator.createReference(v);
    }

    public static <W> RefWrapperList<W> create(@NotNull ReferenceCreator<? extends Reference<W>, W> referenceCreator, @NotNull List<Reference<W>> list) {
        return new RefWrapperList<W>(referenceCreator, list);
    }
}

