/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ReferenceCreator;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class RefWrapperHashSet<V>
implements Set<V> {
    private final ReferenceCreator<? extends Reference<V>, V> referenceCreator;
    private final HashSet<HashReferenceWrapper<V>> wrappedSet;

    public RefWrapperHashSet(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator) {
        this.referenceCreator = referenceCreator;
        this.wrappedSet = new HashSet();
    }

    public RefWrapperHashSet(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, @NotNull Collection<? extends V> collection) {
        this(referenceCreator);
        this.addAll(collection);
    }

    @Override
    public int size() {
        return this.wrappedSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedSet.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.wrappedSet.contains(this.createReference(object));
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return this.toDirectSet().iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toDirectSet().toArray();
    }

    @Override
    @NotNull
    public <U> U[] toArray(@NotNull U[] UArray) {
        return this.toDirectSet().toArray(UArray);
    }

    @Override
    public boolean add(V v) {
        HashReferenceWrapper<V> hashReferenceWrapper = this.createReference(v);
        return this.wrappedSet.add(hashReferenceWrapper);
    }

    @Override
    public boolean remove(Object object) {
        return this.wrappedSet.remove(this.createReference(object));
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends V> collection) {
        boolean bl = false;
        for (V v : collection) {
            if (!this.add(v)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        for (Object obj : collection) {
            arrayList.add(this.createReference(obj));
        }
        return this.wrappedSet.retainAll(arrayList);
    }

    @Override
    public void clear() {
        this.wrappedSet.clear();
    }

    private Set<V> toDirectSet() {
        HashSet<V> hashSet = new HashSet<V>(this.wrappedSet.size(), 0.75f);
        LinkedList<HashReferenceWrapper<V>> linkedList = new LinkedList<HashReferenceWrapper<V>>();
        for (HashReferenceWrapper<Object> hashReferenceWrapper : this.wrappedSet) {
            Reference<V> reference = hashReferenceWrapper.getReference();
            if (reference == null) {
                hashSet.add(null);
                continue;
            }
            V v = reference.get();
            if (v == null) {
                linkedList.add(hashReferenceWrapper);
                continue;
            }
            hashSet.add(v);
        }
        for (HashReferenceWrapper<Object> hashReferenceWrapper : linkedList) {
            this.wrappedSet.remove(hashReferenceWrapper);
        }
        return hashSet;
    }

    private HashReferenceWrapper<V> createReference(V v) {
        return new HashReferenceWrapper(v == null ? null : this.referenceCreator.createReference(v));
    }

    private static final class HashReferenceWrapper<W> {
        private final Reference<W> reference;

        private HashReferenceWrapper(Reference<W> reference) {
            this.reference = reference;
        }

        public Reference<W> getReference() {
            return this.reference;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            HashReferenceWrapper hashReferenceWrapper = (HashReferenceWrapper)object;
            if (this.reference == null || hashReferenceWrapper.reference == null) {
                return this.reference == hashReferenceWrapper.reference;
            }
            W w = this.reference.get();
            W w2 = hashReferenceWrapper.reference.get();
            return w == null ? w2 == null : w.equals(w2);
        }

        public int hashCode() {
            if (this.reference == null) {
                return 0;
            }
            W w = this.reference.get();
            return w != null ? w.hashCode() : 0;
        }
    }
}

