/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.ReferenceCreator;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RefValueHashMap<K, V>
implements Map<K, V> {
    private final ReferenceCreator<? extends Reference<V>, V> referenceCreator;
    private final HashMap<K, Reference<V>> baseMap;
    private final boolean autoClean;

    public RefValueHashMap(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator) {
        this(referenceCreator, true);
    }

    public RefValueHashMap(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, int n) {
        this(referenceCreator, true, n, 0.75f);
    }

    public RefValueHashMap(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, int n, float f) {
        this(referenceCreator, true, n, f);
    }

    public RefValueHashMap(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, @NotNull Map<? extends K, ? extends V> map) {
        this(referenceCreator, true, map);
    }

    public RefValueHashMap(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, boolean bl) {
        this.referenceCreator = referenceCreator;
        this.autoClean = bl;
        this.baseMap = new HashMap();
    }

    public RefValueHashMap(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, boolean bl, int n) {
        this.referenceCreator = referenceCreator;
        this.autoClean = bl;
        this.baseMap = new HashMap(n);
    }

    public RefValueHashMap(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, boolean bl, int n, float f) {
        this.referenceCreator = referenceCreator;
        this.autoClean = bl;
        this.baseMap = new HashMap(n, f);
    }

    public RefValueHashMap(@NotNull ReferenceCreator<? extends Reference<V>, V> referenceCreator, boolean bl, @NotNull Map<? extends K, ? extends V> map) {
        this.referenceCreator = referenceCreator;
        this.autoClean = bl;
        this.baseMap = new HashMap(Math.max((int)((double)map.size() / 0.75) + 1, 16));
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.baseMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.baseMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.baseMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        object = this.wrapNull(object);
        for (Reference<V> reference : this.baseMap.values()) {
            if (!object.equals(reference.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object object) {
        return this.unwrapNull(this.baseMap.get(object));
    }

    @Override
    public V put(K k, V v) {
        this.baseMap.put(k, this.referenceCreator.createReference(this.wrapNull(v)));
        return v;
    }

    @Override
    public V remove(Object object) {
        return this.unwrapNull(this.baseMap.remove(object));
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.baseMap.put(entry.getKey(), this.referenceCreator.createReference(this.wrapNull(entry.getValue())));
        }
    }

    @Override
    public void clear() {
        this.baseMap.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.baseMap.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Collection<Reference<V>> collection = this.baseMap.values();
        ArrayList<V> arrayList = new ArrayList<V>(collection.size());
        for (Reference<V> reference : collection) {
            arrayList.add(this.unwrapNull(reference));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, Reference<V>>> set = this.baseMap.entrySet();
        HashSet<Map.Entry<K, V>> hashSet = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, Reference<V>> entry : set) {
            final K k = entry.getKey();
            final V v = this.unwrapNull(entry.getValue());
            hashSet.add(new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return k;
                }

                @Override
                public V getValue() {
                    return v;
                }

                @Override
                public V setValue(V v2) {
                    return RefValueHashMap.this.put(k, v2);
                }
            });
        }
        return hashSet;
    }

    public boolean hasDeadValue(@NotNull K k) {
        Reference<V> reference = this.baseMap.get(k);
        return reference.get() == null;
    }

    public void removeDeadValues() {
        for (K k : new ArrayList<K>(this.baseMap.keySet())) {
            if (!this.hasDeadValue(k)) continue;
            this.baseMap.remove(k);
        }
    }

    @NotNull
    private V wrapNull(@Nullable Object hashMap) {
        return (V)(hashMap != null ? hashMap : this.baseMap);
    }

    @Nullable
    private V unwrapNull(@Nullable Reference<V> reference) {
        if (reference == null) {
            return null;
        }
        V v = reference.get();
        if (this.autoClean && v == null) {
            this.removeDeadValues();
        }
        return (V)(v != this.baseMap ? v : null);
    }
}

