/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.LeastRecentlyUsedCache;
import de.caff.generics.function.FragileFunction1;
import de.caff.generics.function.Procedure2;
import de.caff.generics.util.Counter;
import de.caff.generics.util.ThreadSafeCounter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Function;

public class RecreatingLeastRecentlyUsedCache<K, V>
extends LeastRecentlyUsedCache<K, V> {
    @NotNull
    private final Function<K, V> recreator;
    @NotNull
    private final Map<K, Future<V>> pendingRecreations = new HashMap<K, Future<V>>();
    @NotNull
    private final Counter numRecreations = new ThreadSafeCounter();

    public RecreatingLeastRecentlyUsedCache(int n, @NotNull Function<K, V> function) {
        super(n);
        this.recreator = function;
    }

    public RecreatingLeastRecentlyUsedCache(int n, @NotNull FragileFunction1<V, ? extends Exception, K> fragileFunction1, @NotNull Procedure2<K, Exception> procedure2) {
        super(n);
        this.recreator = object -> {
            try {
                return fragileFunction1.apply(object);
            }
            catch (Exception exception) {
                procedure2.apply(object, exception);
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V get(@NotNull K k) {
        FutureTask<Object> futureTask;
        Map<K, Future<V>> map = this.pendingRecreations;
        synchronized (map) {
            Object v;
            Future<V> future = this.pendingRecreations.get(k);
            if (future != null) {
                try {
                    return future.get();
                }
                catch (InterruptedException | ExecutionException exception) {
                    exception.printStackTrace();
                }
            }
            if ((v = super.get(k)) != null) {
                return v;
            }
            futureTask = new FutureTask<Object>(() -> {
                V v = this.recreator.apply(k);
                this.numRecreations.add1();
                if (v != null) {
                    this.put(k, v);
                }
                return v;
            });
            this.pendingRecreations.put(k, futureTask);
        }
        futureTask.run();
        map = this.pendingRecreations;
        synchronized (map) {
            this.pendingRecreations.remove(k, futureTask);
        }
        try {
            return (V)futureTask.get();
        }
        catch (InterruptedException | ExecutionException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanup() {
        Map<K, Future<V>> map = this.pendingRecreations;
        synchronized (map) {
            super.cleanup();
            this.pendingRecreations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public V remove(K k) {
        Map<K, Future<V>> map = this.pendingRecreations;
        synchronized (map) {
            this.pendingRecreations.remove(k);
        }
        return super.remove(k);
    }

    public int getNumRecreations() {
        return this.numRecreations.getValue();
    }
}

