/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Sizeable;

public final class Pythonesque {
    public static final int UNMAPPABLE = Integer.MIN_VALUE;
    public static final String ERROR_INDEX_OUT_OF_BOUNDS_FORMAT = "Requested index [%d] for size %d!";

    private Pythonesque() {
    }

    public static int map(int n, int n2) {
        if (n >= 0) {
            return n;
        }
        if (n == Integer.MIN_VALUE) {
            throw new IndexOutOfBoundsException(String.format(ERROR_INDEX_OUT_OF_BOUNDS_FORMAT, n, n2));
        }
        return n2 + n;
    }

    public static int map(int n, @NotNull Sizeable sizeable) {
        if (n >= 0) {
            return n;
        }
        if (n == Integer.MIN_VALUE) {
            throw new IndexOutOfBoundsException(String.format(ERROR_INDEX_OUT_OF_BOUNDS_FORMAT, n, sizeable.size()));
        }
        return n + sizeable.size();
    }

    public static int mapLB(int n, int n2) {
        if (n >= 0) {
            return n;
        }
        if (n < -n2) {
            if (n == Integer.MIN_VALUE) {
                throw new IndexOutOfBoundsException(String.format(ERROR_INDEX_OUT_OF_BOUNDS_FORMAT, n, n2));
            }
            return 0;
        }
        return n + n2;
    }

    public static int mapLB(int n, @NotNull Sizeable sizeable) {
        if (n >= 0) {
            return n;
        }
        if (n == Integer.MIN_VALUE) {
            throw new IndexOutOfBoundsException(String.format(ERROR_INDEX_OUT_OF_BOUNDS_FORMAT, n, sizeable.size()));
        }
        int n2 = sizeable.size();
        if (n < -n2) {
            return 0;
        }
        return n + n2;
    }

    public static int mapUB(int n, int n2) {
        if (n >= 0) {
            return n >= n2 ? n2 - 1 : n;
        }
        if (n == Integer.MIN_VALUE) {
            throw new IndexOutOfBoundsException(String.format(ERROR_INDEX_OUT_OF_BOUNDS_FORMAT, n, n2));
        }
        return n + n2;
    }

    public static int mapUB(int n, @NotNull Sizeable sizeable) {
        return Pythonesque.mapUB(n, sizeable.size());
    }

    public static int mapX(int n, int n2) {
        if (n >= 0) {
            return n;
        }
        if (n < -n2) {
            throw new IndexOutOfBoundsException(String.format(ERROR_INDEX_OUT_OF_BOUNDS_FORMAT, n, n2));
        }
        return n + n2;
    }

    public static int mapX(int n, @NotNull Sizeable sizeable) {
        if (n >= 0) {
            return n;
        }
        int n2 = sizeable.size();
        if (n < -n2) {
            throw new IndexOutOfBoundsException(String.format(ERROR_INDEX_OUT_OF_BOUNDS_FORMAT, n, n2));
        }
        return n + n2;
    }
}

