/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Order;
import de.caff.generics.Subject;
import de.caff.generics.Subjective;
import de.caff.generics.Subjectivity;
import de.caff.generics.function.Function1;

public final class Primitives {
    private static final Float FLOAT_BOXED_0 = Float.valueOf(0.0f);
    private static final Double DOUBLE_BOXED_0 = 0.0;
    private static final Float FLOAT_BOXED_NAN = Float.valueOf(Float.NaN);
    private static final Double DOUBLE_BOXED_NAN = Double.NaN;
    private static final int DOUBLE_NAN_HASH = Double.hashCode(Double.NaN);
    private static final int FLOAT_NAN_HASH = Float.hashCode(Float.NaN);
    public static final Function1<byte[], byte[]> BYTE_ARRAY_CLONER = byArray -> byArray != null ? (byte[])byArray.clone() : null;
    public static final Function1<short[], short[]> SHORT_ARRAY_CLONER = sArray -> sArray != null ? (short[])sArray.clone() : null;
    public static final Function1<int[], int[]> INT_ARRAY_CLONER = nArray -> nArray != null ? (int[])nArray.clone() : null;
    public static final Function1<long[], long[]> LONG_ARRAY_CLONER = lArray -> lArray != null ? (long[])lArray.clone() : null;
    public static final Function1<char[], char[]> CHAR_ARRAY_CLONER = cArray -> cArray != null ? (char[])cArray.clone() : null;
    public static final Function1<float[], float[]> FLOAT_ARRAY_CLONER = fArray -> fArray != null ? (float[])fArray.clone() : null;
    public static final Function1<double[], double[]> DOUBLE_ARRAY_CLONER = dArray -> dArray != null ? (double[])dArray.clone() : null;
    private static final Subjective<Double> DOUBLE_SUBJECTIVE = new Subjective<Double>(){

        @Override
        @NotNull
        public Class<Double> type() {
            return Double.class;
        }

        @Override
        @NotNull
        public Subject<Double> subject(@NotNull Double d) {
            return new Subject.Base<Double>(d, Double.class){

                @Override
                @NotNull
                public Double substituted() {
                    return (Double)this.object;
                }

                public int hashCode() {
                    return Primitives.hash((Double)this.object);
                }

                @Override
                protected boolean isEqualTo(@NotNull Double d) {
                    return Primitives.areEqual((Double)this.object, d);
                }
            };
        }
    };
    private static final Subjective<Float> FLOAT_SUBJECTIVE = new Subjective<Float>(){

        @Override
        @NotNull
        public Class<Float> type() {
            return Float.class;
        }

        @Override
        @NotNull
        public Subject<Float> subject(@NotNull Float f) {
            return new Subject.Base<Float>(f, Float.class){

                @Override
                @NotNull
                public Float substituted() {
                    return (Float)this.object;
                }

                public int hashCode() {
                    return Primitives.hash(((Float)this.object).floatValue());
                }

                @Override
                protected boolean isEqualTo(@NotNull Float f) {
                    return Primitives.areEqual(((Float)this.object).floatValue(), f.floatValue());
                }
            };
        }
    };
    private static final Subjective<double[]> DOUBLE_ARRAY_SUBJECTIVE = new Subjective<double[]>(){

        @Override
        @NotNull
        public Class<double[]> type() {
            return double[].class;
        }

        @Override
        @NotNull
        public Subject<double[]> subject(@NotNull double[] dArray) {
            return new Subject.Base<double[]>(dArray, double[].class){

                @Override
                @NotNull
                public double[] substituted() {
                    return (double[])this.object;
                }

                public int hashCode() {
                    return Primitives.hash((double[])this.object);
                }

                @Override
                protected boolean isEqualTo(@NotNull double[] dArray) {
                    return Primitives.areEqual((double[])this.object, dArray);
                }
            };
        }
    };
    private static final Subjective<float[]> FLOAT_ARRAY_SUBJECTIVE = new Subjective<float[]>(){

        @Override
        @NotNull
        public Class<float[]> type() {
            return float[].class;
        }

        @Override
        @NotNull
        public Subject<float[]> subject(@NotNull float[] fArray) {
            return new Subject.Base<float[]>(fArray, float[].class){

                @Override
                @NotNull
                public float[] substituted() {
                    return (float[])this.object;
                }

                public int hashCode() {
                    return Primitives.hash((float[])this.object);
                }

                @Override
                protected boolean isEqualTo(@NotNull float[] fArray) {
                    return Primitives.areEqual((float[])this.object, fArray);
                }
            };
        }
    };
    public static final Subjectivity DEEP_NATURAL_FP = new Subjectivity(true, DOUBLE_SUBJECTIVE, FLOAT_SUBJECTIVE, DOUBLE_ARRAY_SUBJECTIVE, FLOAT_ARRAY_SUBJECTIVE);

    private Primitives() {
    }

    public static int unsigned(byte by) {
        return by & 0xFF;
    }

    public static int unsigned(short s) {
        return s & 0xFFFF;
    }

    public static long unsigned(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int compareUnsigned(byte by, byte by2) {
        return Integer.compare(Primitives.unsigned(by), Primitives.unsigned(by2));
    }

    public static int compareUnsigned(short s, short s2) {
        return Integer.compare(Primitives.unsigned(s), Primitives.unsigned(s2));
    }

    private static int positionOfSingleBit(int n) {
        int n2;
        switch (n) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
        }
        int n3 = n >>> 16;
        if (n3 == 0) {
            n2 = 0;
        } else {
            n2 = 16;
            n = n3;
        }
        n3 = n >> 8;
        if (n3 != 0) {
            n2 += 8;
            n = n3;
        }
        if ((n3 = n >> 4) != 0) {
            n2 += 4;
            n = n3;
        }
        if ((n3 = n >> 2) != 0) {
            n2 += 2;
            n = n3;
        }
        if ((n3 = n >> 1) != 0) {
            ++n2;
        }
        return n2;
    }

    private static int positionOfSingleBit(long l) {
        if (l == 0L) {
            return -1;
        }
        if (l == 1L) {
            return 0;
        }
        long l2 = l >>> 32;
        if (l2 != 0L) {
            return Primitives.positionOfSingleBit((int)l2) + 32;
        }
        return Primitives.positionOfSingleBit((int)l);
    }

    public static int positionOfHighestOneBit(int n) {
        int n2 = Integer.highestOneBit(n);
        return Primitives.positionOfSingleBit(n2);
    }

    public static int positionOfLowestOneBit(int n) {
        int n2 = Integer.lowestOneBit(n);
        return Primitives.positionOfSingleBit(n2);
    }

    public static int positionOfHighestOneBit(long l) {
        long l2 = Long.highestOneBit(l);
        return Primitives.positionOfSingleBit(l2);
    }

    public static int positionOfLowestOneBit(long l) {
        long l2 = Long.lowestOneBit(l);
        return Primitives.positionOfSingleBit(l2);
    }

    public static boolean areEqual(double d, double d2) {
        if (d == d2) {
            return true;
        }
        return Double.isNaN(d) && Double.isNaN(d2);
    }

    public static boolean areEqual(float f, float f2) {
        if (f == f2) {
            return true;
        }
        return Float.isNaN(f) && Float.isNaN(f2);
    }

    public static boolean areEqual(double d, double d2, double d3) {
        assert (d3 >= 0.0);
        return Math.abs(d - d2) <= d3;
    }

    public static boolean areEqual(float f, float f2, float f3) {
        assert (f3 >= 0.0f);
        return Math.abs(f - f2) <= f3;
    }

    public static boolean areEqual(@NotNull double[] dArray, @NotNull double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i = dArray.length - 1; i >= 0; --i) {
            if (Primitives.areEqual(dArray[i], dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(@NotNull float[] fArray, @NotNull float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i = fArray.length - 1; i >= 0; --i) {
            if (Primitives.areEqual(fArray[i], fArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static int hash(double d) {
        if (d == 0.0) {
            return 0;
        }
        if (Double.isNaN(d)) {
            return DOUBLE_NAN_HASH;
        }
        return Double.hashCode(d);
    }

    public static int hash(float f) {
        if (f == 0.0f) {
            return 0;
        }
        if (Float.isNaN(f)) {
            return FLOAT_NAN_HASH;
        }
        return Double.hashCode(f);
    }

    public static int hash(@Nullable double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n = 1;
        for (double d : dArray) {
            n = 31 * n + Primitives.hash(d);
        }
        return n;
    }

    public static int hash(@Nullable float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n = 1;
        for (float f : fArray) {
            n = 31 * n + Primitives.hash(f);
        }
        return n;
    }

    public static int hashAny(@Nullable Object object) {
        if (object == null) {
            return 0;
        }
        return DEEP_NATURAL_FP.substitute(object).hashCode();
    }

    public static boolean areEqual(@Nullable Object object, @Nullable Object object2) {
        if (object == object2) {
            return true;
        }
        if (object != null && object2 != null) {
            return DEEP_NATURAL_FP.substitute(object).equals(DEEP_NATURAL_FP.substitute(object2));
        }
        return false;
    }

    @NotNull
    public static Float boxed(float f) {
        return f == 0.0f ? FLOAT_BOXED_0 : Float.valueOf(f);
    }

    @NotNull
    public static Float boxedN(float f) {
        return f == 0.0f ? FLOAT_BOXED_0 : (Float.isNaN(f) ? FLOAT_BOXED_NAN : Float.valueOf(f));
    }

    @NotNull
    public static Double boxed(double d) {
        return d == 0.0 ? DOUBLE_BOXED_0 : Double.valueOf(d);
    }

    @NotNull
    public static Double boxedN(double d) {
        return d == 0.0 ? DOUBLE_BOXED_0 : (Double.isNaN(d) ? DOUBLE_BOXED_NAN : Double.valueOf(d));
    }

    public static int compare(double d, double d2) {
        if (d == d2) {
            return 0;
        }
        if (d < d2) {
            return -1;
        }
        if (d > d2) {
            return 1;
        }
        return Double.isNaN(d) ? (Double.isNaN(d2) ? 0 : 1) : -1;
    }

    public static int compare(float f, float f2) {
        if (f == f2) {
            return 0;
        }
        if (f < f2) {
            return -1;
        }
        if (f > f2) {
            return 1;
        }
        return Float.isNaN(f) ? (Float.isNaN(f2) ? 0 : 1) : -1;
    }

    @NotNull
    public static Order order(double d, double d2) {
        if (d == d2) {
            return Order.Same;
        }
        if (d < d2) {
            return Order.Ascending;
        }
        if (d > d2) {
            return Order.Descending;
        }
        return Double.isNaN(d) ? (Double.isNaN(d2) ? Order.Same : Order.Descending) : Order.Ascending;
    }

    @NotNull
    public static Order order(float f, float f2) {
        if (f == f2) {
            return Order.Same;
        }
        if (f < f2) {
            return Order.Ascending;
        }
        if (f > f2) {
            return Order.Descending;
        }
        return Float.isNaN(f) ? (Float.isNaN(f2) ? Order.Same : Order.Descending) : Order.Ascending;
    }
}

