/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.function.ShortConsumer;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;

public interface PrimitiveShortIterator
extends PrimitiveIterator<Short, ShortConsumer> {
    public static final PrimitiveShortIterator EMPTY = new PrimitiveShortIterator(){

        @Override
        public short nextShort() {
            throw new NoSuchElementException("Empty short iterator has no elements!");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void forEachRemaining(@NotNull ShortConsumer shortConsumer) {
        }

        @Override
        public void forEachRemaining(@NotNull Consumer<? super Short> consumer) {
        }
    };

    public short nextShort();

    @Override
    default public void forEachRemaining(@NotNull ShortConsumer shortConsumer) {
        Objects.requireNonNull(shortConsumer);
        while (this.hasNext()) {
            shortConsumer.accept(this.nextShort());
        }
    }

    @Override
    default public Short next() {
        return this.nextShort();
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Short> consumer) {
        if (consumer instanceof ShortConsumer) {
            this.forEachRemaining((ShortConsumer)((Object)consumer));
        } else {
            Objects.requireNonNull(consumer);
            this.forEachRemaining(consumer::accept);
        }
    }

    @NotNull
    default public PrimitiveIterator.OfInt asIntIterator() {
        return new PrimitiveIterator.OfInt(){

            @Override
            public int nextInt() {
                return PrimitiveShortIterator.this.nextShort();
            }

            @Override
            public boolean hasNext() {
                return PrimitiveShortIterator.this.hasNext();
            }
        };
    }

    @NotNull
    default public PrimitiveIterator.OfInt asUnsignedIntIterator() {
        return new PrimitiveIterator.OfInt(){

            @Override
            public int nextInt() {
                return PrimitiveShortIterator.this.nextShort() & 0xFFFF;
            }

            @Override
            public boolean hasNext() {
                return PrimitiveShortIterator.this.hasNext();
            }
        };
    }

    @NotNull
    default public PrimitiveIterator.OfLong asLongIterator() {
        return new PrimitiveIterator.OfLong(){

            @Override
            public long nextLong() {
                return PrimitiveShortIterator.this.nextShort();
            }

            @Override
            public boolean hasNext() {
                return PrimitiveShortIterator.this.hasNext();
            }
        };
    }

    @NotNull
    default public PrimitiveIterator.OfLong asUnsignedLongIterator() {
        return new PrimitiveIterator.OfLong(){

            @Override
            public long nextLong() {
                return (long)PrimitiveShortIterator.this.nextShort() & 0xFFFFL;
            }

            @Override
            public boolean hasNext() {
                return PrimitiveShortIterator.this.hasNext();
            }
        };
    }
}

