/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.PrimitiveIntIterable;
import de.caff.generics.PrimitiveLongIterable;
import de.caff.generics.PrimitiveShortIterator;
import de.caff.generics.function.FragileShortConsumer;
import de.caff.generics.function.ShortConsumer;
import java.util.Iterator;

public interface PrimitiveShortIterable
extends Iterable<Short> {
    public static final PrimitiveShortIterator EMPTY_SHORT_ITERATOR = PrimitiveShortIterator.EMPTY;
    public static final PrimitiveShortIterable EMPTY = () -> EMPTY_SHORT_ITERATOR;

    @NotNull
    public PrimitiveShortIterator shortIterator();

    @Override
    @NotNull
    default public Iterator<Short> iterator() {
        return this.shortIterator();
    }

    default public void forEachShort(@NotNull ShortConsumer shortConsumer) {
        PrimitiveShortIterator primitiveShortIterator = this.shortIterator();
        while (primitiveShortIterator.hasNext()) {
            shortConsumer.accept(primitiveShortIterator.nextShort());
        }
    }

    default public <E extends Exception> void forEachShortFragile(@NotNull FragileShortConsumer<E> fragileShortConsumer) throws E {
        PrimitiveShortIterator primitiveShortIterator = this.shortIterator();
        while (primitiveShortIterator.hasNext()) {
            fragileShortConsumer.accept(primitiveShortIterator.nextShort());
        }
    }

    default public boolean containsShort(short s) {
        PrimitiveShortIterator primitiveShortIterator = this.shortIterator();
        while (primitiveShortIterator.hasNext()) {
            if (primitiveShortIterator.nextShort() != s) continue;
            return true;
        }
        return false;
    }

    @NotNull
    default public PrimitiveIntIterable asIntIterable() {
        return () -> this.shortIterator().asIntIterator();
    }

    @NotNull
    default public PrimitiveIntIterable asUnsignedIntIterable() {
        return () -> this.shortIterator().asUnsignedIntIterator();
    }

    @NotNull
    default public PrimitiveLongIterable asLongIterable() {
        return () -> this.shortIterator().asLongIterator();
    }

    @NotNull
    default public PrimitiveLongIterable asUnsignedLongIterable() {
        return () -> this.shortIterator().asUnsignedLongIterator();
    }
}

