/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.function.FragileLongConsumer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;

public interface PrimitiveLongIterable
extends Iterable<Long> {
    public static final PrimitiveIterator.OfLong EMPTY_LONG_ITERATOR = new PrimitiveIterator.OfLong(){

        @Override
        public long nextLong() {
            throw new NoSuchElementException("No elements in empty iterator!");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
        }

        @Override
        public void forEachRemaining(Consumer<? super Long> consumer) {
        }
    };
    public static final PrimitiveLongIterable EMPTY = () -> EMPTY_LONG_ITERATOR;

    @NotNull
    public PrimitiveIterator.OfLong longIterator();

    @Override
    @NotNull
    default public Iterator<Long> iterator() {
        return this.longIterator();
    }

    default public void forEachLong(@NotNull LongConsumer longConsumer) {
        PrimitiveIterator.OfLong ofLong = this.longIterator();
        while (ofLong.hasNext()) {
            longConsumer.accept(ofLong.nextLong());
        }
    }

    default public <E extends Exception> void forEachLongFragile(@NotNull FragileLongConsumer<E> fragileLongConsumer) throws E {
        PrimitiveIterator.OfLong ofLong = this.longIterator();
        while (ofLong.hasNext()) {
            fragileLongConsumer.accept(ofLong.nextLong());
        }
    }

    default public boolean containsLong(long l) {
        PrimitiveIterator.OfLong ofLong = this.longIterator();
        while (ofLong.hasNext()) {
            if (ofLong.nextLong() != l) continue;
            return true;
        }
        return false;
    }

    default public long sum() {
        long l = 0L;
        PrimitiveIterator.OfLong ofLong = this.longIterator();
        while (ofLong.hasNext()) {
            l += ofLong.nextLong();
        }
        return l;
    }

    default public long sumX() {
        long l = 0L;
        PrimitiveIterator.OfLong ofLong = this.longIterator();
        while (ofLong.hasNext()) {
            l = Math.addExact(l, ofLong.nextLong());
        }
        return l;
    }

    @NotNull
    default public OptionalDouble average() {
        int n = 0;
        double d = 0.0;
        PrimitiveIterator.OfLong ofLong = this.longIterator();
        while (ofLong.hasNext()) {
            d = (d * (double)n + (double)ofLong.nextLong()) / (double)(++n);
        }
        return n == 0 ? OptionalDouble.empty() : OptionalDouble.of(d);
    }

    default public Spliterator.OfLong spliterator() {
        return Spliterators.spliteratorUnknownSize(this.longIterator(), 16);
    }

    @NotNull
    default public LongStream stream() {
        return StreamSupport.longStream(this.spliterator(), false);
    }
}

