/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.function.FragileIntConsumer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;

public interface PrimitiveIntIterable
extends Iterable<Integer> {
    public static final PrimitiveIterator.OfInt EMPTY_INT_ITERATOR = new PrimitiveIterator.OfInt(){

        @Override
        public int nextInt() {
            throw new NoSuchElementException("No elements in empty iterator!");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
        }

        @Override
        public void forEachRemaining(Consumer<? super Integer> consumer) {
        }
    };
    public static final PrimitiveIntIterable EMPTY = () -> EMPTY_INT_ITERATOR;

    @NotNull
    public PrimitiveIterator.OfInt intIterator();

    @Override
    @NotNull
    default public Iterator<Integer> iterator() {
        return this.intIterator();
    }

    default public void forEachInt(@NotNull IntConsumer intConsumer) {
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            intConsumer.accept(ofInt.nextInt());
        }
    }

    default public <E extends Exception> void forEachIntFragile(@NotNull FragileIntConsumer<E> fragileIntConsumer) throws E {
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            fragileIntConsumer.accept(ofInt.nextInt());
        }
    }

    default public boolean containsInt(int n) {
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            if (ofInt.nextInt() != n) continue;
            return true;
        }
        return false;
    }

    default public int sum() {
        int n = 0;
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            n += ofInt.nextInt();
        }
        return n;
    }

    default public int sumX() {
        int n = 0;
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            n = Math.addExact(n, ofInt.nextInt());
        }
        return n;
    }

    default public long longSum() {
        long l = 0L;
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            l += (long)ofInt.nextInt();
        }
        return l;
    }

    default public long longSumX() {
        long l = 0L;
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            l = Math.addExact(l, (long)ofInt.nextInt());
        }
        return l;
    }

    @NotNull
    default public OptionalDouble average() {
        int n = 0;
        double d = 0.0;
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            d = (d * (double)n + (double)ofInt.nextInt()) / (double)(++n);
        }
        return n == 0 ? OptionalDouble.empty() : OptionalDouble.of(d);
    }

    default public Spliterator.OfInt spliterator() {
        return Spliterators.spliteratorUnknownSize(this.intIterator(), 16);
    }

    @NotNull
    default public IntStream stream() {
        return StreamSupport.intStream(this.spliterator(), false);
    }
}

