/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.function.FloatConsumer;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;

public interface PrimitiveFloatIterator
extends PrimitiveIterator<Float, FloatConsumer> {
    public static final PrimitiveFloatIterator EMPTY = new PrimitiveFloatIterator(){

        @Override
        public float nextFloat() {
            throw new NoSuchElementException("Empty float iterator has no elements!");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void forEachRemaining(@NotNull FloatConsumer floatConsumer) {
        }

        @Override
        public void forEachRemaining(@NotNull Consumer<? super Float> consumer) {
        }
    };

    public float nextFloat();

    @Override
    default public void forEachRemaining(@NotNull FloatConsumer floatConsumer) {
        Objects.requireNonNull(floatConsumer);
        while (this.hasNext()) {
            floatConsumer.accept(this.nextFloat());
        }
    }

    @Override
    default public Float next() {
        return Float.valueOf(this.nextFloat());
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Float> consumer) {
        if (consumer instanceof FloatConsumer) {
            this.forEachRemaining((FloatConsumer)((Object)consumer));
        } else {
            Objects.requireNonNull(consumer);
            this.forEachRemaining(consumer::accept);
        }
    }

    @NotNull
    default public PrimitiveIterator.OfDouble asDoubleIterator() {
        return new PrimitiveIterator.OfDouble(){

            @Override
            public double nextDouble() {
                return PrimitiveFloatIterator.this.nextFloat();
            }

            @Override
            public boolean hasNext() {
                return PrimitiveFloatIterator.this.hasNext();
            }
        };
    }
}

