/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.PrimitiveDoubleIterable;
import de.caff.generics.PrimitiveFloatIterator;
import de.caff.generics.function.FloatConsumer;
import de.caff.generics.function.FragileFloatConsumer;
import java.util.Iterator;

public interface PrimitiveFloatIterable
extends Iterable<Float> {
    public static final PrimitiveFloatIterator EMPTY_FLOAT_ITERATOR = PrimitiveFloatIterator.EMPTY;
    public static final PrimitiveFloatIterable EMPTY = () -> EMPTY_FLOAT_ITERATOR;

    @NotNull
    public PrimitiveFloatIterator floatIterator();

    @Override
    @NotNull
    default public Iterator<Float> iterator() {
        return this.floatIterator();
    }

    default public void forEachFloat(@NotNull FloatConsumer floatConsumer) {
        PrimitiveFloatIterator primitiveFloatIterator = this.floatIterator();
        while (primitiveFloatIterator.hasNext()) {
            floatConsumer.accept(primitiveFloatIterator.nextFloat());
        }
    }

    default public <E extends Exception> void forEachFloatFragile(@NotNull FragileFloatConsumer<E> fragileFloatConsumer) throws E {
        PrimitiveFloatIterator primitiveFloatIterator = this.floatIterator();
        while (primitiveFloatIterator.hasNext()) {
            fragileFloatConsumer.accept(primitiveFloatIterator.nextFloat());
        }
    }

    default public boolean containsFloat(float f) {
        PrimitiveFloatIterator primitiveFloatIterator = this.floatIterator();
        while (primitiveFloatIterator.hasNext()) {
            if (primitiveFloatIterator.nextFloat() != f) continue;
            return true;
        }
        return false;
    }

    default public boolean containsFloat(float f, float f2) {
        PrimitiveFloatIterator primitiveFloatIterator = this.floatIterator();
        while (primitiveFloatIterator.hasNext()) {
            if (!(Math.abs(primitiveFloatIterator.nextFloat() - f) <= f2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    default public PrimitiveDoubleIterable asDoubleIterable() {
        return () -> this.floatIterator().asDoubleIterator();
    }
}

