/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.function.FragileDoubleConsumer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;

public interface PrimitiveDoubleIterable
extends Iterable<Double> {
    public static final PrimitiveIterator.OfDouble EMPTY_DOUBLE_ITERATOR = new PrimitiveIterator.OfDouble(){

        @Override
        public double nextDouble() {
            throw new NoSuchElementException("No elements in empty iterator!");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
        }

        @Override
        public void forEachRemaining(Consumer<? super Double> consumer) {
        }
    };
    public static final PrimitiveDoubleIterable EMPTY = () -> EMPTY_DOUBLE_ITERATOR;

    @NotNull
    public PrimitiveIterator.OfDouble doubleIterator();

    @Override
    @NotNull
    default public Iterator<Double> iterator() {
        return this.doubleIterator();
    }

    default public void forEachDouble(@NotNull DoubleConsumer doubleConsumer) {
        PrimitiveIterator.OfDouble ofDouble = this.doubleIterator();
        while (ofDouble.hasNext()) {
            doubleConsumer.accept(ofDouble.nextDouble());
        }
    }

    default public <E extends Exception> void forEachDoubleFragile(@NotNull FragileDoubleConsumer<E> fragileDoubleConsumer) throws E {
        PrimitiveIterator.OfDouble ofDouble = this.doubleIterator();
        while (ofDouble.hasNext()) {
            fragileDoubleConsumer.accept(ofDouble.nextDouble());
        }
    }

    default public boolean containsDouble(double d) {
        PrimitiveIterator.OfDouble ofDouble = this.doubleIterator();
        while (ofDouble.hasNext()) {
            if (ofDouble.nextDouble() != d) continue;
            return true;
        }
        return false;
    }

    default public boolean containsDouble(double d, double d2) {
        PrimitiveIterator.OfDouble ofDouble = this.doubleIterator();
        while (ofDouble.hasNext()) {
            if (!(Math.abs(ofDouble.nextDouble() - d) <= d2)) continue;
            return true;
        }
        return false;
    }

    default public double sum() {
        double d = 0.0;
        PrimitiveIterator.OfDouble ofDouble = this.doubleIterator();
        while (ofDouble.hasNext()) {
            d += ofDouble.nextDouble();
        }
        return d;
    }

    @NotNull
    default public OptionalDouble average() {
        int n = 0;
        double d = 0.0;
        PrimitiveIterator.OfDouble ofDouble = this.doubleIterator();
        while (ofDouble.hasNext()) {
            d = (d * (double)n + ofDouble.nextDouble()) / (double)(++n);
        }
        return n == 0 ? OptionalDouble.empty() : OptionalDouble.of(d);
    }

    default public Spliterator.OfDouble spliterator() {
        return Spliterators.spliteratorUnknownSize(this.doubleIterator(), 16);
    }

    @NotNull
    default public DoubleStream stream() {
        return StreamSupport.doubleStream(this.spliterator(), false);
    }
}

