/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.function.CharConsumer;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;

public interface PrimitiveCharIterator
extends PrimitiveIterator<Character, CharConsumer> {
    public static final PrimitiveCharIterator EMPTY = new PrimitiveCharIterator(){

        @Override
        public char nextChar() {
            throw new NoSuchElementException("Empty char iterator has no elements!");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void forEachRemaining(@NotNull CharConsumer charConsumer) {
        }

        @Override
        public void forEachRemaining(@NotNull Consumer<? super Character> consumer) {
        }
    };

    public char nextChar();

    @Override
    default public void forEachRemaining(@NotNull CharConsumer charConsumer) {
        Objects.requireNonNull(charConsumer);
        while (this.hasNext()) {
            charConsumer.accept(this.nextChar());
        }
    }

    @Override
    default public Character next() {
        return Character.valueOf(this.nextChar());
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Character> consumer) {
        if (consumer instanceof CharConsumer) {
            this.forEachRemaining((CharConsumer)((Object)consumer));
        } else {
            Objects.requireNonNull(consumer);
            this.forEachRemaining(consumer::accept);
        }
    }

    @NotNull
    default public PrimitiveIterator.OfInt asIntIterator() {
        return new PrimitiveIterator.OfInt(){

            @Override
            public int nextInt() {
                return PrimitiveCharIterator.this.nextChar();
            }

            @Override
            public boolean hasNext() {
                return PrimitiveCharIterator.this.hasNext();
            }
        };
    }

    @NotNull
    default public PrimitiveIterator.OfLong asLongIterator() {
        return new PrimitiveIterator.OfLong(){

            @Override
            public long nextLong() {
                return PrimitiveCharIterator.this.nextChar();
            }

            @Override
            public boolean hasNext() {
                return PrimitiveCharIterator.this.hasNext();
            }
        };
    }
}

