/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.PrimitiveCharIterator;
import de.caff.generics.PrimitiveIntIterable;
import de.caff.generics.PrimitiveLongIterable;
import de.caff.generics.function.CharConsumer;
import de.caff.generics.function.FragileCharConsumer;
import java.util.Iterator;

public interface PrimitiveCharIterable
extends Iterable<Character> {
    public static final PrimitiveCharIterator EMPTY_CHAR_ITERATOR = PrimitiveCharIterator.EMPTY;
    public static final PrimitiveCharIterable EMPTY = () -> EMPTY_CHAR_ITERATOR;

    @NotNull
    public PrimitiveCharIterator charIterator();

    @Override
    @NotNull
    default public Iterator<Character> iterator() {
        return this.charIterator();
    }

    default public void forEachChar(@NotNull CharConsumer charConsumer) {
        PrimitiveCharIterator primitiveCharIterator = this.charIterator();
        while (primitiveCharIterator.hasNext()) {
            charConsumer.accept(primitiveCharIterator.nextChar());
        }
    }

    default public <E extends Exception> void forEachCharFragile(@NotNull FragileCharConsumer<E> fragileCharConsumer) throws E {
        PrimitiveCharIterator primitiveCharIterator = this.charIterator();
        while (primitiveCharIterator.hasNext()) {
            fragileCharConsumer.accept(primitiveCharIterator.nextChar());
        }
    }

    default public boolean containsChar(char c) {
        PrimitiveCharIterator primitiveCharIterator = this.charIterator();
        while (primitiveCharIterator.hasNext()) {
            if (primitiveCharIterator.nextChar() != c) continue;
            return true;
        }
        return false;
    }

    @NotNull
    default public PrimitiveIntIterable asIntIterable() {
        return () -> this.charIterator().asIntIterator();
    }

    @NotNull
    default public PrimitiveLongIterable asLongIterable() {
        return () -> this.charIterator().asLongIterator();
    }
}

