/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.PrimitiveShortIterator;
import de.caff.generics.function.ByteConsumer;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;

public interface PrimitiveByteIterator
extends PrimitiveIterator<Byte, ByteConsumer> {
    public static final PrimitiveByteIterator EMPTY = new PrimitiveByteIterator(){

        @Override
        public byte nextByte() {
            throw new NoSuchElementException("Empty byte iterator has no elements!");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void forEachRemaining(@NotNull ByteConsumer byteConsumer) {
        }

        @Override
        public void forEachRemaining(@NotNull Consumer<? super Byte> consumer) {
        }
    };

    public byte nextByte();

    @Override
    default public void forEachRemaining(@NotNull ByteConsumer byteConsumer) {
        Objects.requireNonNull(byteConsumer);
        while (this.hasNext()) {
            byteConsumer.accept(this.nextByte());
        }
    }

    @Override
    default public Byte next() {
        return this.nextByte();
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Byte> consumer) {
        if (consumer instanceof ByteConsumer) {
            this.forEachRemaining((ByteConsumer)((Object)consumer));
        } else {
            Objects.requireNonNull(consumer);
            this.forEachRemaining(consumer::accept);
        }
    }

    @NotNull
    default public PrimitiveShortIterator asShortIterator() {
        return new PrimitiveShortIterator(){

            @Override
            public short nextShort() {
                return PrimitiveByteIterator.this.nextByte();
            }

            @Override
            public boolean hasNext() {
                return PrimitiveByteIterator.this.hasNext();
            }
        };
    }

    @NotNull
    default public PrimitiveIterator.OfInt asIntIterator() {
        return new PrimitiveIterator.OfInt(){

            @Override
            public int nextInt() {
                return PrimitiveByteIterator.this.nextByte();
            }

            @Override
            public boolean hasNext() {
                return PrimitiveByteIterator.this.hasNext();
            }
        };
    }

    @NotNull
    default public PrimitiveIterator.OfInt asUnsignedIntIterator() {
        return new PrimitiveIterator.OfInt(){

            @Override
            public int nextInt() {
                return PrimitiveByteIterator.this.nextByte() & 0xFF;
            }

            @Override
            public boolean hasNext() {
                return PrimitiveByteIterator.this.hasNext();
            }
        };
    }

    @NotNull
    default public PrimitiveIterator.OfLong asLongIterator() {
        return new PrimitiveIterator.OfLong(){

            @Override
            public long nextLong() {
                return PrimitiveByteIterator.this.nextByte();
            }

            @Override
            public boolean hasNext() {
                return PrimitiveByteIterator.this.hasNext();
            }
        };
    }

    @NotNull
    default public PrimitiveIterator.OfLong asUnsignedLongIterator() {
        return new PrimitiveIterator.OfLong(){

            @Override
            public long nextLong() {
                return (long)PrimitiveByteIterator.this.nextByte() & 0xFFL;
            }

            @Override
            public boolean hasNext() {
                return PrimitiveByteIterator.this.hasNext();
            }
        };
    }
}

