/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.PrimitiveByteIterator;
import de.caff.generics.PrimitiveIntIterable;
import de.caff.generics.PrimitiveLongIterable;
import de.caff.generics.PrimitiveShortIterable;
import de.caff.generics.function.ByteConsumer;
import de.caff.generics.function.FragileByteConsumer;
import java.util.Iterator;

public interface PrimitiveByteIterable
extends Iterable<Byte> {
    public static final PrimitiveByteIterator EMPTY_BYTE_ITERATOR = PrimitiveByteIterator.EMPTY;
    public static final PrimitiveByteIterable EMPTY = () -> EMPTY_BYTE_ITERATOR;

    @NotNull
    public PrimitiveByteIterator byteIterator();

    @Override
    @NotNull
    default public Iterator<Byte> iterator() {
        return this.byteIterator();
    }

    default public void forEachByte(@NotNull ByteConsumer byteConsumer) {
        PrimitiveByteIterator primitiveByteIterator = this.byteIterator();
        while (primitiveByteIterator.hasNext()) {
            byteConsumer.accept(primitiveByteIterator.nextByte());
        }
    }

    default public <E extends Exception> void forEachByteFragile(@NotNull FragileByteConsumer<E> fragileByteConsumer) throws E {
        PrimitiveByteIterator primitiveByteIterator = this.byteIterator();
        while (primitiveByteIterator.hasNext()) {
            fragileByteConsumer.accept(primitiveByteIterator.nextByte());
        }
    }

    default public boolean containsByte(byte by) {
        PrimitiveByteIterator primitiveByteIterator = this.byteIterator();
        while (primitiveByteIterator.hasNext()) {
            if (primitiveByteIterator.nextByte() != by) continue;
            return true;
        }
        return false;
    }

    @NotNull
    default public PrimitiveShortIterable asShortIterable() {
        return () -> this.byteIterator().asShortIterator();
    }

    @NotNull
    default public PrimitiveIntIterable asIntIterable() {
        return () -> this.byteIterator().asIntIterator();
    }

    @NotNull
    default public PrimitiveIntIterable asUnsignedIntIterable() {
        return () -> this.byteIterator().asUnsignedIntIterator();
    }

    @NotNull
    default public PrimitiveLongIterable asLongIterable() {
        return () -> this.byteIterator().asLongIterator();
    }

    @NotNull
    default public PrimitiveLongIterable asUnsignedLongIterable() {
        return () -> this.byteIterator().asUnsignedLongIterator();
    }
}

