/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.function.BooleanConsumer;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;

public interface PrimitiveBooleanIterator
extends PrimitiveIterator<Boolean, BooleanConsumer> {
    public static final PrimitiveBooleanIterator EMPTY = new PrimitiveBooleanIterator(){

        @Override
        public boolean nextBool() {
            throw new NoSuchElementException("Empty boolean iterator has no elements!");
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public void forEachRemaining(@NotNull BooleanConsumer booleanConsumer) {
        }

        @Override
        public void forEachRemaining(@NotNull Consumer<? super Boolean> consumer) {
        }
    };

    public boolean nextBool();

    @Override
    default public void forEachRemaining(@NotNull BooleanConsumer booleanConsumer) {
        Objects.requireNonNull(booleanConsumer);
        while (this.hasNext()) {
            booleanConsumer.accept(this.nextBool());
        }
    }

    @Override
    default public Boolean next() {
        return this.nextBool();
    }

    @Override
    default public void forEachRemaining(@NotNull Consumer<? super Boolean> consumer) {
        if (consumer instanceof BooleanConsumer) {
            this.forEachRemaining((BooleanConsumer)((Object)consumer));
        } else {
            Objects.requireNonNull(consumer);
            this.forEachRemaining(consumer::accept);
        }
    }
}

