/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.PrimitiveBooleanIterator;
import de.caff.generics.function.BooleanConsumer;
import de.caff.generics.function.FragileBooleanConsumer;
import java.util.Iterator;

public interface PrimitiveBooleanIterable
extends Iterable<Boolean> {
    public static final PrimitiveBooleanIterator EMPTY_BOOLEAN_ITERATOR = PrimitiveBooleanIterator.EMPTY;
    public static final PrimitiveBooleanIterable EMPTY = () -> EMPTY_BOOLEAN_ITERATOR;

    @NotNull
    public PrimitiveBooleanIterator booleanIterator();

    @Override
    @NotNull
    default public Iterator<Boolean> iterator() {
        return this.booleanIterator();
    }

    default public void forEachBool(@NotNull BooleanConsumer booleanConsumer) {
        PrimitiveBooleanIterator primitiveBooleanIterator = this.booleanIterator();
        while (primitiveBooleanIterator.hasNext()) {
            booleanConsumer.accept(primitiveBooleanIterator.nextBool());
        }
    }

    @Deprecated
    default public <E extends Exception> void forEachBooleanFragile(@NotNull FragileBooleanConsumer<E> fragileBooleanConsumer) throws E {
        this.forEachBoolFragile(fragileBooleanConsumer);
    }

    default public <E extends Exception> void forEachBoolFragile(@NotNull FragileBooleanConsumer<E> fragileBooleanConsumer) throws E {
        PrimitiveBooleanIterator primitiveBooleanIterator = this.booleanIterator();
        while (primitiveBooleanIterator.hasNext()) {
            fragileBooleanConsumer.accept(primitiveBooleanIterator.nextBool());
        }
    }

    default public boolean containsBool(boolean bl) {
        PrimitiveBooleanIterator primitiveBooleanIterator = this.booleanIterator();
        while (primitiveBooleanIterator.hasNext()) {
            if (primitiveBooleanIterator.nextBool() != bl) continue;
            return true;
        }
        return false;
    }

    default public boolean containsTrue() {
        return this.containsBool(true);
    }

    default public boolean containsFalse() {
        return this.containsBool(false);
    }

    default public boolean or() {
        return this.containsTrue();
    }

    default public boolean and() {
        return !this.containsFalse();
    }

    default public boolean xor() {
        boolean bl = false;
        PrimitiveBooleanIterator primitiveBooleanIterator = this.booleanIterator();
        while (primitiveBooleanIterator.hasNext()) {
            bl ^= primitiveBooleanIterator.nextBool();
        }
        return bl;
    }
}

