/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Order;
import de.caff.generics.OrderedPair;
import de.caff.generics.function.Ordering;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Pair<T>
extends OrderedPair<T, T>
implements Iterable<T> {
    public Pair(T t, T t2) {
        super(t, t2);
    }

    void orderBy(@NotNull Ordering<? super T> ordering) {
        if (ordering.check(this.first, this.second) == Order.Descending) {
            this.swap();
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < 2;
            }

            @Override
            public T next() {
                if (this.pos < 2) {
                    switch (this.pos++) {
                        case 0: {
                            return Pair.this.first;
                        }
                        case 1: {
                            return Pair.this.second;
                        }
                    }
                }
                throw new NoSuchElementException("Cannot iterate more than twice in a Pair!");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot remove Pair item!");
            }
        };
    }

    public void swap() {
        Object object = this.first;
        this.first = this.second;
        this.second = object;
    }

    public T get(int n) {
        switch (n) {
            case 0: {
                return (T)this.first;
            }
            case 1: {
                return (T)this.second;
            }
        }
        throw new IllegalArgumentException("Only allowed indexes are 0 or 1!");
    }

    public void set(int n, T t) {
        switch (n) {
            case 0: {
                this.first = t;
                break;
            }
            case 1: {
                this.second = t;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only allowed indexes are 0 or 1!");
            }
        }
    }

    public static <S extends Comparable<S>> Comparator<Pair<S>> getFirstEntryPairComparator() {
        return Comparator.comparing(pair -> (Comparable)pair.first);
    }

    @NotNull
    public static <S> Comparator<Pair<S>> getFirstEntryPairComparator(@NotNull Comparator<S> comparator) {
        return (pair, pair2) -> comparator.compare(pair.first, pair2.first);
    }

    @NotNull
    public static <S extends Comparable<S>> Comparator<Pair<S>> getSecondEntryPairComparator() {
        return Comparator.comparing(pair -> (Comparable)pair.second);
    }

    @NotNull
    public static <S> Comparator<Pair<S>> getSecondEntryPairComparator(@NotNull Comparator<S> comparator) {
        return (pair, pair2) -> comparator.compare(pair.second, pair2.second);
    }

    @NotNull
    public static <S extends Comparable<S>> Comparator<Pair<S>> getFirstThanSecondEntryPairComparator() {
        return Comparator.comparing(pair -> (Comparable)pair.first).thenComparing(pair -> (Comparable)pair.second);
    }

    @NotNull
    public static <S> Comparator<Pair<S>> getFirstThanSecondEntryPairComparator(@NotNull Comparator<S> comparator) {
        return (pair, pair2) -> {
            int n = comparator.compare(pair.first, pair2.first);
            return n == 0 ? comparator.compare(pair.second, pair2.second) : n;
        };
    }

    @NotNull
    public static <U> Pair<U> createPair(U u, U u2) {
        return new Pair<U>(u, u2);
    }
}

