/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.tuple.ITuple2;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

public class OrderedPair<S, T>
implements Map.Entry<S, T>,
ITuple2<S, T> {
    public S first;
    public T second;

    public OrderedPair(S s, T t) {
        this.first = s;
        this.second = t;
    }

    @Override
    public S getKey() {
        return this.first;
    }

    @Override
    public T getValue() {
        return this.second;
    }

    @Override
    public T setValue(T t) {
        throw new UnsupportedOperationException("Not setting for ordered pairs used as map entries!");
    }

    @Override
    public S _1() {
        return this.first;
    }

    @Override
    public T _2() {
        return this.second;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OrderedPair orderedPair = (OrderedPair)object;
        return Objects.deepEquals(this.first, orderedPair.first) && Objects.deepEquals(this.second, orderedPair.second);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @NotNull
    public OrderedPair<T, S> swapped() {
        return OrderedPair.create(this.second, this.first);
    }

    public String toString() {
        return String.format("Pair(%s,%s)", this.first, this.second);
    }

    @NotNull
    public static <U extends Comparable<U>, V> Comparator<OrderedPair<U, V>> getFirstEntryOrderedPairComparator() {
        return Comparator.comparing(orderedPair -> (Comparable)orderedPair.first);
    }

    @NotNull
    public static <U, V> Comparator<OrderedPair<U, V>> getFirstEntryOrderedPairComparator(Comparator<U> comparator) {
        return (orderedPair, orderedPair2) -> comparator.compare(orderedPair.first, orderedPair2.first);
    }

    @NotNull
    public static <U, V extends Comparable<V>> Comparator<OrderedPair<U, V>> getSecondEntryOrderedPairComparator() {
        return Comparator.comparing(orderedPair -> (Comparable)orderedPair.second);
    }

    @NotNull
    public static <U, V> Comparator<OrderedPair<U, V>> getSecondEntryOrderedPairComparator(Comparator<V> comparator) {
        return (orderedPair, orderedPair2) -> comparator.compare(orderedPair.second, orderedPair2.second);
    }

    @NotNull
    public static <U, V> OrderedPair<U, V> create(U u, V v) {
        return new OrderedPair<U, V>(u, v);
    }

    @NotNull
    public static <U, V> OrderedPair<U, V> create(Map.Entry<U, V> entry) {
        return OrderedPair.create(entry.getKey(), entry.getValue());
    }
}

