/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Enums;
import de.caff.generics.Indexable;

public enum Order {
    Ascending(-1, true, false, false),
    Same(0, false, false, true),
    Descending(1, false, true, false);

    public final int comparison;
    public final boolean ascending;
    public final boolean ascendingOrSame;
    public final boolean descending;
    public final boolean descendingOrSame;
    public final boolean same;
    public final boolean different;
    private Order inverse;
    @NotNull
    public static final Indexable<Order> VALUES;

    private Order(int n2, boolean bl, boolean bl2, boolean bl3) {
        this.comparison = n2;
        this.ascending = bl;
        this.ascendingOrSame = bl || bl3;
        this.descending = bl2;
        this.descendingOrSame = bl2 || bl3;
        this.same = bl3;
        this.different = !bl3;
    }

    @NotNull
    public Order inverse() {
        return this.inverse;
    }

    @Nullable
    public static Order fromInternal(int n) {
        return Enums.getEnumFromOrdinal(VALUES, n);
    }

    @NotNull
    public static Order fromInternal(int n, @NotNull Order order) {
        return Enums.getEnumFromOrdinal(VALUES, n, order);
    }

    @NotNull
    public static Order fromCompare(int n) {
        return n < 0 ? Ascending : (n > 0 ? Descending : Same);
    }

    static {
        Order.Ascending.inverse = Descending;
        Order.Same.inverse = Same;
        Order.Descending.inverse = Ascending;
        VALUES = Indexable.viewArray(Order.values());
    }
}

