/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.Copyable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.MutableIntIndexable;
import de.caff.generics.PrimitiveShortIterator;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Types;
import de.caff.generics.algorithm.DualPivotQuicksort;
import de.caff.generics.function.FragileShortConsumer;
import de.caff.generics.function.IntToShortFunction1;
import de.caff.generics.function.ShortConsumer;
import de.caff.generics.function.ShortOperator2;
import de.caff.generics.function.ShortOrdering;
import de.caff.generics.function.ShortSetter;
import de.caff.generics.function.ToShortFunction;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface MutableShortIndexable
extends ShortIndexable,
Copyable<MutableShortIndexable> {
    public static final Base EMPTY = new Base(){

        @Override
        public void set(int n, short s) {
            throw new IndexOutOfBoundsException("Cannot set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public short get(int n) {
            throw new IndexOutOfBoundsException("Cannot get from empty indexable!");
        }

        @Override
        @NotNull
        public ListIterator<Short> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Short> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public PrimitiveShortIterator shortIterator() {
            return Types.EMPTY_SHORT_ITERATOR;
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfInt intIterator() {
            return Types.EMPTY_INT_ITERATOR;
        }

        @Override
        @NotNull
        public Collection<Short> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Short> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public short[] toArray() {
            return Empty.SHORT_ARRAY;
        }

        @Override
        public void initByIndex(@NotNull IntToShortFunction1 intToShortFunction1) {
        }

        @Override
        public void forEachShort(@NotNull ShortConsumer shortConsumer) {
        }

        @Override
        public <E extends Exception> void forEachShortFragile(@NotNull FragileShortConsumer<E> fragileShortConsumer) throws E {
        }

        @Override
        public boolean containsShort(short s) {
            return false;
        }

        @Override
        public int addToArray(@NotNull short[] sArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public IntIndexable.Base asIntIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable.Base asUnsignedIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        public short foldLeft(short s, @NotNull ShortOperator2 shortOperator2) {
            return s;
        }

        @Override
        @NotNull
        public ShortIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public MutableShortIndexable getCopy() {
            return this;
        }

        @Override
        public void forEach(Consumer<? super Short> consumer) {
        }

        @Override
        public void order() {
        }

        @Override
        @NotNull
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }
    };

    public void set(int var1, short var2);

    default public void syt(int n, short s) {
        int n2;
        if (n >= 0) {
            this.set(n, s);
        }
        if ((n2 = n + this.size()) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        this.set(n2, s);
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable) {
        return this.setFrom(iterable, 0, this.size());
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable, int n, int n2) {
        if (n > this.size() - n2) {
            n2 = this.size() - n;
        }
        int n3 = 0;
        for (Number number : iterable) {
            this.set(n + n3++, number.shortValue());
            if (n3 != n2) continue;
            break;
        }
        return n3;
    }

    default public void setFromArray(@NotNull short[] sArray, int n, int n2, int n3) {
        if (n2 + n3 > this.size()) {
            throw new IndexOutOfBoundsException("Overflow: numElements is too large!");
        }
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, sArray[n++]);
        }
    }

    default public void setMulti(int n, int n2, short s) {
        n = Pythonesque.mapX(n, this);
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative: " + n2);
        }
        int n3 = n + n2;
        if (n3 > this.size()) {
            throw new IndexOutOfBoundsException(String.format("from + len exceed size(): %d + %d > %d", n, n2, this.size()));
        }
        for (int i = n; i < n3; ++i) {
            this.set(i, s);
        }
    }

    default public void copyInternally(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("numElements must not be negative!");
        }
        int n4 = this.size();
        int n5 = Pythonesque.mapX(n, n4);
        int n6 = Pythonesque.mapX(n2, n4);
        if (n5 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n5, n3, n4));
        }
        if (n6 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n6, n3, n4));
        }
        if (n5 == n6) {
            return;
        }
        if (n5 < n6 && n5 + n3 > n6) {
            n5 += n3;
            n6 += n3;
            while (--n3 >= 0) {
                this.set(--n6, this.get(--n5));
            }
        } else {
            while (--n3 >= 0) {
                this.set(n6++, this.get(n5++));
            }
        }
    }

    default public void fillFrom(@NotNull IntToShortFunction1 intToShortFunction1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToShortFunction1.applyAsShort(i));
        }
    }

    default public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        short s = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, s);
    }

    default public void swyp(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.swap(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @Override
    @NotNull
    default public Base subSet(final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return new Base(){

            @Override
            public void set(int n4, short s) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                MutableShortIndexable.this.set(n4 + n, s);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public short get(int n4) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                return MutableShortIndexable.this.get(n4 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n22) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n22 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n4 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                }
                return MutableShortIndexable.this.subSet(n + n4, n + n22 - n4);
            }

            @Override
            public void copyInternally(int n6, int n22, int n32) {
                int n4 = Pythonesque.mapX(n, n3);
                int n5 = Pythonesque.mapX(n2, n3);
                if (n4 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n32, n3));
                }
                if (n5 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n32, n3));
                }
                MutableShortIndexable.this.copyInternally(n + n6, n + n22, n32);
            }
        };
    }

    @Override
    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(n < 0 ? this.size() + n : n, n2 < 0 ? this.size() + n2 : n2);
    }

    @Override
    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(n < 0 ? this.size() + n : n, this.size());
    }

    @Override
    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, n < 0 ? this.size() + n : n);
    }

    @Override
    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public void set(int n, short s) {
                MutableShortIndexable.this.set(this.size() - n - 1, s);
            }

            @Override
            public int size() {
                return MutableShortIndexable.this.size();
            }

            @Override
            public short get(int n) {
                return MutableShortIndexable.this.get(this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return MutableShortIndexable.based(MutableShortIndexable.this);
            }
        };
    }

    default public void initByIndex(@NotNull IntToShortFunction1 intToShortFunction1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToShortFunction1.applyAsShort(i));
        }
    }

    default public void revert(int n, int n2) {
        int n3 = this.size();
        int n4 = Pythonesque.map(n, n3);
        int n5 = Pythonesque.map(n2, n3);
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
    }

    default public void revert() {
        if (this.size() <= 1) {
            return;
        }
        this.revert(0, -1);
    }

    default public void order() {
        short[] sArray = this.toArray();
        Arrays.sort(sArray);
        this.fillFrom(n -> sArray[n]);
    }

    default public void order(@NotNull ShortOrdering shortOrdering) {
        short[] sArray = this.toArray();
        DualPivotQuicksort.sort(sArray, shortOrdering);
        this.fillFrom(n -> sArray[n]);
    }

    default public void shuffle(@NotNull Random random) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    @NotNull
    default public MutableIntIndexable.Base toMutableIntIndexable() {
        return MutableIntIndexable.viewArray(this.toIntArray());
    }

    @Override
    @NotNull
    default public List<Short> asList() {
        return new AbstractList<Short>(){

            @Override
            public Short get(int n) {
                return MutableShortIndexable.this.get(n);
            }

            @Override
            public int size() {
                return MutableShortIndexable.this.size();
            }

            @Override
            public Short set(int n, Short s) {
                MutableShortIndexable.this.set(n, s);
                return s;
            }

            @Override
            public Iterator<Short> iterator() {
                return MutableShortIndexable.this.iterator();
            }
        };
    }

    @Override
    @NotNull
    default public MutableShortIndexable getCopy() {
        return MutableShortIndexable.viewArray(this.toArray());
    }

    @NotNull
    public static Base based(final @NotNull MutableShortIndexable mutableShortIndexable) {
        if (mutableShortIndexable instanceof Base) {
            return (Base)mutableShortIndexable;
        }
        return new Base(){

            @Override
            public void set(int n, short s) {
                mutableShortIndexable.set(n, s);
            }

            @Override
            public int size() {
                return mutableShortIndexable.size();
            }

            @Override
            public short get(int n) {
                return mutableShortIndexable.get(n);
            }
        };
    }

    @NotNull
    public static Base init(int n, @NotNull Supplier<? extends Number> supplier) {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = supplier.get().shortValue();
        }
        return MutableShortIndexable.viewArray(sArray);
    }

    @NotNull
    public static Base initByIndex(int n, @NotNull IntToShortFunction1 intToShortFunction1) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = intToShortFunction1.applyAsShort(i);
        }
        return MutableShortIndexable.viewArray(sArray);
    }

    @NotNull
    public static Base copyOf(@NotNull Collection<? extends Number> collection) {
        short[] sArray = new short[collection.size()];
        int n = 0;
        for (Number number : collection) {
            sArray[n++] = number.shortValue();
        }
        return MutableShortIndexable.viewArray(sArray);
    }

    @NotNull
    public static <IN> Base copy(@NotNull Collection<IN> collection, @NotNull Function<IN, Number> function) {
        short[] sArray = new short[collection.size()];
        int n = 0;
        for (IN IN : collection) {
            sArray[n++] = function.apply(IN).shortValue();
        }
        return MutableShortIndexable.viewArray(sArray);
    }

    @NotNull
    public static Base empty() {
        return EMPTY;
    }

    @NotNull
    public static Base fromArray(short ... sArray) {
        return MutableShortIndexable.fromArray(sArray, 0, sArray.length);
    }

    @NotNull
    public static Base fromArray(@NotNull short[] sArray, int n, int n2) {
        if (n < 0 || n + n2 > sArray.length) {
            throw new IllegalArgumentException("Indexes out of bounds!");
        }
        return MutableShortIndexable.viewArray(Arrays.copyOfRange(sArray, n, n + n2));
    }

    @NotNull
    public static Base viewArray(final @NotNull short[] sArray) {
        return new Base(){

            @Override
            public void set(int n, short s) {
                sArray[n] = s;
            }

            @Override
            public int size() {
                return sArray.length;
            }

            @Override
            public short get(int n) {
                return sArray[n];
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return MutableShortIndexable.viewArray(sArray, n, n2 - n);
            }

            @Override
            public void copyInternally(int n, int n2, int n3) {
                System.arraycopy(sArray, n, sArray, n2, n3);
            }

            @Override
            public void order() {
                Arrays.sort(sArray);
            }

            @Override
            public void order(@NotNull ShortOrdering shortOrdering) {
                DualPivotQuicksort.sort(sArray, shortOrdering);
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull short[] sArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative, but is " + n2);
        }
        if (n + n2 > sArray.length) {
            throw new IndexOutOfBoundsException(String.format("end will be outside array: %d + %d > %d", n, n2, sArray.length));
        }
        if (n2 == 0) {
            return MutableShortIndexable.empty();
        }
        return new Base(){

            @Override
            public void set(int n3, short s) {
                sArray[n3 + n] = s;
            }

            @Override
            public short get(int n3) {
                return sArray[n3 + n];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return MutableShortIndexable.viewArray(sArray, n3 + n, n22 - n3);
            }

            @Override
            public void copyInternally(int n6, int n22, int n3) {
                if (n3 == 0) {
                    return;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("numElements must not be negative!");
                }
                int n4 = Pythonesque.mapX(n6, n2);
                int n5 = Pythonesque.mapX(n22, n2);
                if (n4 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n3, n2));
                }
                if (n5 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n3, n2));
                }
                if (n4 == n5) {
                    return;
                }
                System.arraycopy(sArray, n6 + n, sArray, n22 + n, n3);
            }

            @Override
            public void order() {
                Arrays.sort(sArray, n, n + n2);
            }

            @Override
            public void order(@NotNull ShortOrdering shortOrdering) {
                DualPivotQuicksort.sort(sArray, n, n + n2 - 1, shortOrdering);
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<Short> list) {
        return new Base(){

            @Override
            public void set(int n, short s) {
                list.set(n, s);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public short get(int n) {
                return (Short)list.get(n);
            }
        };
    }

    @NotNull
    public static Base fromIndexable(@NotNull Indexable<? extends Number> indexable) {
        return MutableShortIndexable.copyOf(indexable.asCollection());
    }

    @NotNull
    public static <B> Base fromIndexable(@NotNull Indexable<B> indexable, @NotNull Function<? super B, ? extends Number> function) {
        short[] sArray = new short[indexable.size()];
        int n = 0;
        for (B b : indexable) {
            sArray[n++] = function.apply(b).shortValue();
        }
        return MutableShortIndexable.viewArray(sArray);
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToShortFunction<? super T> toShortFunction, final @NotNull ShortSetter<? super T> shortSetter) {
        return new Base(){

            @Override
            public void set(int n, short s) {
                shortSetter.set(indexable.get(n), s);
            }

            @Override
            public short get(int n) {
                return toShortFunction.applyAsShort(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }
        };
    }

    @NotNull
    public static Base fromDoubleIndexable(@NotNull DoubleIndexable doubleIndexable) {
        return MutableShortIndexable.initByIndex(doubleIndexable.size(), n -> (short)doubleIndexable.get(n));
    }

    @NotNull
    public static Base fromFloatIndexable(@NotNull FloatIndexable floatIndexable) {
        return MutableShortIndexable.initByIndex(floatIndexable.size(), n -> (short)floatIndexable.get(n));
    }

    @NotNull
    public static Base fromLongIndexable(@NotNull LongIndexable longIndexable) {
        return MutableShortIndexable.initByIndex(longIndexable.size(), n -> (short)longIndexable.get(n));
    }

    @NotNull
    public static Base fromIntIndexable(@NotNull IntIndexable intIndexable) {
        return MutableShortIndexable.initByIndex(intIndexable.size(), n -> (short)intIndexable.get(n));
    }

    @NotNull
    public static Base fromShortIndexable(@NotNull ShortIndexable shortIndexable) {
        return MutableShortIndexable.initByIndex(shortIndexable.size(), shortIndexable::get);
    }

    @NotNull
    public static Base fromByteIndexable(@NotNull ByteIndexable byteIndexable) {
        return MutableShortIndexable.initByIndex(byteIndexable.size(), byteIndexable::get);
    }

    @NotNull
    public static Base fromIterable(int n, @NotNull Iterable<? extends Number> iterable) {
        short[] sArray = new short[n];
        int n2 = 0;
        for (Number number : iterable) {
            sArray[n2++] = number.shortValue();
            if (n2 != n) continue;
            break;
        }
        return MutableShortIndexable.viewArray(sArray);
    }

    @NotNull
    public static Base zeroed(int n) {
        return MutableShortIndexable.viewArray(new short[n]);
    }

    @NotNull
    public static Base init(int n, short s) {
        short[] sArray = new short[n];
        Arrays.fill(sArray, s);
        return MutableShortIndexable.viewArray(sArray);
    }

    public static abstract class Base
    extends ShortIndexable.Base
    implements MutableShortIndexable {
    }
}

