/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.Copyable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Types;
import de.caff.generics.algorithm.DualPivotQuicksort;
import de.caff.generics.algorithm.TimSortLong;
import de.caff.generics.function.LongOrdering;
import de.caff.generics.function.LongSetter;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntToLongFunction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.ToLongFunction;

public interface MutableLongIndexable
extends LongIndexable,
Copyable<MutableLongIndexable> {
    public static final Base EMPTY = new Base(){

        @Override
        public void set(int n, long l) {
            throw new IndexOutOfBoundsException("Cannot set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public long get(int n) {
            throw new IndexOutOfBoundsException("Cannot get from empty indexable!");
        }

        @Override
        @NotNull
        public ListIterator<Long> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Long> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfLong longIterator() {
            return Types.EMPTY_LONG_ITERATOR;
        }

        @Override
        @NotNull
        public Collection<Long> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Long> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        public long foldLeft(long l, @NotNull LongBinaryOperator longBinaryOperator) {
            return l;
        }

        @Override
        @NotNull
        public long[] toArray() {
            return Empty.LONG_ARRAY;
        }

        @Override
        public int addToArray(@NotNull long[] lArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public LongIndexable frozen() {
            return this;
        }

        @Override
        public <E> Indexable<E> view(@NotNull LongFunction<E> longFunction) {
            return Indexable.emptyIndexable();
        }

        @Override
        public void initByIndex(@NotNull IntToLongFunction intToLongFunction) {
        }

        @Override
        public void forEachLong(@NotNull LongConsumer longConsumer) {
        }

        @Override
        public boolean containsLong(long l) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Long> consumer) {
        }

        @Override
        @NotNull
        public MutableLongIndexable getCopy() {
            return this;
        }

        @Override
        public long sum() {
            return 0L;
        }

        @Override
        public long sumX() {
            return 0L;
        }

        @Override
        public void order(@NotNull LongOrdering longOrdering) {
        }

        @Override
        public void order() {
        }

        @Override
        @NotNull
        public OptionalDouble average() {
            return OptionalDouble.empty();
        }

        @Override
        @NotNull
        public Spliterator.OfLong longSpliterator() {
            return Spliterators.emptyLongSpliterator();
        }

        @Override
        @NotNull
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }
    };

    public void set(int var1, long var2);

    default public void syt(int n, long l) {
        int n2;
        if (n >= 0) {
            this.set(n, l);
        }
        if ((n2 = n + this.size()) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        this.set(n2, l);
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable) {
        return this.setFrom(iterable, 0, this.size());
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable, int n, int n2) {
        if (n > this.size() - n2) {
            n2 = this.size() - n;
        }
        int n3 = 0;
        for (Number number : iterable) {
            this.set(n + n3++, number.longValue());
            if (n3 != n2) continue;
            break;
        }
        return n3;
    }

    default public void setFromArray(@NotNull long[] lArray, int n, int n2, int n3) {
        if (n2 + n3 > this.size()) {
            throw new IndexOutOfBoundsException("Overflow: numElements is too large!");
        }
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, lArray[n++]);
        }
    }

    default public void setMulti(int n, int n2, long l) {
        n = Pythonesque.mapX(n, this);
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative: " + n2);
        }
        int n3 = n + n2;
        if (n3 > this.size()) {
            throw new IndexOutOfBoundsException(String.format("from + len exceed size(): %d + %d > %d", n, n2, this.size()));
        }
        for (int i = n; i < n3; ++i) {
            this.set(i, l);
        }
    }

    default public void copyInternally(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("numElements must not be negative!");
        }
        int n4 = this.size();
        int n5 = Pythonesque.mapX(n, n4);
        int n6 = Pythonesque.mapX(n2, n4);
        if (n5 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n5, n3, n4));
        }
        if (n6 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n6, n3, n4));
        }
        if (n5 == n6) {
            return;
        }
        if (n5 < n6 && n5 + n3 > n6) {
            n5 += n3;
            n6 += n3;
            while (--n3 >= 0) {
                this.set(--n6, this.get(--n5));
            }
        } else {
            while (--n3 >= 0) {
                this.set(n6++, this.get(n5++));
            }
        }
    }

    default public void fillFrom(@NotNull IntToLongFunction intToLongFunction) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToLongFunction.applyAsLong(i));
        }
    }

    default public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        long l = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, l);
    }

    default public void swyp(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.swap(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @Override
    @NotNull
    default public Base subSet(final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return new Base(){

            @Override
            public void set(int n4, long l) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                MutableLongIndexable.this.set(n4 + n, l);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public long get(int n4) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                return MutableLongIndexable.this.get(n4 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n22) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n22 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n4 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                }
                return MutableLongIndexable.this.subSet(n + n4, n + n22 - n4);
            }

            @Override
            public void copyInternally(int n6, int n22, int n32) {
                int n4 = Pythonesque.mapX(n, n3);
                int n5 = Pythonesque.mapX(n2, n3);
                if (n4 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n32, n3));
                }
                if (n5 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n32, n3));
                }
                MutableLongIndexable.this.copyInternally(n + n6, n + n22, n32);
            }
        };
    }

    @Override
    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(n < 0 ? this.size() + n : n, n2 < 0 ? this.size() + n2 : n2);
    }

    @Override
    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(n < 0 ? this.size() + n : n, this.size());
    }

    @Override
    default public Base headSet(int n) {
        return this.subSet(0, n < 0 ? this.size() + n : n);
    }

    @Override
    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public void set(int n, long l) {
                MutableLongIndexable.this.set(this.size() - n - 1, l);
            }

            @Override
            public int size() {
                return MutableLongIndexable.this.size();
            }

            @Override
            public long get(int n) {
                return MutableLongIndexable.this.get(this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return MutableLongIndexable.based(MutableLongIndexable.this);
            }
        };
    }

    default public void revert(int n, int n2) {
        int n3 = Pythonesque.map(n, this);
        int n4 = Pythonesque.map(n2, this);
        while (n3 < n4) {
            this.swap(n3++, n4--);
        }
    }

    default public void revert() {
        if (this.size() <= 1) {
            return;
        }
        this.revert(0, -1);
    }

    default public void order(@NotNull LongOrdering longOrdering) {
        TimSortLong.sort(this, longOrdering);
    }

    default public void order() {
        this.order(LongOrdering.ASCENDING);
    }

    default public void shuffle(@NotNull Random random) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    default public void initByIndex(@NotNull IntToLongFunction intToLongFunction) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToLongFunction.applyAsLong(i));
        }
    }

    @Override
    @NotNull
    default public List<Long> asList() {
        return new AbstractList<Long>(){

            @Override
            public Long get(int n) {
                return MutableLongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return MutableLongIndexable.this.size();
            }

            @Override
            public Long set(int n, Long l) {
                MutableLongIndexable.this.set(n, l);
                return l;
            }

            @Override
            public Iterator<Long> iterator() {
                return MutableLongIndexable.this.iterator();
            }
        };
    }

    @Override
    @NotNull
    default public MutableLongIndexable getCopy() {
        return MutableLongIndexable.viewArray(this.toArray());
    }

    @NotNull
    public static Base based(final @NotNull MutableLongIndexable mutableLongIndexable) {
        if (mutableLongIndexable instanceof Base) {
            return (Base)mutableLongIndexable;
        }
        return new Base(){

            @Override
            public void set(int n, long l) {
                mutableLongIndexable.set(n, l);
            }

            @Override
            public int size() {
                return mutableLongIndexable.size();
            }

            @Override
            public long get(int n) {
                return mutableLongIndexable.get(n);
            }
        };
    }

    @NotNull
    public static Base init(int n, @NotNull LongSupplier longSupplier) {
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = longSupplier.getAsLong();
        }
        return MutableLongIndexable.viewArray(lArray);
    }

    @NotNull
    public static Base initByIndex(int n, @NotNull IntToLongFunction intToLongFunction) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = intToLongFunction.applyAsLong(i);
        }
        return MutableLongIndexable.viewArray(lArray);
    }

    @NotNull
    public static Base copyOf(@NotNull Collection<? extends Number> collection) {
        long[] lArray = new long[collection.size()];
        int n = 0;
        for (Number number : collection) {
            lArray[n++] = number.longValue();
        }
        return MutableLongIndexable.viewArray(lArray);
    }

    @NotNull
    public static <IN> Base copy(@NotNull Collection<IN> collection, @NotNull Function<IN, Number> function) {
        long[] lArray = new long[collection.size()];
        int n = 0;
        for (IN IN : collection) {
            lArray[n++] = function.apply(IN).longValue();
        }
        return MutableLongIndexable.viewArray(lArray);
    }

    @NotNull
    public static Base empty() {
        return EMPTY;
    }

    @NotNull
    public static Base fromArray(long ... lArray) {
        return MutableLongIndexable.fromArray(lArray, 0, lArray.length);
    }

    @NotNull
    public static Base fromArray(@NotNull long[] lArray, int n, int n2) {
        if (n < 0 || n + n2 > lArray.length) {
            throw new IllegalArgumentException("Indexes out of bounds!");
        }
        return MutableLongIndexable.viewArray(Arrays.copyOfRange(lArray, n, n + n2));
    }

    @NotNull
    public static Base viewArray(final @NotNull long[] lArray) {
        return new Base(){

            @Override
            public void set(int n, long l) {
                lArray[n] = l;
            }

            @Override
            public int size() {
                return lArray.length;
            }

            @Override
            public long get(int n) {
                return lArray[n];
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return MutableLongIndexable.viewArray(lArray, n, n2 - n);
            }

            @Override
            public void copyInternally(int n, int n2, int n3) {
                System.arraycopy(lArray, n, lArray, n2, n3);
            }

            @Override
            public void order() {
                Arrays.sort(lArray);
            }

            @Override
            public void order(@NotNull LongOrdering longOrdering) {
                DualPivotQuicksort.sort(lArray, longOrdering);
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull long[] lArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative, but is " + n2);
        }
        if (n + n2 > lArray.length) {
            throw new IndexOutOfBoundsException(String.format("end will be outside array: %d + %d > %d", n, n2, lArray.length));
        }
        if (n2 == 0) {
            return MutableLongIndexable.empty();
        }
        return new Base(){

            @Override
            public void set(int n3, long l) {
                lArray[n3 + n] = l;
            }

            @Override
            public long get(int n3) {
                return lArray[n3 + n];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return MutableLongIndexable.viewArray(lArray, n3 + n, n22 - n3);
            }

            @Override
            public void copyInternally(int n6, int n22, int n3) {
                if (n3 == 0) {
                    return;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("numElements must not be negative!");
                }
                int n4 = Pythonesque.mapX(n6, n2);
                int n5 = Pythonesque.mapX(n22, n2);
                if (n4 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n3, n2));
                }
                if (n5 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n3, n2));
                }
                if (n4 == n5) {
                    return;
                }
                System.arraycopy(lArray, n6 + n, lArray, n22 + n, n3);
            }

            @Override
            public void order() {
                Arrays.sort(lArray, n, n + n2);
            }

            @Override
            public void order(@NotNull LongOrdering longOrdering) {
                DualPivotQuicksort.sort(lArray, n, n + n2 - 1, longOrdering);
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<Long> list) {
        return new Base(){

            @Override
            public void set(int n, long l) {
                list.set(n, l);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public long get(int n) {
                return (Long)list.get(n);
            }
        };
    }

    @NotNull
    public static Base fromIndexable(@NotNull Indexable<? extends Number> indexable) {
        return MutableLongIndexable.copyOf(indexable.asCollection());
    }

    @NotNull
    public static <B> Base fromIndexable(@NotNull Indexable<B> indexable, @NotNull Function<? super B, ? extends Number> function) {
        long[] lArray = new long[indexable.size()];
        int n = 0;
        for (B b : indexable) {
            lArray[n++] = function.apply(b).longValue();
        }
        return MutableLongIndexable.viewArray(lArray);
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToLongFunction<? super T> toLongFunction, final @NotNull LongSetter<? super T> longSetter) {
        return new Base(){

            @Override
            public void set(int n, long l) {
                longSetter.set(indexable.get(n), l);
            }

            @Override
            public long get(int n) {
                return toLongFunction.applyAsLong(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }
        };
    }

    @NotNull
    public static Base fromDoubleIndexable(@NotNull DoubleIndexable doubleIndexable) {
        return MutableLongIndexable.initByIndex(doubleIndexable.size(), n -> (long)doubleIndexable.get(n));
    }

    @NotNull
    public static Base fromFloatIndexable(@NotNull FloatIndexable floatIndexable) {
        return MutableLongIndexable.initByIndex(floatIndexable.size(), n -> (long)floatIndexable.get(n));
    }

    @NotNull
    public static Base fromLongIndexable(@NotNull LongIndexable longIndexable) {
        return MutableLongIndexable.initByIndex(longIndexable.size(), longIndexable::get);
    }

    @NotNull
    public static Base fromIntIndexable(@NotNull IntIndexable intIndexable) {
        return MutableLongIndexable.initByIndex(intIndexable.size(), intIndexable::get);
    }

    @NotNull
    public static Base fromShortIndexable(@NotNull ShortIndexable shortIndexable) {
        return MutableLongIndexable.initByIndex(shortIndexable.size(), shortIndexable::get);
    }

    @NotNull
    public static Base fromByteIndexable(@NotNull ByteIndexable byteIndexable) {
        return MutableLongIndexable.initByIndex(byteIndexable.size(), byteIndexable::get);
    }

    @NotNull
    public static Base fromIterable(int n, @NotNull Iterable<? extends Number> iterable) {
        long[] lArray = new long[n];
        int n2 = 0;
        for (Number number : iterable) {
            lArray[n2++] = number.longValue();
            if (n2 != n) continue;
            break;
        }
        return MutableLongIndexable.viewArray(lArray);
    }

    @NotNull
    public static Base zeroed(int n) {
        return MutableLongIndexable.viewArray(new long[n]);
    }

    @NotNull
    public static Base init(int n, long l) {
        long[] lArray = new long[n];
        Arrays.fill(lArray, l);
        return MutableLongIndexable.viewArray(lArray);
    }

    public static abstract class Base
    extends LongIndexable.Base
    implements MutableLongIndexable {
    }
}

