/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.CharIndexable;
import de.caff.generics.Copyable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Types;
import de.caff.generics.algorithm.DualPivotQuicksort;
import de.caff.generics.algorithm.TimSortInt;
import de.caff.generics.function.FragileIntConsumer;
import de.caff.generics.function.IntOrdering;
import de.caff.generics.function.IntSetter;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;

public interface MutableIntIndexable
extends IntIndexable,
Copyable<MutableIntIndexable> {
    public static final Base EMPTY = new Base(){

        @Override
        public void set(int n, int n2) {
            throw new IndexOutOfBoundsException("Cannot set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int get(int n) {
            throw new IndexOutOfBoundsException("Cannot get from empty indexable!");
        }

        @Override
        @NotNull
        public ListIterator<Integer> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfInt intIterator() {
            return Types.EMPTY_INT_ITERATOR;
        }

        @Override
        @NotNull
        public Collection<Integer> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Integer> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public int[] toArray() {
            return Empty.INT_ARRAY;
        }

        @Override
        @NotNull
        public Indexable<Integer> asIndexable() {
            return Indexable.emptyIndexable();
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public LongIndexable.Base asLongIndexable() {
            return LongIndexable.EMPTY;
        }

        @Override
        @NotNull
        public <T> Indexable<T> view(@NotNull IntFunction<? extends T> intFunction) {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public LongIndexable.Base asUnsignedIndexable() {
            return LongIndexable.EMPTY;
        }

        @Override
        public int foldLeft(int n, @NotNull IntBinaryOperator intBinaryOperator) {
            return n;
        }

        @Override
        @NotNull
        public IntIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public MutableIntIndexable getCopy() {
            return this;
        }

        @Override
        public void initByIndex(@NotNull IntUnaryOperator intUnaryOperator) {
        }

        @Override
        public void forEachInt(@NotNull IntConsumer intConsumer) {
        }

        @Override
        public <E extends Exception> void forEachIntFragile(@NotNull FragileIntConsumer<E> fragileIntConsumer) throws E {
        }

        @Override
        public boolean containsInt(int n) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Integer> consumer) {
        }

        @Override
        public int sum() {
            return 0;
        }

        @Override
        public long longSum() {
            return 0L;
        }

        @Override
        public void order(@NotNull IntOrdering intOrdering) {
        }

        @Override
        public void order() {
        }

        @Override
        @NotNull
        public OptionalDouble average() {
            return OptionalDouble.empty();
        }

        @Override
        @NotNull
        public Spliterator.OfInt intSpliterator() {
            return Spliterators.emptyIntSpliterator();
        }

        @Override
        @NotNull
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }
    };

    public void set(int var1, int var2);

    default public void syt(int n, int n2) {
        int n3;
        if (n >= 0) {
            this.with(n, n2);
        }
        if ((n3 = n + this.size()) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        this.with(n3, n2);
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable) {
        return this.setFrom(iterable, 0, this.size());
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable, int n, int n2) {
        if (n > this.size() - n2) {
            n2 = this.size() - n;
        }
        int n3 = 0;
        for (Number number : iterable) {
            this.with(n + n3++, number.intValue());
            if (n3 != n2) continue;
            break;
        }
        return n3;
    }

    default public void setFromArray(@NotNull int[] nArray, int n, int n2, int n3) {
        if (n2 + n3 > this.size()) {
            throw new IndexOutOfBoundsException("Overflow: numElements is too large!");
        }
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, nArray[n++]);
        }
    }

    default public void setMulti(int n, int n2, int n3) {
        n = Pythonesque.mapX(n, this);
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative: " + n2);
        }
        int n4 = n + n2;
        if (n4 > this.size()) {
            throw new IndexOutOfBoundsException(String.format("from + len exceed size(): %d + %d > %d", n, n2, this.size()));
        }
        for (int i = n; i < n4; ++i) {
            this.set(i, n3);
        }
    }

    default public void copyInternally(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("numElements must not be negative!");
        }
        int n4 = this.size();
        int n5 = Pythonesque.mapX(n, n4);
        int n6 = Pythonesque.mapX(n2, n4);
        if (n5 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n5, n3, n4));
        }
        if (n6 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n6, n3, n4));
        }
        if (n5 == n6) {
            return;
        }
        if (n5 < n6 && n5 + n3 > n6) {
            n5 += n3;
            n6 += n3;
            while (--n3 >= 0) {
                this.set(--n6, this.get(--n5));
            }
        } else {
            while (--n3 >= 0) {
                this.set(n6++, this.get(n5++));
            }
        }
    }

    default public void fillFrom(@NotNull IntUnaryOperator intUnaryOperator) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intUnaryOperator.applyAsInt(i));
        }
    }

    default public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, n3);
    }

    default public void swyp(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.swap(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @Override
    @NotNull
    default public Base subSet(final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return new Base(){

            @Override
            public void set(int n4, int n22) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                MutableIntIndexable.this.with(n4 + n, n22);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public int get(int n4) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                return MutableIntIndexable.this.get(n4 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n22) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n22 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n4 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                }
                return MutableIntIndexable.this.subSet(n + n4, n + n22 - n4);
            }

            @Override
            public void copyInternally(int n6, int n22, int n32) {
                int n4 = Pythonesque.mapX(n, n3);
                int n5 = Pythonesque.mapX(n2, n3);
                if (n4 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n32, n3));
                }
                if (n5 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n32, n3));
                }
                MutableIntIndexable.this.copyInternally(n + n6, n + n22, n32);
            }
        };
    }

    @Override
    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(n < 0 ? this.size() + n : n, n2 < 0 ? this.size() + n2 : n2);
    }

    @Override
    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(n < 0 ? this.size() + n : n, this.size());
    }

    @Override
    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, n < 0 ? this.size() + n : n);
    }

    @Override
    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public void set(int n, int n2) {
                MutableIntIndexable.this.with(this.size() - n - 1, n2);
            }

            @Override
            public int size() {
                return MutableIntIndexable.this.size();
            }

            @Override
            public int get(int n) {
                return MutableIntIndexable.this.get(this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return MutableIntIndexable.based(MutableIntIndexable.this);
            }
        };
    }

    default public void revert(int n, int n2) {
        int n3 = this.size();
        int n4 = Pythonesque.map(n, n3);
        int n5 = Pythonesque.map(n2, n3);
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
    }

    default public void revert() {
        if (this.size() <= 1) {
            return;
        }
        this.revert(0, -1);
    }

    default public void order(@NotNull IntOrdering intOrdering) {
        TimSortInt.sort(this, intOrdering);
    }

    default public void order() {
        this.order(IntOrdering.ASCENDING);
    }

    default public void shuffle(@NotNull Random random) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    @Deprecated
    default public void initByIndex(@NotNull IntUnaryOperator intUnaryOperator) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intUnaryOperator.applyAsInt(i));
        }
    }

    @Override
    @NotNull
    default public List<Integer> asList() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int n) {
                return MutableIntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return MutableIntIndexable.this.size();
            }

            @Override
            public Integer set(int n, Integer n2) {
                MutableIntIndexable.this.set(n, n2);
                return n2;
            }

            @Override
            public Iterator<Integer> iterator() {
                return MutableIntIndexable.this.iterator();
            }
        };
    }

    @Override
    @NotNull
    default public MutableIntIndexable getCopy() {
        return MutableIntIndexable.viewArray(this.toArray());
    }

    @NotNull
    public static Base based(final @NotNull MutableIntIndexable mutableIntIndexable) {
        if (mutableIntIndexable instanceof Base) {
            return (Base)mutableIntIndexable;
        }
        return new Base(){

            @Override
            public void set(int n, int n2) {
                mutableIntIndexable.with(n, n2);
            }

            @Override
            public int size() {
                return mutableIntIndexable.size();
            }

            @Override
            public int get(int n) {
                return mutableIntIndexable.get(n);
            }
        };
    }

    @NotNull
    public static Base init(int n, @NotNull IntSupplier intSupplier) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = intSupplier.getAsInt();
        }
        return MutableIntIndexable.viewArray(nArray);
    }

    @NotNull
    public static Base copyOf(@NotNull Collection<? extends Number> collection) {
        int[] nArray = new int[collection.size()];
        int n = 0;
        for (Number number : collection) {
            nArray[n++] = number.intValue();
        }
        return MutableIntIndexable.viewArray(nArray);
    }

    @NotNull
    public static <IN> Base copy(@NotNull Collection<IN> collection, @NotNull Function<IN, Number> function) {
        int[] nArray = new int[collection.size()];
        int n = 0;
        for (IN IN : collection) {
            nArray[n++] = function.apply(IN).intValue();
        }
        return MutableIntIndexable.viewArray(nArray);
    }

    @NotNull
    public static Base empty() {
        return EMPTY;
    }

    @NotNull
    public static Base fromArray(int ... nArray) {
        return MutableIntIndexable.fromArray(nArray, 0, nArray.length);
    }

    @NotNull
    public static Base fromArray(@NotNull int[] nArray, int n, int n2) {
        if (n < 0 || n + n2 > nArray.length) {
            throw new IllegalArgumentException("Indexes out of bounds!");
        }
        return MutableIntIndexable.viewArray(Arrays.copyOfRange(nArray, n, n + n2));
    }

    @NotNull
    public static Base viewArray(final @NotNull int[] nArray) {
        return new Base(){

            @Override
            public void set(int n, int n2) {
                nArray[n] = n2;
            }

            @Override
            public int size() {
                return nArray.length;
            }

            @Override
            public int get(int n) {
                return nArray[n];
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return MutableIntIndexable.viewArray(nArray, n, n2 - n);
            }

            @Override
            public void copyInternally(int n, int n2, int n3) {
                System.arraycopy(nArray, n, nArray, n2, n3);
            }

            @Override
            public void order(@NotNull IntOrdering intOrdering) {
                DualPivotQuicksort.sort(nArray, intOrdering);
            }

            @Override
            public void order() {
                Arrays.sort(nArray);
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull int[] nArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative, but is " + n2);
        }
        if (n + n2 > nArray.length) {
            throw new IndexOutOfBoundsException(String.format("end will be outside array: %d + %d > %d", n, n2, nArray.length));
        }
        if (n2 == 0) {
            return MutableIntIndexable.empty();
        }
        return new Base(){

            @Override
            public void set(int n3, int n22) {
                nArray[n3 + n] = n22;
            }

            @Override
            public int get(int n3) {
                return nArray[n3 + n];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return MutableIntIndexable.viewArray(nArray, n3 + n, n22 - n3);
            }

            @Override
            public void copyInternally(int n6, int n22, int n3) {
                if (n3 == 0) {
                    return;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("numElements must not be negative!");
                }
                int n4 = Pythonesque.mapX(n6, n2);
                int n5 = Pythonesque.mapX(n22, n2);
                if (n4 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n3, n2));
                }
                if (n5 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n3, n2));
                }
                if (n4 == n5) {
                    return;
                }
                System.arraycopy(nArray, n6 + n, nArray, n22 + n, n3);
            }

            @Override
            public void order(@NotNull IntOrdering intOrdering) {
                DualPivotQuicksort.sort(nArray, n, n + n2 - 1, intOrdering);
            }

            @Override
            public void order() {
                Arrays.sort(nArray, n, n + n2);
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<Integer> list) {
        return new Base(){

            @Override
            public void set(int n, int n2) {
                list.set(n, n2);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public int get(int n) {
                return (Integer)list.get(n);
            }
        };
    }

    @NotNull
    public static Base fromIndexable(@NotNull Indexable<? extends Number> indexable) {
        return MutableIntIndexable.copyOf(indexable.asCollection());
    }

    @NotNull
    public static <B> Base fromIndexable(@NotNull Indexable<B> indexable, @NotNull Function<? super B, ? extends Number> function) {
        int[] nArray = new int[indexable.size()];
        int n = 0;
        for (B b : indexable) {
            nArray[n++] = function.apply(b).intValue();
        }
        return MutableIntIndexable.viewArray(nArray);
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToIntFunction<? super T> toIntFunction, final @NotNull IntSetter<? super T> intSetter) {
        return new Base(){

            @Override
            public void set(int n, int n2) {
                intSetter.set(indexable.get(n), n2);
            }

            @Override
            public int get(int n) {
                return toIntFunction.applyAsInt(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }
        };
    }

    @NotNull
    public static Base fromDoubleIndexable(@NotNull DoubleIndexable doubleIndexable) {
        return MutableIntIndexable.initByIndex(doubleIndexable.size(), n -> (int)doubleIndexable.get(n));
    }

    @NotNull
    public static Base fromFloatIndexable(@NotNull FloatIndexable floatIndexable) {
        return MutableIntIndexable.initByIndex(floatIndexable.size(), n -> (int)floatIndexable.get(n));
    }

    @NotNull
    public static Base fromLongIndexable(@NotNull LongIndexable longIndexable) {
        return MutableIntIndexable.initByIndex(longIndexable.size(), n -> (int)longIndexable.get(n));
    }

    @NotNull
    public static Base fromIntIndexable(@NotNull IntIndexable intIndexable) {
        return MutableIntIndexable.initByIndex(intIndexable.size(), intIndexable::get);
    }

    @NotNull
    public static Base fromShortIndexable(@NotNull ShortIndexable shortIndexable) {
        return MutableIntIndexable.initByIndex(shortIndexable.size(), shortIndexable::get);
    }

    @NotNull
    public static Base fromByteIndexable(@NotNull ByteIndexable byteIndexable) {
        return MutableIntIndexable.initByIndex(byteIndexable.size(), byteIndexable::get);
    }

    @NotNull
    public static Base fromCharIndexable(@NotNull CharIndexable charIndexable) {
        return MutableIntIndexable.initByIndex(charIndexable.size(), charIndexable::get);
    }

    @NotNull
    public static Base fromIterable(int n, @NotNull Iterable<? extends Number> iterable) {
        int[] nArray = new int[n];
        int n2 = 0;
        for (Number number : iterable) {
            nArray[n2++] = number.intValue();
            if (n2 != n) continue;
            break;
        }
        return MutableIntIndexable.viewArray(nArray);
    }

    @NotNull
    public static Base zeroed(int n) {
        return MutableIntIndexable.viewArray(new int[n]);
    }

    @NotNull
    public static Base init(int n, int n2) {
        int[] nArray = new int[n];
        Arrays.fill(nArray, n2);
        return MutableIntIndexable.viewArray(nArray);
    }

    @NotNull
    public static Base initByIndex(int n, @NotNull IntUnaryOperator intUnaryOperator) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = intUnaryOperator.applyAsInt(i);
        }
        return MutableIntIndexable.viewArray(nArray);
    }

    public static abstract class Base
    extends IntIndexable.Base
    implements MutableIntIndexable {
    }
}

