/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Empty;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.Pythonesque;
import de.caff.generics.Types;
import de.caff.generics.algorithm.TimSort;
import de.caff.generics.function.FragileFunction0;
import de.caff.generics.function.FragileFunction1;
import de.caff.generics.function.FragileProcedure1;
import de.caff.generics.function.FragileProcedure2;
import de.caff.generics.function.Function0;
import de.caff.generics.function.Ordering;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface MutableIndexable<T>
extends Indexable<T> {
    public static final MutableIndexable<Object> EMPTY = new Base<Object>(){

        @Override
        public void set(int n, Object object) {
            throw new IndexOutOfBoundsException("Cannot set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException("Cannot get from empty indexable!");
        }

        @Override
        @NotNull
        public ListIterator<Object> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public MutableIndexable<Object> reverse() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Object> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public Collection<Object> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Object> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public Indexable<Object> frozen() {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public Indexable<Object> frozen(@NotNull Function<? super Object, ?> function, boolean bl) {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public MutableIndexable<Object> getCopy(@Nullable Function<? super Object, ?> function) {
            return this;
        }

        @Override
        @NotNull
        public Indexable<Object> sorted(@NotNull Comparator<? super Object> comparator) {
            return this;
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return Empty.OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public Object[] toArray(@NotNull Class<Object> clazz) {
            return (Object[])Array.newInstance(clazz, 0);
        }

        @Override
        public int addToArray(@NotNull Object[] objectArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        public int addToArray(@NotNull Object[] objectArray, int n) {
            return n;
        }

        @Override
        public void forEachEntry(@NotNull BiConsumer<Integer, ? super Object> biConsumer) {
        }

        @Override
        public <E extends Exception> void forEachEntryFragile(@NotNull FragileProcedure2<E, Integer, ? super Object> fragileProcedure2) throws E {
        }

        @Override
        public void forEach(Consumer<? super Object> consumer) {
        }

        @Override
        public void addAllTo(@NotNull Collection<? super Object> collection) {
        }

        @Override
        @NotNull
        public Iterable<Object> filtered(@NotNull Predicate<? super Object> predicate) {
            return Types.emptyIterable();
        }

        @Override
        public <E extends Exception> void forEachFragile(@NotNull FragileProcedure1<E, ? super Object> fragileProcedure1) throws E {
        }

        @Override
        public <V> V foldLeft(V v, @NotNull BiFunction<? super V, ? super Object, ? extends V> biFunction) {
            return v;
        }

        @Override
        @NotNull
        public <E> Indexable<E> view(@NotNull Function<? super Object, ? extends E> function) {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public <R, E extends Exception> Indexable<R> viewFragile(@NotNull FragileFunction1<? extends R, E, ? super Object> fragileFunction1) {
            return Indexable.emptyIndexable();
        }

        @Override
        @Deprecated
        public void addToCollection(@NotNull Collection<? super Object> collection) {
        }

        @Override
        @NotNull
        public Indexable<Object> findAll(@NotNull Predicate<? super Object> predicate) {
            return Indexable.emptyIndexable();
        }

        @Override
        public int setFrom(@NotNull Iterable<?> iterable) {
            return 0;
        }

        @Override
        public void fillFrom(@NotNull IntFunction<?> intFunction) {
        }
    };

    public void set(int var1, T var2);

    default public void syt(int n, T t) {
        this.set(Pythonesque.mapX(n, this), t);
    }

    default public int setFrom(@NotNull Iterable<? extends T> iterable) {
        return this.setFrom(iterable, 0, this.size());
    }

    default public int setFrom(@NotNull Iterable<? extends T> iterable, int n, int n2) {
        if (n > this.size() - n2) {
            n2 = this.size() - n;
        }
        int n3 = 0;
        for (T t : iterable) {
            this.set(n + n3++, t);
            if (n3 != n2) continue;
            break;
        }
        return n3;
    }

    default public void setFromArray(@NotNull T[] TArray, int n, int n2, int n3) {
        if (n2 + n3 > this.size()) {
            throw new IndexOutOfBoundsException("Overflow: numElements is too large!");
        }
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, TArray[n++]);
        }
    }

    default public void setMulti(int n, int n2, T t) {
        n = Pythonesque.mapX(n, this);
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative: " + n2);
        }
        int n3 = n + n2;
        if (n3 > this.size()) {
            throw new IndexOutOfBoundsException(String.format("from + len exceed size(): %d + %d > %d", n, n2, this.size()));
        }
        for (int i = n; i < n3; ++i) {
            this.set(i, t);
        }
    }

    default public void copyInternally(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("numElements must not be negative!");
        }
        int n4 = this.size();
        int n5 = Pythonesque.mapX(n, n4);
        int n6 = Pythonesque.mapX(n2, n4);
        if (n5 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n5, n3, n4));
        }
        if (n6 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n6, n3, n4));
        }
        if (n5 == n6) {
            return;
        }
        if (n5 < n6 && n5 + n3 > n6) {
            n5 += n3;
            n6 += n3;
            while (--n3 >= 0) {
                this.set(--n6, this.get(--n5));
            }
        } else {
            while (--n3 >= 0) {
                this.set(n6++, this.get(n5++));
            }
        }
    }

    default public void fillFrom(@NotNull IntFunction<? extends T> intFunction) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intFunction.apply(i));
        }
    }

    default public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        Object t = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, t);
    }

    default public void swyp(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.swap(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @Override
    @NotNull
    default public MutableIndexable<T> subSet(final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return new Base<T>(){

            @Override
            public void set(int n4, T t) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                MutableIndexable.this.set(n4 + n, t);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public T get(int n4) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                return MutableIndexable.this.get(n4 + n);
            }

            @Override
            @NotNull
            public MutableIndexable<T> subSet(int n4, int n22) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n22 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n4 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                }
                return MutableIndexable.this.subSet(n + n4, n + n22 - n4);
            }

            @Override
            public void copyInternally(int n6, int n22, int n32) {
                int n4 = Pythonesque.mapX(n, n3);
                int n5 = Pythonesque.mapX(n2, n3);
                if (n4 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n32, n3));
                }
                if (n5 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n32, n3));
                }
                MutableIndexable.this.copyInternally(n + n6, n + n22, n32);
            }
        };
    }

    @Override
    @NotNull
    default public MutableIndexable<T> sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @Override
    @NotNull
    default public MutableIndexable<T> tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    @Override
    @NotNull
    default public MutableIndexable<T> headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @Override
    @NotNull
    default public ListIterator<T> listIterator() {
        return new ListIterator<T>(){
            private int index = 0;
            private int lastRet = -1;

            @Override
            public boolean hasNext() {
                return this.index < MutableIndexable.this.size();
            }

            @Override
            public T next() {
                if (this.index >= MutableIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                this.lastRet = this.index++;
                return MutableIndexable.this.get(this.lastRet);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public T previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                this.lastRet = --this.index;
                return MutableIndexable.this.get(this.index);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(T t) {
                if (this.lastRet < 0) {
                    throw new IllegalStateException();
                }
                MutableIndexable.this.set(this.lastRet, t);
            }

            @Override
            public void add(T t) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    @NotNull
    default public MutableIndexable<T> reverse() {
        return new MutableIndexable<T>(){

            @Override
            public void set(int n, T t) {
                MutableIndexable.this.set(this.size() - n - 1, t);
            }

            @Override
            public int size() {
                return MutableIndexable.this.size();
            }

            @Override
            public T get(int n) {
                return MutableIndexable.this.get(this.size() - n - 1);
            }

            @Override
            @NotNull
            public MutableIndexable<T> reverse() {
                return MutableIndexable.this;
            }
        };
    }

    default public void revert(int n, int n2) {
        int n3 = this.size();
        int n4 = Pythonesque.map(n, n3);
        int n5 = Pythonesque.map(n2, n3);
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
    }

    default public void revert() {
        if (this.size() <= 1) {
            return;
        }
        this.revert(0, -1);
    }

    default public void order(@NotNull Ordering<? super T> ordering) {
        TimSort.sort(this, ordering);
    }

    default public void shuffle(@NotNull Random random) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    @Override
    @NotNull
    default public List<T> asList() {
        return new ListView(this);
    }

    default public void applyOnEach(@NotNull Function<? super T, ? extends T> function) {
        for (int i = this.size() - 1; i >= 0; --i) {
            this.set(i, function.apply(this.get(i)));
        }
    }

    @NotNull
    default public MutableIndexable<T> getCopy() {
        return this.getCopy(null);
    }

    @NotNull
    default public MutableIndexable<T> getCopy(@Nullable Function<? super T, ? extends T> function) {
        Object[] objectArray = this.toArray();
        if (function != null) {
            for (int i = objectArray.length - 1; i >= 0; --i) {
                objectArray[i] = function.apply(objectArray[i]);
            }
        }
        return MutableIndexable.viewArray(objectArray);
    }

    @NotNull
    public static <E> MutableIndexable<E> init(int n, @NotNull Supplier<E> supplier) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = supplier.get();
        }
        return MutableIndexable.viewArray(objectArray);
    }

    @NotNull
    public static <E, X extends Exception> MutableIndexable<E> initFragile(int n, @NotNull FragileFunction0<E, X> fragileFunction0) throws X {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = fragileFunction0.apply();
        }
        return MutableIndexable.viewArray(objectArray);
    }

    @NotNull
    public static <E> MutableIndexable<E> initByIndex(int n, @NotNull IntFunction<? extends E> intFunction) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = intFunction.apply(i);
        }
        return MutableIndexable.fromArray(objectArray);
    }

    @Deprecated
    @NotNull
    public static <E> MutableIndexable<E> filled(final int n, final @NotNull IntFunction<? extends E> intFunction) {
        return MutableIndexable.fromIndexable(new Indexable.Base<E>(){

            @Override
            public E get(int n2) {
                return intFunction.apply(n2);
            }

            @Override
            public int size() {
                return n;
            }
        });
    }

    @NotNull
    public static <E> MutableIndexable<E> nulled(int n) {
        if (n == 0) {
            return MutableIndexable.empty();
        }
        return MutableIndexable.init(n, Function0.alwaysNull());
    }

    @NotNull
    public static <E> MutableIndexable<E> copyOf(@NotNull Collection<E> collection) {
        return MutableIndexable.viewList(new ArrayList<E>(collection));
    }

    @NotNull
    public static <E, IN> MutableIndexable<E> copy(@NotNull Collection<IN> collection, @NotNull Function<IN, E> function) {
        return MutableIndexable.viewList(Types.map(collection, function));
    }

    @NotNull
    public static <E> MutableIndexable<E> empty() {
        return EMPTY;
    }

    @SafeVarargs
    @NotNull
    public static <E> MutableIndexable<E> fromArray(E ... EArray) {
        return MutableIndexable.fromArray(EArray, 0, EArray.length);
    }

    @NotNull
    public static <E> MutableIndexable<E> fromArray(@NotNull E[] EArray, int n, int n2) {
        if (n < 0 || n + n2 > EArray.length) {
            throw new IllegalArgumentException("Indexes out of bounds!");
        }
        return MutableIndexable.viewArray(Arrays.copyOfRange(EArray, n, n + n2));
    }

    @SafeVarargs
    @NotNull
    public static <E> MutableIndexable<E> viewArray(final E ... EArray) {
        return new Base<E>(){

            @Override
            public void set(int n, E e) {
                EArray[n] = e;
            }

            @Override
            public int size() {
                return EArray.length;
            }

            @Override
            public E get(int n) {
                return EArray[n];
            }

            @Override
            @NotNull
            public MutableIndexable<E> subSet(int n, int n2) {
                return MutableIndexable.viewArray(EArray, n, n2 - n);
            }

            @Override
            public void copyInternally(int n, int n2, int n3) {
                System.arraycopy(EArray, n, EArray, n2, n3);
            }
        };
    }

    @NotNull
    public static <E> MutableIndexable<E> viewArray(final @NotNull E[] EArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative, but is " + n2);
        }
        if (n + n2 > EArray.length) {
            throw new IndexOutOfBoundsException(String.format("end will be outside array: %d + %d > %d", n, n2, EArray.length));
        }
        if (n2 == 0) {
            return MutableIndexable.empty();
        }
        return new Base<E>(){

            private void checkIndex(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException("Index: " + n3);
                }
            }

            @Override
            public void set(int n3, E e) {
                this.checkIndex(n3);
                EArray[n + n3] = e;
            }

            @Override
            public E get(int n3) {
                this.checkIndex(n3);
                return EArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public MutableIndexable<E> subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return MutableIndexable.viewArray(EArray, n3 + n, n22 - n3);
            }

            @Override
            public void copyInternally(int n6, int n22, int n3) {
                if (n3 == 0) {
                    return;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("numElements must not be negative!");
                }
                int n4 = Pythonesque.mapX(n6, n2);
                int n5 = Pythonesque.mapX(n22, n2);
                if (n4 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n3, n2));
                }
                if (n5 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n3, n2));
                }
                if (n4 == n5) {
                    return;
                }
                System.arraycopy(EArray, n6 + n, EArray, n22 + n, n3);
            }
        };
    }

    @NotNull
    public static <E> MutableIndexable<E> viewList(final @NotNull List<E> list) {
        return new Base<E>(){

            @Override
            public void set(int n, E e) {
                list.set(n, e);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public E get(int n) {
                return list.get(n);
            }
        };
    }

    @NotNull
    public static <E> MutableIndexable<E> fromIndexable(@NotNull Indexable<E> indexable) {
        return MutableIndexable.copyOf(indexable.asCollection());
    }

    @NotNull
    public static <E, B> MutableIndexable<E> fromIndexable(@NotNull Indexable<B> indexable, @NotNull Function<B, E> function) {
        return MutableIndexable.viewList(Types.map(indexable.asList(), function));
    }

    @NotNull
    public static <IT, OT> Base<OT> viewIndexable(final @NotNull Indexable<IT> indexable, final @NotNull Function<? super IT, OT> function, final @NotNull BiConsumer<? super IT, ? super OT> biConsumer) {
        return new Base<OT>(){

            @Override
            public void set(int n, OT OT) {
                biConsumer.accept(indexable.get(n), OT);
            }

            @Override
            public OT get(int n) {
                return function.apply(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }
        };
    }

    @NotNull
    public static <E> MutableIndexable<E> fromIterable(int n, @NotNull Iterable<E> iterable) {
        ArrayList<E> arrayList = new ArrayList<E>(n);
        int n2 = 0;
        for (E e : iterable) {
            arrayList.add(e);
            if (++n2 != n) continue;
            break;
        }
        arrayList.trimToSize();
        return MutableIndexable.viewList(arrayList);
    }

    public static abstract class Base<TT>
    extends Indexable.Base<TT>
    implements MutableIndexable<TT> {
    }

    public static class ListView<T>
    extends AbstractList<T>
    implements RandomAccess {
        @NotNull
        private final MutableIndexable<T> indexable;

        public ListView(@NotNull MutableIndexable<T> mutableIndexable) {
            this.indexable = mutableIndexable;
        }

        @Override
        public T get(int n) {
            return this.indexable.get(n);
        }

        @Override
        public int size() {
            return this.indexable.size();
        }

        @Override
        public T set(int n, T t) {
            this.indexable.set(n, t);
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.indexable.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.indexable.iterator();
        }
    }
}

