/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.Copyable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.PrimitiveFloatIterator;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Types;
import de.caff.generics.algorithm.DualPivotQuicksort;
import de.caff.generics.algorithm.TimSortFloat;
import de.caff.generics.function.FloatConsumer;
import de.caff.generics.function.FloatOperator2;
import de.caff.generics.function.FloatOrdering;
import de.caff.generics.function.FloatSetter;
import de.caff.generics.function.FragileFloatConsumer;
import de.caff.generics.function.IntToFloatFunction1;
import de.caff.generics.function.ToFloatFunction;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface MutableFloatIndexable
extends FloatIndexable,
Copyable<MutableFloatIndexable> {
    public static final Base EMPTY = new Base(){

        @Override
        public void set(int n, float f) {
            throw new IndexOutOfBoundsException("Cannot set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public float get(int n) {
            throw new IndexOutOfBoundsException("Cannot get from empty indexable!");
        }

        @Override
        @NotNull
        public ListIterator<Float> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Float> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public PrimitiveFloatIterator floatIterator() {
            return Types.EMPTY_FLOAT_ITERATOR;
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfDouble doubleIterator() {
            return Types.EMPTY_DOUBLE_ITERATOR;
        }

        @Override
        @NotNull
        public Collection<Float> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Float> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public float[] toArray() {
            return Empty.FLOAT_ARRAY;
        }

        @Override
        public int addToArray(@NotNull float[] fArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public DoubleIndexable.Base asDoubleIndexable() {
            return DoubleIndexable.EMPTY;
        }

        @Override
        public float foldLeft(float f, @NotNull FloatOperator2 floatOperator2) {
            return f;
        }

        @Override
        @NotNull
        public FloatIndexable frozen() {
            return this;
        }

        @Override
        public void initByIndex(@NotNull IntToFloatFunction1 intToFloatFunction1) {
        }

        @Override
        public void forEachFloat(@NotNull FloatConsumer floatConsumer) {
        }

        @Override
        public <E extends Exception> void forEachFloatFragile(@NotNull FragileFloatConsumer<E> fragileFloatConsumer) throws E {
        }

        @Override
        public boolean containsFloat(float f) {
            return false;
        }

        @Override
        public boolean containsFloat(float f, float f2) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Float> consumer) {
        }

        @Override
        @NotNull
        public MutableFloatIndexable getCopy() {
            return this;
        }

        @Override
        public void order(@NotNull FloatOrdering floatOrdering) {
        }

        @Override
        public void order() {
        }

        @Override
        @NotNull
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }
    };

    public void set(int var1, float var2);

    default public void syt(int n, float f) {
        int n2;
        if (n >= 0) {
            this.set(n, f);
        }
        if ((n2 = n + this.size()) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        this.set(n2, f);
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable) {
        return this.setFrom(iterable, 0, this.size());
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable, int n, int n2) {
        if (n > this.size() - n2) {
            n2 = this.size() - n;
        }
        int n3 = 0;
        for (Number number : iterable) {
            this.set(n + n3++, number.floatValue());
            if (n3 != n2) continue;
            break;
        }
        return n3;
    }

    default public void setFromArray(@NotNull float[] fArray, int n, int n2, int n3) {
        if (n2 + n3 > this.size()) {
            throw new IndexOutOfBoundsException("Overflow: numElements is too large!");
        }
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, fArray[n++]);
        }
    }

    default public void setMulti(int n, int n2, float f) {
        n = Pythonesque.mapX(n, this);
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative: " + n2);
        }
        int n3 = n + n2;
        if (n3 > this.size()) {
            throw new IndexOutOfBoundsException(String.format("from + len exceed size(): %d + %d > %d", n, n2, this.size()));
        }
        for (int i = n; i < n3; ++i) {
            this.set(i, f);
        }
    }

    default public void copyInternally(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("numElements must not be negative!");
        }
        int n4 = this.size();
        int n5 = Pythonesque.mapX(n, n4);
        int n6 = Pythonesque.mapX(n2, n4);
        if (n5 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n5, n3, n4));
        }
        if (n6 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n6, n3, n4));
        }
        if (n5 == n6) {
            return;
        }
        if (n5 < n6 && n5 + n3 > n6) {
            n5 += n3;
            n6 += n3;
            while (--n3 >= 0) {
                this.set(--n6, this.get(--n5));
            }
        } else {
            while (--n3 >= 0) {
                this.set(n6++, this.get(n5++));
            }
        }
    }

    default public void fillFrom(@NotNull IntToFloatFunction1 intToFloatFunction1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToFloatFunction1.applyAsFloat(i));
        }
    }

    default public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        float f = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, f);
    }

    default public void swyp(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.swap(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @Override
    @NotNull
    default public Base subSet(final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return new Base(){

            @Override
            public void set(int n4, float f) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                MutableFloatIndexable.this.set(n4 + n, f);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public float get(int n4) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                return MutableFloatIndexable.this.get(n4 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n22) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n22 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n4 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                }
                return MutableFloatIndexable.this.subSet(n + n4, n + n22 - n4);
            }

            @Override
            public void copyInternally(int n6, int n22, int n32) {
                int n4 = Pythonesque.mapX(n, n3);
                int n5 = Pythonesque.mapX(n2, n3);
                if (n4 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n32, n3));
                }
                if (n5 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n32, n3));
                }
                MutableFloatIndexable.this.copyInternally(n + n6, n + n22, n32);
            }
        };
    }

    @Override
    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(n < 0 ? this.size() + n : n, n2 < 0 ? this.size() + n2 : n2);
    }

    @Override
    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(n < 0 ? this.size() + n : n, this.size());
    }

    @Override
    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, n < 0 ? this.size() + n : n);
    }

    @Override
    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public void set(int n, float f) {
                MutableFloatIndexable.this.set(this.size() - n - 1, f);
            }

            @Override
            public int size() {
                return MutableFloatIndexable.this.size();
            }

            @Override
            public float get(int n) {
                return MutableFloatIndexable.this.get(this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return MutableFloatIndexable.based(MutableFloatIndexable.this);
            }
        };
    }

    default public void revert(int n, int n2) {
        int n3 = this.size();
        int n4 = Pythonesque.map(n, n3);
        int n5 = Pythonesque.map(n2, n3);
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
    }

    default public void revert() {
        if (this.size() <= 1) {
            return;
        }
        this.revert(0, -1);
    }

    default public void order(@NotNull FloatOrdering floatOrdering) {
        TimSortFloat.sort(this, floatOrdering);
    }

    default public void order() {
        this.order(FloatOrdering.NATURAL_ASCENDING);
    }

    default public void shuffle(@NotNull Random random) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    @Deprecated
    default public void initByIndex(@NotNull IntToFloatFunction1 intToFloatFunction1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToFloatFunction1.applyAsFloat(i));
        }
    }

    @Override
    @NotNull
    default public List<Float> asList() {
        return new AbstractList<Float>(){

            @Override
            public Float get(int n) {
                return Float.valueOf(MutableFloatIndexable.this.get(n));
            }

            @Override
            public int size() {
                return MutableFloatIndexable.this.size();
            }

            @Override
            public Float set(int n, Float f) {
                MutableFloatIndexable.this.set(n, f.floatValue());
                return f;
            }

            @Override
            public Iterator<Float> iterator() {
                return MutableFloatIndexable.this.iterator();
            }
        };
    }

    @Override
    @NotNull
    default public MutableFloatIndexable getCopy() {
        return MutableFloatIndexable.viewArray(this.toArray());
    }

    @NotNull
    public static Base based(final @NotNull MutableFloatIndexable mutableFloatIndexable) {
        if (mutableFloatIndexable instanceof Base) {
            return (Base)mutableFloatIndexable;
        }
        return new Base(){

            @Override
            public void set(int n, float f) {
                mutableFloatIndexable.set(n, f);
            }

            @Override
            public int size() {
                return mutableFloatIndexable.size();
            }

            @Override
            public float get(int n) {
                return mutableFloatIndexable.get(n);
            }
        };
    }

    @NotNull
    public static Base init(int n, @NotNull Supplier<? extends Number> supplier) {
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = supplier.get().floatValue();
        }
        return MutableFloatIndexable.viewArray(fArray);
    }

    @NotNull
    public static Base copyOf(@NotNull Collection<? extends Number> collection) {
        float[] fArray = new float[collection.size()];
        int n = 0;
        for (Number number : collection) {
            fArray[n++] = number.floatValue();
        }
        return MutableFloatIndexable.viewArray(fArray);
    }

    @NotNull
    public static <IN> Base copy(@NotNull Collection<IN> collection, @NotNull Function<IN, Number> function) {
        float[] fArray = new float[collection.size()];
        int n = 0;
        for (IN IN : collection) {
            fArray[n++] = function.apply(IN).floatValue();
        }
        return MutableFloatIndexable.viewArray(fArray);
    }

    @NotNull
    public static Base empty() {
        return EMPTY;
    }

    @NotNull
    public static Base fromArray(float ... fArray) {
        return MutableFloatIndexable.fromArray(fArray, 0, fArray.length);
    }

    @NotNull
    public static Base fromArray(@NotNull float[] fArray, int n, int n2) {
        if (n < 0 || n + n2 > fArray.length) {
            throw new IllegalArgumentException("Indexes out of bounds!");
        }
        return MutableFloatIndexable.viewArray(Arrays.copyOfRange(fArray, n, n + n2));
    }

    @NotNull
    public static Base viewArray(final @NotNull float[] fArray) {
        return new Base(){

            @Override
            public void set(int n, float f) {
                fArray[n] = f;
            }

            @Override
            public int size() {
                return fArray.length;
            }

            @Override
            public float get(int n) {
                return fArray[n];
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return MutableFloatIndexable.viewArray(fArray, n, n2 - n);
            }

            @Override
            public void copyInternally(int n, int n2, int n3) {
                System.arraycopy(fArray, n, fArray, n2, n3);
            }

            @Override
            public void order() {
                Arrays.sort(fArray);
            }

            @Override
            public void order(@NotNull FloatOrdering floatOrdering) {
                DualPivotQuicksort.sort(fArray, floatOrdering);
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull float[] fArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative, but is " + n2);
        }
        if (n + n2 > fArray.length) {
            throw new IndexOutOfBoundsException(String.format("end will be outside array: %d + %d > %d", n, n2, fArray.length));
        }
        if (n2 == 0) {
            return MutableFloatIndexable.empty();
        }
        return new Base(){

            @Override
            public void set(int n3, float f) {
                fArray[n3 + n] = f;
            }

            @Override
            public float get(int n3) {
                return fArray[n3 + n];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return MutableFloatIndexable.viewArray(fArray, n3 + n, n22 - n3);
            }

            @Override
            public void copyInternally(int n6, int n22, int n3) {
                if (n3 == 0) {
                    return;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("numElements must not be negative!");
                }
                int n4 = Pythonesque.mapX(n6, n2);
                int n5 = Pythonesque.mapX(n22, n2);
                if (n4 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n3, n2));
                }
                if (n5 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n3, n2));
                }
                if (n4 == n5) {
                    return;
                }
                System.arraycopy(fArray, n6 + n, fArray, n22 + n, n3);
            }

            @Override
            public void order() {
                Arrays.sort(fArray, n, n + n2);
            }

            @Override
            public void order(@NotNull FloatOrdering floatOrdering) {
                DualPivotQuicksort.sort(fArray, n, n + n2 - 1, floatOrdering);
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<Float> list) {
        return new Base(){

            @Override
            public void set(int n, float f) {
                list.set(n, Float.valueOf(f));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public float get(int n) {
                return ((Float)list.get(n)).floatValue();
            }
        };
    }

    @NotNull
    public static Base fromIndexable(@NotNull Indexable<? extends Number> indexable) {
        return MutableFloatIndexable.copyOf(indexable.asCollection());
    }

    @NotNull
    public static <B> Base fromIndexable(@NotNull Indexable<B> indexable, @NotNull Function<? super B, ? extends Number> function) {
        float[] fArray = new float[indexable.size()];
        int n = 0;
        for (B b : indexable) {
            fArray[n++] = function.apply(b).floatValue();
        }
        return MutableFloatIndexable.viewArray(fArray);
    }

    @NotNull
    public static Base fromDoubleIndexable(@NotNull DoubleIndexable doubleIndexable) {
        return MutableFloatIndexable.initByIndex(doubleIndexable.size(), n -> (float)doubleIndexable.get(n));
    }

    @NotNull
    public static Base fromFloatIndexable(@NotNull FloatIndexable floatIndexable) {
        return MutableFloatIndexable.initByIndex(floatIndexable.size(), floatIndexable::get);
    }

    @NotNull
    public static Base fromLongIndexable(@NotNull LongIndexable longIndexable) {
        return MutableFloatIndexable.initByIndex(longIndexable.size(), longIndexable::get);
    }

    @NotNull
    public static Base fromIntIndexable(@NotNull IntIndexable intIndexable) {
        return MutableFloatIndexable.initByIndex(intIndexable.size(), intIndexable::get);
    }

    @NotNull
    public static Base fromShortIndexable(@NotNull ShortIndexable shortIndexable) {
        return MutableFloatIndexable.initByIndex(shortIndexable.size(), shortIndexable::get);
    }

    @NotNull
    public static Base fromByteIndexable(@NotNull ByteIndexable byteIndexable) {
        return MutableFloatIndexable.initByIndex(byteIndexable.size(), byteIndexable::get);
    }

    @NotNull
    public static Base fromIterable(int n, @NotNull Iterable<? extends Number> iterable) {
        float[] fArray = new float[n];
        int n2 = 0;
        for (Number number : iterable) {
            fArray[n2++] = number.floatValue();
            if (n2 != n) continue;
            break;
        }
        return MutableFloatIndexable.viewArray(fArray);
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToFloatFunction<? super T> toFloatFunction, final @NotNull FloatSetter<? super T> floatSetter) {
        return new Base(){

            @Override
            public void set(int n, float f) {
                floatSetter.set(indexable.get(n), f);
            }

            @Override
            public float get(int n) {
                return toFloatFunction.applyAsFloat(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }
        };
    }

    @NotNull
    public static Base zeroed(int n) {
        return MutableFloatIndexable.viewArray(new float[n]);
    }

    @NotNull
    public static Base init(int n, float f) {
        float[] fArray = new float[n];
        Arrays.fill(fArray, f);
        return MutableFloatIndexable.viewArray(fArray);
    }

    @NotNull
    public static Base initByIndex(int n, @NotNull IntToFloatFunction1 intToFloatFunction1) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = intToFloatFunction1.applyAsFloat(i);
        }
        return MutableFloatIndexable.viewArray(fArray);
    }

    public static abstract class Base
    extends FloatIndexable.Base
    implements MutableFloatIndexable {
    }
}

