/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.Copyable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Types;
import de.caff.generics.algorithm.DualPivotQuicksort;
import de.caff.generics.algorithm.TimSortDouble;
import de.caff.generics.function.DoubleOperator1;
import de.caff.generics.function.DoubleOrdering;
import de.caff.generics.function.DoubleSetter;
import de.caff.generics.function.FragileDoubleConsumer;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.IntToDoubleFunction;
import java.util.function.ToDoubleFunction;

public interface MutableDoubleIndexable
extends DoubleIndexable,
Copyable<MutableDoubleIndexable> {
    public static final Base EMPTY = new Base(){

        @Override
        public void set(int n, double d) {
            throw new IndexOutOfBoundsException("Cannot set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public double get(int n) {
            throw new IndexOutOfBoundsException("Cannot get from empty indexable!");
        }

        @Override
        @NotNull
        public ListIterator<Double> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Double> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfDouble doubleIterator() {
            return Types.EMPTY_DOUBLE_ITERATOR;
        }

        @Override
        public int addToArray(@NotNull double[] dArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public DoubleIndexable.Base transformed(@NotNull DoubleOperator1 doubleOperator1) {
            return this;
        }

        @Override
        @NotNull
        public DoubleIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public <T> Indexable<T> view(@NotNull DoubleFunction<? extends T> doubleFunction) {
            return Indexable.emptyIndexable();
        }

        @Override
        public void forEachDouble(@NotNull DoubleConsumer doubleConsumer) {
        }

        @Override
        public <E extends Exception> void forEachDoubleFragile(@NotNull FragileDoubleConsumer<E> fragileDoubleConsumer) throws E {
        }

        @Override
        public boolean containsDouble(double d) {
            return false;
        }

        @Override
        public boolean containsDouble(double d, double d2) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Double> consumer) {
        }

        @Override
        @NotNull
        public Collection<Double> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Double> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        public double foldLeft(double d, @NotNull DoubleBinaryOperator doubleBinaryOperator) {
            return d;
        }

        @Override
        @NotNull
        public double[] toArray() {
            return Empty.DOUBLE_ARRAY;
        }

        @Override
        public void initByIndex(@NotNull IntToDoubleFunction intToDoubleFunction) {
        }

        @Override
        @NotNull
        public MutableDoubleIndexable getCopy() {
            return this;
        }

        @Override
        @NotNull
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public double sum() {
            return 0.0;
        }

        @Override
        public void order(@NotNull DoubleOrdering doubleOrdering) {
        }

        @Override
        public void order() {
        }

        @Override
        @NotNull
        public OptionalDouble average() {
            return OptionalDouble.empty();
        }

        @Override
        @NotNull
        public Spliterator.OfDouble doubleSpliterator() {
            return Spliterators.emptyDoubleSpliterator();
        }
    };

    public void set(int var1, double var2);

    default public void syt(int n, double d) {
        int n2;
        if (n >= 0) {
            this.set(n, d);
        }
        if ((n2 = n + this.size()) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        this.set(n2, d);
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable) {
        return this.setFrom(iterable, 0, this.size());
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable, int n, int n2) {
        if (n > this.size() - n2) {
            n2 = this.size() - n;
        }
        int n3 = 0;
        for (Number number : iterable) {
            this.set(n + n3++, number.doubleValue());
            if (n3 != n2) continue;
            break;
        }
        return n3;
    }

    default public void setFromArray(@NotNull double[] dArray, int n, int n2, int n3) {
        if (n2 + n3 > this.size()) {
            throw new IndexOutOfBoundsException("Overflow: numElements is too large!");
        }
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, dArray[n++]);
        }
    }

    default public void setMulti(int n, int n2, double d) {
        n = Pythonesque.mapX(n, this);
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative: " + n2);
        }
        int n3 = n + n2;
        if (n3 > this.size()) {
            throw new IndexOutOfBoundsException(String.format("from + len exceed size(): %d + %d > %d", n, n2, this.size()));
        }
        for (int i = n; i < n3; ++i) {
            this.set(i, d);
        }
    }

    default public void copyInternally(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("numElements must not be negative!");
        }
        int n4 = this.size();
        int n5 = Pythonesque.mapX(n, n4);
        int n6 = Pythonesque.mapX(n2, n4);
        if (n5 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n5, n3, n4));
        }
        if (n6 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n6, n3, n4));
        }
        if (n5 == n6) {
            return;
        }
        if (n5 < n6 && n5 + n3 > n6) {
            n5 += n3;
            n6 += n3;
            while (--n3 >= 0) {
                this.set(--n6, this.get(--n5));
            }
        } else {
            while (--n3 >= 0) {
                this.set(n6++, this.get(n5++));
            }
        }
    }

    default public void fillFrom(@NotNull IntToDoubleFunction intToDoubleFunction) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToDoubleFunction.applyAsDouble(i));
        }
    }

    default public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        double d = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, d);
    }

    default public void swyp(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.swap(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @Override
    @NotNull
    default public Base subSet(final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return new Base(){

            @Override
            public void set(int n4, double d) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                MutableDoubleIndexable.this.set(n4 + n, d);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public double get(int n4) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                return MutableDoubleIndexable.this.get(n4 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n22) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n22 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n4 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                }
                return MutableDoubleIndexable.this.subSet(n + n4, n + n22 - n4);
            }

            @Override
            public void copyInternally(int n6, int n22, int n32) {
                int n4 = Pythonesque.mapX(n, n3);
                int n5 = Pythonesque.mapX(n2, n3);
                if (n4 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n32, n3));
                }
                if (n5 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n32, n3));
                }
                MutableDoubleIndexable.this.copyInternally(n + n6, n + n22, n32);
            }
        };
    }

    @Override
    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(n < 0 ? this.size() + n : n, n2 < 0 ? this.size() + n2 : n2);
    }

    @Override
    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(n < 0 ? this.size() + n : n, this.size());
    }

    @Override
    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, n < 0 ? this.size() + n : n);
    }

    @Override
    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public void set(int n, double d) {
                MutableDoubleIndexable.this.set(this.size() - n - 1, d);
            }

            @Override
            public int size() {
                return MutableDoubleIndexable.this.size();
            }

            @Override
            public double get(int n) {
                return MutableDoubleIndexable.this.get(this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return MutableDoubleIndexable.based(MutableDoubleIndexable.this);
            }
        };
    }

    default public void revert(int n, int n2) {
        int n3 = this.size();
        int n4 = Pythonesque.map(n, n3);
        int n5 = Pythonesque.map(n2, n3);
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
    }

    default public void revert() {
        if (this.size() <= 1) {
            return;
        }
        this.revert(0, -1);
    }

    default public void order(@NotNull DoubleOrdering doubleOrdering) {
        TimSortDouble.sort(this, doubleOrdering);
    }

    default public void order() {
        this.order(DoubleOrdering.STANDARD_ASCENDING);
    }

    default public void shuffle(@NotNull Random random) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    @Deprecated
    default public void initByIndex(@NotNull IntToDoubleFunction intToDoubleFunction) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToDoubleFunction.applyAsDouble(i));
        }
    }

    @Override
    @NotNull
    default public List<Double> asList() {
        return new AbstractList<Double>(){

            @Override
            public Double get(int n) {
                return MutableDoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return MutableDoubleIndexable.this.size();
            }

            @Override
            public Double set(int n, Double d) {
                MutableDoubleIndexable.this.set(n, d);
                return d;
            }

            @Override
            public Iterator<Double> iterator() {
                return MutableDoubleIndexable.this.iterator();
            }
        };
    }

    @Override
    @NotNull
    default public MutableDoubleIndexable getCopy() {
        return MutableDoubleIndexable.viewArray(this.toArray());
    }

    @NotNull
    public static Base based(final @NotNull MutableDoubleIndexable mutableDoubleIndexable) {
        if (mutableDoubleIndexable instanceof Base) {
            return (Base)mutableDoubleIndexable;
        }
        return new Base(){

            @Override
            public void set(int n, double d) {
                mutableDoubleIndexable.set(n, d);
            }

            @Override
            public int size() {
                return mutableDoubleIndexable.size();
            }

            @Override
            public double get(int n) {
                return mutableDoubleIndexable.get(n);
            }
        };
    }

    @NotNull
    public static Base init(int n, @NotNull DoubleSupplier doubleSupplier) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = doubleSupplier.getAsDouble();
        }
        return MutableDoubleIndexable.viewArray(dArray);
    }

    @NotNull
    public static Base copyOf(@NotNull Collection<? extends Number> collection) {
        double[] dArray = new double[collection.size()];
        int n = 0;
        for (Number number : collection) {
            dArray[n++] = number.doubleValue();
        }
        return MutableDoubleIndexable.viewArray(dArray);
    }

    @NotNull
    public static <IN> Base copy(@NotNull Collection<IN> collection, @NotNull Function<IN, Number> function) {
        double[] dArray = new double[collection.size()];
        int n = 0;
        for (IN IN : collection) {
            dArray[n++] = function.apply(IN).doubleValue();
        }
        return MutableDoubleIndexable.viewArray(dArray);
    }

    @NotNull
    public static Base empty() {
        return EMPTY;
    }

    @NotNull
    public static Base fromArray(double ... dArray) {
        return MutableDoubleIndexable.fromArray(dArray, 0, dArray.length);
    }

    @NotNull
    public static Base fromArray(@NotNull double[] dArray, int n, int n2) {
        if (n < 0 || n + n2 > dArray.length) {
            throw new IllegalArgumentException("Indexes out of bounds!");
        }
        return MutableDoubleIndexable.viewArray(Arrays.copyOfRange(dArray, n, n + n2));
    }

    @NotNull
    public static Base viewArray(final double ... dArray) {
        return new Base(){

            @Override
            public void set(int n, double d) {
                dArray[n] = d;
            }

            @Override
            public int size() {
                return dArray.length;
            }

            @Override
            public double get(int n) {
                return dArray[n];
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return MutableDoubleIndexable.viewArray(dArray, n, n2 - n);
            }

            @Override
            public void copyInternally(int n, int n2, int n3) {
                System.arraycopy(dArray, n, dArray, n2, n3);
            }

            @Override
            public void order() {
                Arrays.sort(dArray);
            }

            @Override
            public void order(@NotNull DoubleOrdering doubleOrdering) {
                DualPivotQuicksort.sort(dArray, doubleOrdering);
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull double[] dArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative, but is " + n2);
        }
        if (n + n2 > dArray.length) {
            throw new IndexOutOfBoundsException(String.format("end will be outside array: %d + %d > %d", n, n2, dArray.length));
        }
        if (n2 == 0) {
            return MutableDoubleIndexable.empty();
        }
        return new Base(){

            @Override
            public void set(int n3, double d) {
                dArray[n3 + n] = d;
            }

            @Override
            public double get(int n3) {
                return dArray[n3 + n];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return MutableDoubleIndexable.viewArray(dArray, n3 + n, n22 - n3);
            }

            @Override
            public void copyInternally(int n6, int n22, int n3) {
                if (n3 == 0) {
                    return;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("numElements must not be negative!");
                }
                int n4 = Pythonesque.mapX(n6, n2);
                int n5 = Pythonesque.mapX(n22, n2);
                if (n4 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n3, n2));
                }
                if (n5 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n3, n2));
                }
                if (n4 == n5) {
                    return;
                }
                System.arraycopy(dArray, n6 + n, dArray, n22 + n, n3);
            }

            @Override
            public void order() {
                Arrays.sort(dArray, n, n + n2);
            }

            @Override
            public void order(@NotNull DoubleOrdering doubleOrdering) {
                DualPivotQuicksort.sort(dArray, n, n + n2 - 1, doubleOrdering);
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<Double> list) {
        return new Base(){

            @Override
            public void set(int n, double d) {
                list.set(n, d);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public double get(int n) {
                return (Double)list.get(n);
            }
        };
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToDoubleFunction<? super T> toDoubleFunction, final @NotNull DoubleSetter<? super T> doubleSetter) {
        return new Base(){

            @Override
            public void set(int n, double d) {
                doubleSetter.set(indexable.get(n), d);
            }

            @Override
            public double get(int n) {
                return toDoubleFunction.applyAsDouble(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }
        };
    }

    @NotNull
    public static Base fromIndexable(@NotNull Indexable<? extends Number> indexable) {
        return MutableDoubleIndexable.copyOf(indexable.asCollection());
    }

    @NotNull
    public static <B> Base fromIndexable(@NotNull Indexable<B> indexable, @NotNull Function<? super B, ? extends Number> function) {
        double[] dArray = new double[indexable.size()];
        int n = 0;
        for (B b : indexable) {
            dArray[n++] = function.apply(b).doubleValue();
        }
        return MutableDoubleIndexable.viewArray(dArray);
    }

    @NotNull
    public static Base fromDoubleIndexable(@NotNull DoubleIndexable doubleIndexable) {
        return MutableDoubleIndexable.initByIndex(doubleIndexable.size(), doubleIndexable::get);
    }

    @NotNull
    public static Base fromFloatIndexable(@NotNull FloatIndexable floatIndexable) {
        return MutableDoubleIndexable.initByIndex(floatIndexable.size(), floatIndexable::get);
    }

    @NotNull
    public static Base fromLongIndexable(@NotNull LongIndexable longIndexable) {
        return MutableDoubleIndexable.initByIndex(longIndexable.size(), longIndexable::get);
    }

    @NotNull
    public static Base fromIntIndexable(@NotNull IntIndexable intIndexable) {
        return MutableDoubleIndexable.initByIndex(intIndexable.size(), intIndexable::get);
    }

    @NotNull
    public static Base fromShortIndexable(@NotNull ShortIndexable shortIndexable) {
        return MutableDoubleIndexable.initByIndex(shortIndexable.size(), shortIndexable::get);
    }

    @NotNull
    public static Base fromByteIndexable(@NotNull ByteIndexable byteIndexable) {
        return MutableDoubleIndexable.initByIndex(byteIndexable.size(), byteIndexable::get);
    }

    @NotNull
    public static Base fromIterable(int n, @NotNull Iterable<? extends Number> iterable) {
        double[] dArray = new double[n];
        int n2 = 0;
        for (Number number : iterable) {
            dArray[n2++] = number.doubleValue();
            if (n2 != n) continue;
            break;
        }
        return MutableDoubleIndexable.viewArray(dArray);
    }

    @NotNull
    public static Base zeroed(int n) {
        return MutableDoubleIndexable.viewArray(new double[n]);
    }

    @NotNull
    public static Base init(int n, double d) {
        double[] dArray = new double[n];
        Arrays.fill(dArray, d);
        return MutableDoubleIndexable.viewArray(dArray);
    }

    @NotNull
    public static Base initByIndex(int n, @NotNull IntToDoubleFunction intToDoubleFunction) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = intToDoubleFunction.applyAsDouble(i);
        }
        return MutableDoubleIndexable.viewArray(dArray);
    }

    public static abstract class Base
    extends DoubleIndexable.Base
    implements MutableDoubleIndexable {
    }
}

