/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.CharIndexable;
import de.caff.generics.Copyable;
import de.caff.generics.Empty;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.MutableIntIndexable;
import de.caff.generics.PrimitiveCharIterator;
import de.caff.generics.Pythonesque;
import de.caff.generics.Types;
import de.caff.generics.algorithm.DualPivotQuicksort;
import de.caff.generics.function.CharConsumer;
import de.caff.generics.function.CharFunction1;
import de.caff.generics.function.CharOperator2;
import de.caff.generics.function.CharOrdering;
import de.caff.generics.function.CharSetter;
import de.caff.generics.function.FragileCharConsumer;
import de.caff.generics.function.IntToCharFunction1;
import de.caff.generics.function.ToCharFunction;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface MutableCharIndexable
extends CharIndexable,
Copyable<MutableCharIndexable> {
    public static final Base EMPTY = new Base(){

        @Override
        public void set(int n, char c) {
            throw new IndexOutOfBoundsException("Cannot set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public char get(int n) {
            throw new IndexOutOfBoundsException("Cannot get from empty indexable!");
        }

        @Override
        @NotNull
        public ListIterator<Character> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Character> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public PrimitiveCharIterator charIterator() {
            return Types.EMPTY_CHAR_ITERATOR;
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfInt intIterator() {
            return Types.EMPTY_INT_ITERATOR;
        }

        @Override
        @NotNull
        public Collection<Character> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Character> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public char[] toArray() {
            return Empty.CHAR_ARRAY;
        }

        @Override
        @NotNull
        public <T> Indexable<T> viewChars(@NotNull CharFunction1<? extends T> charFunction1) {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public String makeString() {
            return "";
        }

        @Override
        @NotNull
        public CharSequence viewAsCharSequence() {
            return "";
        }

        @Override
        public int addToArray(@NotNull char[] cArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public IntIndexable.Base asIntIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        public char foldLeft(char c, @NotNull CharOperator2 charOperator2) {
            return c;
        }

        @Override
        @NotNull
        public CharIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public MutableCharIndexable getCopy() {
            return this;
        }

        @Override
        public void forEachChar(@NotNull CharConsumer charConsumer) {
        }

        @Override
        public <E extends Exception> void forEachCharFragile(@NotNull FragileCharConsumer<E> fragileCharConsumer) throws E {
        }

        @Override
        public boolean containsChar(char c) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Character> consumer) {
        }

        @Override
        public void order() {
        }

        @Override
        @NotNull
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }
    };

    public void set(int var1, char var2);

    default public void syt(int n, char c) {
        int n2;
        if (n >= 0) {
            this.set(n, c);
        }
        if ((n2 = n + this.size()) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        this.set(n2, c);
    }

    default public void setRange(int n, int n2, char c) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot set a negative length");
        }
        int n3 = Pythonesque.mapX(n, this);
        for (int i = 0; i < n2; ++i) {
            this.set(i + n3, c);
        }
    }

    default public int setFrom(@NotNull Iterable<? extends Character> iterable) {
        return this.setFrom(iterable, 0, this.size());
    }

    default public int setFrom(@NotNull Iterable<? extends Character> iterable, int n, int n2) {
        if (n > this.size() - n2) {
            n2 = this.size() - n;
        }
        int n3 = 0;
        for (Character c : iterable) {
            this.set(n + n3++, c.charValue());
            if (n3 != n2) continue;
            break;
        }
        return n3;
    }

    default public void setFromArray(@NotNull char[] cArray, int n, int n2, int n3) {
        if (n2 + n3 > this.size()) {
            throw new IndexOutOfBoundsException("Overflow: numElements is too large!");
        }
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, cArray[n++]);
        }
    }

    default public void setMulti(int n, int n2, char c) {
        n = Pythonesque.mapX(n, this);
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative: " + n2);
        }
        int n3 = n + n2;
        if (n3 > this.size()) {
            throw new IndexOutOfBoundsException(String.format("from + len exceed size(): %d + %d > %d", n, n2, this.size()));
        }
        for (int i = n; i < n3; ++i) {
            this.set(i, c);
        }
    }

    default public void copyInternally(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("numElements must not be negative!");
        }
        int n4 = this.size();
        int n5 = Pythonesque.mapX(n, n4);
        int n6 = Pythonesque.mapX(n2, n4);
        if (n5 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n5, n3, n4));
        }
        if (n6 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n6, n3, n4));
        }
        if (n5 == n6) {
            return;
        }
        if (n5 < n6 && n5 + n3 > n6) {
            n5 += n3;
            n6 += n3;
            while (--n3 >= 0) {
                this.set(--n6, this.get(--n5));
            }
        } else {
            while (--n3 >= 0) {
                this.set(n6++, this.get(n5++));
            }
        }
    }

    default public void fillFrom(@NotNull IntToCharFunction1 intToCharFunction1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToCharFunction1.applyAsChar(i));
        }
    }

    default public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        char c = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, c);
    }

    default public void swyp(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.swap(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @Override
    @NotNull
    default public Base subSet(final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return new Base(){

            @Override
            public void set(int n4, char c) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                MutableCharIndexable.this.set(n4 + n, c);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public char get(int n4) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                return MutableCharIndexable.this.get(n4 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n22) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n22 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n4 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                }
                return MutableCharIndexable.this.subSet(n + n4, n + n22 - n4);
            }

            @Override
            public void copyInternally(int n6, int n22, int n32) {
                int n4 = Pythonesque.mapX(n, n3);
                int n5 = Pythonesque.mapX(n2, n3);
                if (n4 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n32, n3));
                }
                if (n5 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n32, n3));
                }
                MutableCharIndexable.this.copyInternally(n + n6, n + n22, n32);
            }
        };
    }

    @Override
    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(n < 0 ? this.size() + n : n, n2 < 0 ? this.size() + n2 : n2);
    }

    @Override
    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(n < 0 ? this.size() + n : n, this.size());
    }

    @Override
    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, n < 0 ? this.size() + n : n);
    }

    @Override
    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public void set(int n, char c) {
                MutableCharIndexable.this.set(this.size() - n - 1, c);
            }

            @Override
            public int size() {
                return MutableCharIndexable.this.size();
            }

            @Override
            public char get(int n) {
                return MutableCharIndexable.this.get(this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return MutableCharIndexable.based(MutableCharIndexable.this);
            }
        };
    }

    default public void revert(int n, int n2) {
        int n3 = this.size();
        int n4 = Pythonesque.map(n, n3);
        int n5 = Pythonesque.map(n2, n3);
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
    }

    default public void revert() {
        if (this.size() <= 1) {
            return;
        }
        this.revert(0, -1);
    }

    default public void order() {
        char[] cArray = this.toArray();
        Arrays.sort(cArray);
        this.fillFrom(n -> cArray[n]);
    }

    default public void order(@NotNull CharOrdering charOrdering) {
        char[] cArray = this.toArray();
        DualPivotQuicksort.sort(cArray, charOrdering);
        this.fillFrom(n -> cArray[n]);
    }

    default public void shuffle(@NotNull Random random) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    @Deprecated
    default public void initByIndex(@NotNull IntToCharFunction1 intToCharFunction1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToCharFunction1.applyAsChar(i));
        }
    }

    @Override
    @NotNull
    default public List<Character> asList() {
        return new AbstractList<Character>(){

            @Override
            public Character get(int n) {
                return Character.valueOf(MutableCharIndexable.this.get(n));
            }

            @Override
            public int size() {
                return MutableCharIndexable.this.size();
            }

            @Override
            public Character set(int n, Character c) {
                MutableCharIndexable.this.set(n, c.charValue());
                return c;
            }

            @Override
            public Iterator<Character> iterator() {
                return MutableCharIndexable.this.iterator();
            }
        };
    }

    @Override
    @NotNull
    default public MutableCharIndexable getCopy() {
        return MutableCharIndexable.viewArray(this.toArray());
    }

    @NotNull
    public static Base based(final @NotNull MutableCharIndexable mutableCharIndexable) {
        if (mutableCharIndexable instanceof Base) {
            return (Base)mutableCharIndexable;
        }
        return new Base(){

            @Override
            public void set(int n, char c) {
                mutableCharIndexable.set(n, c);
            }

            @Override
            public int size() {
                return mutableCharIndexable.size();
            }

            @Override
            public char get(int n) {
                return mutableCharIndexable.get(n);
            }
        };
    }

    @NotNull
    public static Base init(int n, @NotNull Supplier<Character> supplier) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = supplier.get().charValue();
        }
        return MutableCharIndexable.viewArray(cArray);
    }

    @NotNull
    public static Base initByIndex(int n, @NotNull IntToCharFunction1 intToCharFunction1) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = intToCharFunction1.applyAsChar(i);
        }
        return MutableCharIndexable.viewArray(cArray);
    }

    @NotNull
    public static Base copyOf(@NotNull Collection<? extends Character> collection) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (Character c : collection) {
            cArray[n++] = c.charValue();
        }
        return MutableCharIndexable.viewArray(cArray);
    }

    @NotNull
    public static <IN> Base copy(@NotNull Collection<IN> collection, @NotNull Function<IN, Character> function) {
        char[] cArray = new char[collection.size()];
        int n = 0;
        for (IN IN : collection) {
            cArray[n++] = function.apply(IN).charValue();
        }
        return MutableCharIndexable.viewArray(cArray);
    }

    @NotNull
    public static Base empty() {
        return EMPTY;
    }

    @NotNull
    public static Base fromArray(char ... cArray) {
        return MutableCharIndexable.fromArray(cArray, 0, cArray.length);
    }

    @NotNull
    public static Base fromArray(@NotNull char[] cArray, int n, int n2) {
        if (n < 0 || n + n2 > cArray.length) {
            throw new IllegalArgumentException("Indexes out of bounds!");
        }
        return MutableCharIndexable.viewArray(Arrays.copyOfRange(cArray, n, n + n2));
    }

    @NotNull
    public static Base viewArray(final @NotNull char[] cArray) {
        return new Base(){

            @Override
            public void set(int n, char c) {
                cArray[n] = c;
            }

            @Override
            public int size() {
                return cArray.length;
            }

            @Override
            public char get(int n) {
                return cArray[n];
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return MutableCharIndexable.viewArray(cArray, n, n2 - n);
            }

            @Override
            public void copyInternally(int n, int n2, int n3) {
                System.arraycopy(cArray, n, cArray, n2, n3);
            }

            @Override
            public void order() {
                Arrays.sort(cArray);
            }

            @Override
            public void order(@NotNull CharOrdering charOrdering) {
                DualPivotQuicksort.sort(cArray, charOrdering);
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull char[] cArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative, but is " + n2);
        }
        if (n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException(String.format("end will be outside array: %d + %d > %d", n, n2, cArray.length));
        }
        if (n2 == 0) {
            return MutableCharIndexable.empty();
        }
        return new Base(){

            @Override
            public void set(int n3, char c) {
                cArray[n3 + n] = c;
            }

            @Override
            public char get(int n3) {
                return cArray[n3 + n];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return MutableCharIndexable.viewArray(cArray, n3 + n, n22 - n3);
            }

            @Override
            public void copyInternally(int n6, int n22, int n3) {
                if (n3 == 0) {
                    return;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("numElements must not be negative!");
                }
                int n4 = Pythonesque.mapX(n6, n2);
                int n5 = Pythonesque.mapX(n22, n2);
                if (n4 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n3, n2));
                }
                if (n5 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n3, n2));
                }
                if (n4 == n5) {
                    return;
                }
                System.arraycopy(cArray, n6 + n, cArray, n22 + n, n3);
            }

            @Override
            public void order() {
                Arrays.sort(cArray, n, n + n2);
            }

            @Override
            public void order(@NotNull CharOrdering charOrdering) {
                DualPivotQuicksort.sort(cArray, n, n + n2 - 1, charOrdering);
            }
        };
    }

    @NotNull
    default public MutableIntIndexable.Base toMutableIntIndexable() {
        return MutableIntIndexable.viewArray(this.toIntArray());
    }

    @NotNull
    public static Base viewList(final @NotNull List<Character> list) {
        return new Base(){

            @Override
            public void set(int n, char c) {
                list.set(n, Character.valueOf(c));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public char get(int n) {
                return ((Character)list.get(n)).charValue();
            }
        };
    }

    @NotNull
    public static Base fromIndexable(@NotNull Indexable<? extends Character> indexable) {
        return MutableCharIndexable.copyOf(indexable.asCollection());
    }

    @NotNull
    public static <B> Base fromIndexable(@NotNull Indexable<B> indexable, @NotNull Function<? super B, ? extends Character> function) {
        char[] cArray = new char[indexable.size()];
        int n = 0;
        for (B b : indexable) {
            cArray[n++] = function.apply(b).charValue();
        }
        return MutableCharIndexable.viewArray(cArray);
    }

    @NotNull
    public static Base fromCharIndexable(@NotNull CharIndexable charIndexable) {
        return MutableCharIndexable.initByIndex(charIndexable.size(), charIndexable::get);
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToCharFunction<? super T> toCharFunction, final @NotNull CharSetter<? super T> charSetter) {
        return new Base(){

            @Override
            public void set(int n, char c) {
                charSetter.set(indexable.get(n), c);
            }

            @Override
            public char get(int n) {
                return toCharFunction.applyAsChar(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }
        };
    }

    @NotNull
    public static Base fromIterable(int n, @NotNull Iterable<? extends Character> iterable) {
        char[] cArray = new char[n];
        int n2 = 0;
        for (Character c : iterable) {
            cArray[n2++] = c.charValue();
            if (n2 != n) continue;
            break;
        }
        return MutableCharIndexable.viewArray(cArray);
    }

    @NotNull
    public static Base zeroed(int n) {
        return MutableCharIndexable.viewArray(new char[n]);
    }

    @NotNull
    public static Base init(int n, char c) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return MutableCharIndexable.viewArray(cArray);
    }

    public static abstract class Base
    extends CharIndexable.Base
    implements MutableCharIndexable {
    }
}

