/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.Copyable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.MutableIntIndexable;
import de.caff.generics.PrimitiveByteIterator;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Types;
import de.caff.generics.algorithm.DualPivotQuicksort;
import de.caff.generics.function.ByteConsumer;
import de.caff.generics.function.ByteOperator2;
import de.caff.generics.function.ByteOrdering;
import de.caff.generics.function.ByteSetter;
import de.caff.generics.function.IntToByteFunction1;
import de.caff.generics.function.ToByteFunction;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface MutableByteIndexable
extends ByteIndexable,
Copyable<MutableByteIndexable> {
    public static final Base EMPTY = new Base(){

        @Override
        public void set(int n, byte by) {
            throw new IndexOutOfBoundsException("Cannot set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public byte get(int n) {
            throw new IndexOutOfBoundsException("Cannot get from empty indexable!");
        }

        @Override
        @NotNull
        public ListIterator<Byte> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Byte> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public PrimitiveByteIterator byteIterator() {
            return Types.EMPTY_BYTE_ITERATOR;
        }

        @Override
        @NotNull
        public Collection<Byte> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Byte> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public byte[] toArray() {
            return Empty.BYTE_ARRAY;
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfInt intIterator() {
            return Types.EMPTY_INT_ITERATOR;
        }

        @Override
        public int addToArray(@NotNull byte[] byArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public IntIndexable.Base asIntIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable.Base asUnsignedIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public byte[] toByteArray() {
            return Empty.BYTE_ARRAY;
        }

        @Override
        public void copyTo(@NotNull byte[] byArray, int n) {
        }

        @Override
        public byte foldLeft(byte by, @NotNull ByteOperator2 byteOperator2) {
            return by;
        }

        @Override
        @NotNull
        public String toHexString() {
            return "";
        }

        @Override
        @NotNull
        public String toHexString(boolean bl) {
            return "";
        }

        @Override
        @NotNull
        public ByteIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public MutableByteIndexable getCopy() {
            return this;
        }

        @Override
        public void initByIndex(@NotNull IntToByteFunction1 intToByteFunction1) {
        }

        @Override
        public void forEachByte(@NotNull ByteConsumer byteConsumer) {
        }

        @Override
        public boolean containsByte(byte by) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Byte> consumer) {
        }

        @Override
        @NotNull
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }
    };

    public void set(int var1, byte var2);

    default public void syt(int n, byte by) {
        int n2;
        if (n >= 0) {
            this.set(n, by);
        }
        if ((n2 = n + this.size()) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        this.set(n2, by);
    }

    default public void setRange(int n, int n2, byte by) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Cannot set a negative length");
        }
        int n3 = Pythonesque.mapX(n, this);
        for (int i = 0; i < n2; ++i) {
            this.set(i + n3, by);
        }
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable) {
        return this.setFrom(iterable, 0, this.size());
    }

    default public int setFrom(@NotNull Iterable<? extends Number> iterable, int n, int n2) {
        if (n > this.size() - n2) {
            n2 = this.size() - n;
        }
        int n3 = 0;
        for (Number number : iterable) {
            this.set(n + n3++, number.byteValue());
            if (n3 != n2) continue;
            break;
        }
        return n3;
    }

    default public void setFromArray(@NotNull byte[] byArray, int n, int n2, int n3) {
        if (n2 + n3 > this.size()) {
            throw new IndexOutOfBoundsException("Overflow: numElements is too large!");
        }
        for (int i = 0; i < n3; ++i) {
            this.set(n2 + i, byArray[n++]);
        }
    }

    default public void setMulti(int n, int n2, byte by) {
        n = Pythonesque.mapX(n, this);
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative: " + n2);
        }
        int n3 = n + n2;
        if (n3 > this.size()) {
            throw new IndexOutOfBoundsException(String.format("from + len exceed size(): %d + %d > %d", n, n2, this.size()));
        }
        for (int i = n; i < n3; ++i) {
            this.set(i, by);
        }
    }

    default public void copyInternally(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("numElements must not be negative!");
        }
        int n4 = this.size();
        int n5 = Pythonesque.mapX(n, n4);
        int n6 = Pythonesque.mapX(n2, n4);
        if (n5 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n5, n3, n4));
        }
        if (n6 + n3 > n4) {
            throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n6, n3, n4));
        }
        if (n5 == n6) {
            return;
        }
        if (n5 < n6 && n5 + n3 > n6) {
            n5 += n3;
            n6 += n3;
            while (--n3 >= 0) {
                this.set(--n6, this.get(--n5));
            }
        } else {
            while (--n3 >= 0) {
                this.set(n6++, this.get(n5++));
            }
        }
    }

    default public void fillFrom(@NotNull IntToByteFunction1 intToByteFunction1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToByteFunction1.applyAsByte(i));
        }
    }

    default public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        byte by = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, by);
    }

    default public void swyp(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.swap(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @Override
    @NotNull
    default public Base subSet(final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return new Base(){

            @Override
            public void set(int n4, byte by) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                MutableByteIndexable.this.set(n4 + n, by);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public byte get(int n4) {
                if (n4 < 0 || n4 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n4);
                }
                return MutableByteIndexable.this.get(n4 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n22) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n22 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n4 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                }
                return MutableByteIndexable.this.subSet(n + n4, n + n22 - n4);
            }

            @Override
            public void copyInternally(int n6, int n22, int n32) {
                int n4 = Pythonesque.mapX(n, n3);
                int n5 = Pythonesque.mapX(n2, n3);
                if (n4 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n32, n3));
                }
                if (n5 + n32 > n3) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n32, n3));
                }
                MutableByteIndexable.this.copyInternally(n + n6, n + n22, n32);
            }
        };
    }

    @Override
    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(n < 0 ? this.size() + n : n, n2 < 0 ? this.size() + n2 : n2);
    }

    @Override
    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(n < 0 ? this.size() + n : n, this.size());
    }

    @Override
    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, n < 0 ? this.size() + n : n);
    }

    @Override
    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public void set(int n, byte by) {
                MutableByteIndexable.this.set(this.size() - n - 1, by);
            }

            @Override
            public int size() {
                return MutableByteIndexable.this.size();
            }

            @Override
            public byte get(int n) {
                return MutableByteIndexable.this.get(this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return MutableByteIndexable.based(MutableByteIndexable.this);
            }
        };
    }

    default public void revert(int n, int n2) {
        int n3 = this.size();
        int n4 = Pythonesque.map(n, n3);
        int n5 = Pythonesque.map(n2, n3);
        while (n4 < n5) {
            this.swap(n4++, n5--);
        }
    }

    default public void revert() {
        if (this.size() <= 1) {
            return;
        }
        this.revert(0, -1);
    }

    default public void order() {
        byte[] byArray = this.toArray();
        Arrays.sort(byArray);
        this.fillFrom(n -> byArray[n]);
    }

    default public void order(@NotNull ByteOrdering byteOrdering) {
        byte[] byArray = this.toArray();
        DualPivotQuicksort.sort(byArray, byteOrdering);
        this.fillFrom(n -> byArray[n]);
    }

    default public void shuffle(@NotNull Random random) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    @NotNull
    default public MutableIntIndexable.Base toMutableIntIndexable() {
        return MutableIntIndexable.viewArray(this.toIntArray());
    }

    @Deprecated
    default public void initByIndex(@NotNull IntToByteFunction1 intToByteFunction1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intToByteFunction1.applyAsByte(i));
        }
    }

    @Override
    @NotNull
    default public List<Byte> asList() {
        return new AbstractList<Byte>(){

            @Override
            public Byte get(int n) {
                return MutableByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return MutableByteIndexable.this.size();
            }

            @Override
            public Byte set(int n, Byte by) {
                MutableByteIndexable.this.set(n, by);
                return by;
            }

            @Override
            public Iterator<Byte> iterator() {
                return MutableByteIndexable.this.iterator();
            }
        };
    }

    @Override
    @NotNull
    default public MutableByteIndexable getCopy() {
        return MutableByteIndexable.viewArray(this.toArray());
    }

    @NotNull
    public static Base based(final @NotNull MutableByteIndexable mutableByteIndexable) {
        if (mutableByteIndexable instanceof Base) {
            return (Base)mutableByteIndexable;
        }
        return new Base(){

            @Override
            public void set(int n, byte by) {
                mutableByteIndexable.set(n, by);
            }

            @Override
            public int size() {
                return mutableByteIndexable.size();
            }

            @Override
            public byte get(int n) {
                return mutableByteIndexable.get(n);
            }
        };
    }

    @NotNull
    public static Base init(int n, @NotNull Supplier<Number> supplier) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = supplier.get().byteValue();
        }
        return MutableByteIndexable.viewArray(byArray);
    }

    @NotNull
    public static Base copyOf(@NotNull Collection<? extends Number> collection) {
        byte[] byArray = new byte[collection.size()];
        int n = 0;
        for (Number number : collection) {
            byArray[n++] = number.byteValue();
        }
        return MutableByteIndexable.viewArray(byArray);
    }

    @NotNull
    public static <IN> Base copy(@NotNull Collection<IN> collection, @NotNull Function<IN, Number> function) {
        byte[] byArray = new byte[collection.size()];
        int n = 0;
        for (IN IN : collection) {
            byArray[n++] = function.apply(IN).byteValue();
        }
        return MutableByteIndexable.viewArray(byArray);
    }

    @NotNull
    public static Base empty() {
        return EMPTY;
    }

    @NotNull
    public static Base fromArray(byte ... byArray) {
        return MutableByteIndexable.fromArray(byArray, 0, byArray.length);
    }

    @NotNull
    public static Base fromArray(@NotNull byte[] byArray, int n, int n2) {
        if (n < 0 || n + n2 > byArray.length) {
            throw new IllegalArgumentException("Indexes out of bounds!");
        }
        return MutableByteIndexable.viewArray(Arrays.copyOfRange(byArray, n, n + n2));
    }

    @NotNull
    public static Base viewArray(final @NotNull byte[] byArray) {
        return new Base(){

            @Override
            public void set(int n, byte by) {
                byArray[n] = by;
            }

            @Override
            public int size() {
                return byArray.length;
            }

            @Override
            public byte get(int n) {
                return byArray[n];
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return MutableByteIndexable.viewArray(byArray, n, n2 - n);
            }

            @Override
            public void copyInternally(int n, int n2, int n3) {
                System.arraycopy(byArray, n, byArray, n2, n3);
            }

            @Override
            public void order() {
                Arrays.sort(byArray);
            }

            @Override
            public void order(@NotNull ByteOrdering byteOrdering) {
                DualPivotQuicksort.sort(byArray, byteOrdering);
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull byte[] byArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative, but is " + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException(String.format("end will be outside array: %d + %d > %d", n, n2, byArray.length));
        }
        if (n2 == 0) {
            return MutableByteIndexable.empty();
        }
        return new Base(){

            @Override
            public void set(int n3, byte by) {
                byArray[n3 + n] = by;
            }

            @Override
            public byte get(int n3) {
                return byArray[n3 + n];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return MutableByteIndexable.viewArray(byArray, n3 + n, n22 - n3);
            }

            @Override
            public void copyInternally(int n6, int n22, int n3) {
                if (n3 == 0) {
                    return;
                }
                if (n3 < 0) {
                    throw new IllegalArgumentException("numElements must not be negative!");
                }
                int n4 = Pythonesque.mapX(n6, n2);
                int n5 = Pythonesque.mapX(n22, n2);
                if (n4 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Reading would overflow: from + numElements > size (%d + %d > %d)!", n4, n3, n2));
                }
                if (n5 + n3 > n2) {
                    throw new IndexOutOfBoundsException(String.format("Writing would overflow: to + numElements > size (%d + %d > %d)!", n5, n3, n2));
                }
                if (n4 == n5) {
                    return;
                }
                System.arraycopy(byArray, n6 + n, byArray, n22 + n, n3);
            }

            @Override
            public void order() {
                Arrays.sort(byArray, n, n + n2);
            }

            @Override
            public void order(@NotNull ByteOrdering byteOrdering) {
                DualPivotQuicksort.sort(byArray, n, n + n2 - 1, byteOrdering);
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<Byte> list) {
        return new Base(){

            @Override
            public void set(int n, byte by) {
                list.set(n, by);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public byte get(int n) {
                return (Byte)list.get(n);
            }
        };
    }

    @NotNull
    public static Base fromIndexable(@NotNull Indexable<? extends Number> indexable) {
        return MutableByteIndexable.copyOf(indexable.asCollection());
    }

    @NotNull
    public static <B> Base fromIndexable(@NotNull Indexable<B> indexable, @NotNull Function<? super B, ? extends Number> function) {
        byte[] byArray = new byte[indexable.size()];
        int n = 0;
        for (B b : indexable) {
            byArray[n++] = function.apply(b).byteValue();
        }
        return MutableByteIndexable.viewArray(byArray);
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToByteFunction<? super T> toByteFunction, final @NotNull ByteSetter<? super T> byteSetter) {
        return new Base(){

            @Override
            public void set(int n, byte by) {
                byteSetter.set(indexable.get(n), by);
            }

            @Override
            public byte get(int n) {
                return toByteFunction.applyAsByte(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }
        };
    }

    @NotNull
    public static Base fromDoubleIndexable(@NotNull DoubleIndexable doubleIndexable) {
        return MutableByteIndexable.initByIndex(doubleIndexable.size(), n -> (byte)doubleIndexable.get(n));
    }

    @NotNull
    public static Base fromFloatIndexable(@NotNull FloatIndexable floatIndexable) {
        return MutableByteIndexable.initByIndex(floatIndexable.size(), n -> (byte)floatIndexable.get(n));
    }

    @NotNull
    public static Base fromLongIndexable(@NotNull LongIndexable longIndexable) {
        return MutableByteIndexable.initByIndex(longIndexable.size(), n -> (byte)longIndexable.get(n));
    }

    @NotNull
    public static Base fromIntIndexable(@NotNull IntIndexable intIndexable) {
        return MutableByteIndexable.initByIndex(intIndexable.size(), n -> (byte)intIndexable.get(n));
    }

    @NotNull
    public static Base fromShortIndexable(@NotNull ShortIndexable shortIndexable) {
        return MutableByteIndexable.initByIndex(shortIndexable.size(), n -> (byte)shortIndexable.get(n));
    }

    @NotNull
    public static Base fromByteIndexable(@NotNull ByteIndexable byteIndexable) {
        return MutableByteIndexable.initByIndex(byteIndexable.size(), byteIndexable::get);
    }

    @NotNull
    public static Base fromIterable(int n, @NotNull Iterable<? extends Number> iterable) {
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (Number number : iterable) {
            byArray[n2++] = number.byteValue();
            if (n2 != n) continue;
            break;
        }
        return MutableByteIndexable.viewArray(byArray);
    }

    @NotNull
    public static Base zeroed(int n) {
        return MutableByteIndexable.viewArray(new byte[n]);
    }

    @NotNull
    public static Base init(int n, byte by) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        return MutableByteIndexable.viewArray(byArray);
    }

    @NotNull
    public static Base initByIndex(int n, @NotNull IntToByteFunction1 intToByteFunction1) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = intToByteFunction1.applyAsByte(i);
        }
        return MutableByteIndexable.viewArray(byArray);
    }

    public static abstract class Base
    extends ByteIndexable.Base
    implements MutableByteIndexable {
    }
}

