/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.Copyable;
import de.caff.generics.Empty;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.PrimitiveBooleanIterator;
import de.caff.generics.Pythonesque;
import de.caff.generics.Types;
import de.caff.generics.function.BooleanConsumer;
import de.caff.generics.function.BooleanOperator2;
import de.caff.generics.function.BooleanSetter;
import de.caff.generics.function.IntPredicate1;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;

public interface MutableBooleanIndexable
extends BooleanIndexable,
Copyable<MutableBooleanIndexable> {
    public static final Base EMPTY = new Base(){

        @Override
        public void set(int n, boolean bl) {
            throw new IndexOutOfBoundsException("Cannot set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean get(int n) {
            throw new IndexOutOfBoundsException("Cannot get from empty indexable!");
        }

        @Override
        @NotNull
        public ListIterator<Boolean> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Boolean> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public PrimitiveBooleanIterator booleanIterator() {
            return Types.EMPTY_BOOLEAN_ITERATOR;
        }

        @Override
        public void initByIndex(@NotNull IntPredicate1 intPredicate1) {
        }

        @Override
        @NotNull
        public Collection<Boolean> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Boolean> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        public boolean foldLeft(boolean bl, @NotNull BooleanOperator2 booleanOperator2) {
            return bl;
        }

        @Override
        @NotNull
        public boolean[] toArray() {
            return Empty.BOOLEAN_ARRAY;
        }

        @Override
        public int addToArray(@NotNull boolean[] blArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public BooleanIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public MutableBooleanIndexable getCopy() {
            return this;
        }

        @Override
        public void forEachBool(@NotNull BooleanConsumer booleanConsumer) {
        }

        @Override
        public boolean containsBool(boolean bl) {
            return false;
        }

        @Override
        public boolean containsTrue() {
            return false;
        }

        @Override
        public boolean containsFalse() {
            return false;
        }

        @Override
        public boolean or() {
            return false;
        }

        @Override
        public boolean and() {
            return false;
        }

        @Override
        public boolean xor() {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Boolean> consumer) {
        }

        @Override
        @NotNull
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }
    };

    public void set(int var1, boolean var2);

    default public void syt(int n, boolean bl) {
        int n2;
        if (n >= 0) {
            this.set(n, bl);
        }
        if ((n2 = n + this.size()) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        this.set(n2, bl);
    }

    default public int setFrom(@NotNull Iterable<? extends Boolean> iterable) {
        return this.setFrom(iterable, 0, this.size());
    }

    default public int setFrom(@NotNull Iterable<? extends Boolean> iterable, int n, int n2) {
        if (n > this.size() - n2) {
            n2 = this.size() - n;
        }
        int n3 = 0;
        for (Boolean bl : iterable) {
            this.set(n + n3++, bl);
            if (n3 != n2) continue;
            break;
        }
        return n3;
    }

    default public void setMulti(int n, int n2, boolean bl) {
        n = Pythonesque.mapX(n, this);
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative: " + n2);
        }
        int n3 = n + n2;
        if (n3 > this.size()) {
            throw new IndexOutOfBoundsException(String.format("from + len exceed size(): %d + %d > %d", n, n2, this.size()));
        }
        for (int i = n; i < n3; ++i) {
            this.set(i, bl);
        }
    }

    default public void swap(int n, int n2) {
        if (n == n2) {
            return;
        }
        boolean bl = this.get(n);
        this.set(n, this.get(n2));
        this.set(n2, bl);
    }

    default public void swyp(int n, int n2) {
        if (n == n2) {
            return;
        }
        this.swap(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    default public void shuffle(@NotNull Random random) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.swap(i, random.nextInt(i + 1));
        }
    }

    @Override
    @NotNull
    default public Base subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return new Base(){

            @Override
            public void set(int n2, boolean bl) {
                if (n2 < 0 || n2 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n2);
                }
                MutableBooleanIndexable.this.set(n2 + n, bl);
            }

            @Override
            public int size() {
                return n3;
            }

            @Override
            public boolean get(int n2) {
                if (n2 < 0 || n2 >= n3) {
                    throw new IndexOutOfBoundsException("index = " + n2);
                }
                return MutableBooleanIndexable.this.get(n2 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return MutableBooleanIndexable.this.subSet(n + n4, n + n2 - n4);
            }
        };
    }

    @Override
    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(n < 0 ? this.size() + n : n, n2 < 0 ? this.size() + n2 : n2);
    }

    @Override
    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(n < 0 ? this.size() + n : n, this.size());
    }

    @Override
    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, n < 0 ? this.size() + n : n);
    }

    @Override
    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public void set(int n, boolean bl) {
                MutableBooleanIndexable.this.set(this.size() - n - 1, bl);
            }

            @Override
            public int size() {
                return MutableBooleanIndexable.this.size();
            }

            @Override
            public boolean get(int n) {
                return MutableBooleanIndexable.this.get(this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return MutableBooleanIndexable.based(MutableBooleanIndexable.this);
            }
        };
    }

    default public void initByIndex(@NotNull IntPredicate1 intPredicate1) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.set(i, intPredicate1.testInt(i));
        }
    }

    @Override
    @NotNull
    default public List<Boolean> asList() {
        return new AbstractList<Boolean>(){

            @Override
            public Boolean get(int n) {
                return MutableBooleanIndexable.this.get(n);
            }

            @Override
            public int size() {
                return MutableBooleanIndexable.this.size();
            }

            @Override
            public Boolean set(int n, Boolean bl) {
                MutableBooleanIndexable.this.set(n, bl);
                return bl;
            }

            @Override
            public Iterator<Boolean> iterator() {
                return MutableBooleanIndexable.this.iterator();
            }
        };
    }

    @Override
    @NotNull
    default public MutableBooleanIndexable getCopy() {
        return MutableBooleanIndexable.viewArray(this.toArray());
    }

    @NotNull
    public static Base based(final @NotNull MutableBooleanIndexable mutableBooleanIndexable) {
        if (mutableBooleanIndexable instanceof Base) {
            return (Base)mutableBooleanIndexable;
        }
        return new Base(){

            @Override
            public void set(int n, boolean bl) {
                mutableBooleanIndexable.set(n, bl);
            }

            @Override
            public int size() {
                return mutableBooleanIndexable.size();
            }

            @Override
            public boolean get(int n) {
                return mutableBooleanIndexable.get(n);
            }
        };
    }

    @NotNull
    public static Base init(int n, @NotNull BooleanSupplier booleanSupplier) {
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = booleanSupplier.getAsBoolean();
        }
        return MutableBooleanIndexable.viewArray(blArray);
    }

    @NotNull
    public static Base copyOf(@NotNull Collection<? extends Boolean> collection) {
        boolean[] blArray = new boolean[collection.size()];
        int n = 0;
        for (Boolean bl : collection) {
            blArray[n++] = bl;
        }
        return MutableBooleanIndexable.viewArray(blArray);
    }

    @NotNull
    public static <IN> Base copy(@NotNull Collection<IN> collection, @NotNull Predicate<IN> predicate) {
        boolean[] blArray = new boolean[collection.size()];
        int n = 0;
        for (IN IN : collection) {
            blArray[n++] = predicate.test(IN);
        }
        return MutableBooleanIndexable.viewArray(blArray);
    }

    @NotNull
    public static Base empty() {
        return EMPTY;
    }

    @NotNull
    public static Base fromArray(boolean ... blArray) {
        return MutableBooleanIndexable.fromArray(blArray, 0, blArray.length);
    }

    @NotNull
    public static Base fromArray(@NotNull boolean[] blArray, int n, int n2) {
        if (n < 0 || n + n2 > blArray.length) {
            throw new IllegalArgumentException("Indexes out of bounds!");
        }
        return MutableBooleanIndexable.viewArray(Arrays.copyOfRange(blArray, n, n + n2));
    }

    @NotNull
    public static Base viewArray(final @NotNull boolean[] blArray) {
        return new Base(){

            @Override
            public void set(int n, boolean bl) {
                blArray[n] = bl;
            }

            @Override
            public int size() {
                return blArray.length;
            }

            @Override
            public boolean get(int n) {
                return blArray[n];
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<Boolean> list) {
        return new Base(){

            @Override
            public void set(int n, boolean bl) {
                list.set(n, bl);
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean get(int n) {
                return (Boolean)list.get(n);
            }
        };
    }

    @NotNull
    public static Base fromIndexable(@NotNull Indexable<? extends Boolean> indexable) {
        return MutableBooleanIndexable.copyOf(indexable.asCollection());
    }

    @NotNull
    public static <B> Base fromIndexable(@NotNull Indexable<B> indexable, @NotNull Predicate<? super B> predicate) {
        boolean[] blArray = new boolean[indexable.size()];
        int n = 0;
        for (B b : indexable) {
            blArray[n++] = predicate.test(b);
        }
        return MutableBooleanIndexable.viewArray(blArray);
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull Predicate<? super T> predicate, final @NotNull BooleanSetter<? super T> booleanSetter) {
        return new Base(){

            @Override
            public void set(int n, boolean bl) {
                booleanSetter.set(indexable.get(n), bl);
            }

            @Override
            public boolean get(int n) {
                return predicate.test(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }
        };
    }

    @NotNull
    public static Base fromBooleanIndexable(@NotNull BooleanIndexable booleanIndexable) {
        return MutableBooleanIndexable.initByIndex(booleanIndexable.size(), booleanIndexable::get);
    }

    @NotNull
    public static Base fromIterable(int n, @NotNull Iterable<? extends Boolean> iterable) {
        boolean[] blArray = new boolean[n];
        int n2 = 0;
        for (Boolean bl : iterable) {
            blArray[n2++] = bl;
            if (n2 != n) continue;
            break;
        }
        return MutableBooleanIndexable.viewArray(blArray);
    }

    @NotNull
    public static Base init(int n, boolean bl) {
        boolean[] blArray = new boolean[n];
        if (bl) {
            Arrays.fill(blArray, true);
        }
        return MutableBooleanIndexable.viewArray(blArray);
    }

    @NotNull
    public static Base initByIndex(int n, @NotNull IntPredicate intPredicate) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n; ++i) {
            blArray[i] = intPredicate.test(i);
        }
        return MutableBooleanIndexable.viewArray(blArray);
    }

    public static abstract class Base
    extends BooleanIndexable.Base
    implements MutableBooleanIndexable {
    }
}

