/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.UniformMatcher;
import de.caff.generics.matcher.Match;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class MatchSet<E>
implements Set<E> {
    private final UniformMatcher<? super E> matcher;
    private final List<E> list = new LinkedList();

    public MatchSet() {
        this(Match.DEFAULT_MATCHER);
    }

    public MatchSet(UniformMatcher<? super E> uniformMatcher) {
        this.matcher = uniformMatcher;
    }

    public MatchSet(UniformMatcher<? super E> uniformMatcher, Iterable<? extends E> iterable) {
        this.matcher = uniformMatcher;
        for (E e : iterable) {
            this.add(e);
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        for (E e : this.list) {
            if (!this.matcher.areEqual(e, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    @NotNull
    public <U> U[] toArray(@NotNull U[] UArray) {
        return this.list.toArray(UArray);
    }

    @Override
    public boolean add(E e) {
        if (!this.contains(e)) {
            this.list.add(e);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        ListIterator<E> listIterator = this.list.listIterator();
        while (listIterator.hasNext()) {
            if (!this.matcher.areEqual(listIterator.next(), object)) continue;
            listIterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        boolean bl = false;
        for (E e : collection) {
            if (!this.add(e)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        boolean bl = false;
        ListIterator<E> listIterator = this.list.listIterator();
        block0: while (listIterator.hasNext()) {
            E e = listIterator.next();
            for (Object obj : collection) {
                if (!this.matcher.areEqual(e, obj)) continue;
                continue block0;
            }
            listIterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.list.clear();
    }
}

