/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BasicLoop;
import de.caff.generics.Countable;
import de.caff.generics.function.Function3;
import de.caff.generics.function.Function4;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class Loop<T>
extends BasicLoop<Item<T>> {
    @NotNull
    private final Function<T, Function3<Item<T>, BasicLoop<Item<T>>, Item<T>, Item<T>>> valueToItemCreator;

    public Loop() {
        Function4<Item, Object, BasicLoop, Item, Item> function4 = Item::new;
        this.valueToItemCreator = function4::partial1;
    }

    public Loop(@NotNull Iterable<T> iterable) {
        Function4<Item, Object, BasicLoop, Item, Item> function4 = Item::new;
        this.valueToItemCreator = function4::partial1;
        this.addAll(iterable);
    }

    @NotNull
    public final Countable<T> values() {
        return this.view(Item::getValue);
    }

    @NotNull
    public Countable<T> closedValueView() {
        return this.closedItemView().view(Item::getValue);
    }

    @NotNull
    public Item<T> add(@NotNull T t) {
        return this.add(this.valueToItemCreator.apply(t));
    }

    public void addAll(@NotNull Iterable<? extends T> iterable) {
        this.addAll(iterable, this.valueToItemCreator);
    }

    public T firstValue() {
        return ((Item)this.first()).getValue();
    }

    public T lastValue() {
        return ((Item)this.last()).getValue();
    }

    @Nullable
    public Item<T> findFirstValue(@NotNull Predicate<? super T> predicate) {
        return super.findFirst(item -> predicate.test(((Item)item).value));
    }

    @Nullable
    public Item<T> findLastValue(@NotNull Predicate<? super T> predicate) {
        return super.findLast(item -> predicate.test(((Item)item).value));
    }

    public boolean rotateForwardUntilValue(@NotNull Predicate<? super T> predicate) {
        return this.rotateForwardUntil(item -> predicate.test(((Item)item).value));
    }

    public boolean rotateBackwardUntilValue(@NotNull Predicate<? super T> predicate) {
        return this.rotateBackwardUntil(item -> predicate.test(((Item)item).value));
    }

    public void forEachValue(@NotNull Consumer<? super T> consumer) {
        this.values().forEach(consumer);
    }

    @Override
    public void clear() {
        this.forEach(BasicLoop.Item::remove);
    }

    public static class Item<T>
    extends BasicLoop.Item<Item<T>> {
        @NotNull
        private T value;

        protected Item(@NotNull T t, @NotNull BasicLoop<Item<T>> basicLoop, @Nullable Item<T> item, @Nullable Item<T> item2) {
            super(basicLoop, item, item2);
            this.value = t;
        }

        @NotNull
        public T getValue() {
            return this.value;
        }

        @NotNull
        public T setValue(@NotNull T t) {
            T t2 = this.value;
            this.value = t;
            return t2;
        }

        @Nullable
        public Item<T> findNextValue(@NotNull Predicate<? super T> predicate) {
            return this.findNext(item -> predicate.test((Object)item.value));
        }

        @Nullable
        public Item<T> findPreviousValue(@NotNull Predicate<? super T> predicate) {
            return this.findPrevious(item -> predicate.test((Object)item.value));
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

