/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.LongIndexable;
import de.caff.generics.function.LongFunction2;
import de.caff.generics.function.LongOperator2;
import de.caff.generics.function.LongPredicate2;
import de.caff.generics.tuple.Tuple;
import de.caff.generics.tuple.Tuple2;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public final class LongPair
implements Serializable,
LongIndexable {
    private static final long serialVersionUID = -4239662296731228131L;
    public final long first;
    public final long second;

    public LongPair(long l, long l2) {
        this.first = l;
        this.second = l2;
    }

    @NotNull
    public LongPair withFirst(long l) {
        if (l == this.first) {
            return this;
        }
        return new LongPair(l, this.second);
    }

    @NotNull
    public LongPair withSecond(long l) {
        if (l == this.second) {
            return this;
        }
        return new LongPair(this.first, l);
    }

    @NotNull
    public LongPair swapped() {
        if (this.first == this.second) {
            return this;
        }
        return new LongPair(this.second, this.first);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public long get(int n) {
        switch (n) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Pair has only 2 elements, so %d is out of bounds!", n));
    }

    public <T> T applyAsLongs(@NotNull LongFunction2<T> longFunction2) {
        return longFunction2.applyAsLong(this.first, this.second);
    }

    public long operate(@NotNull LongOperator2 longOperator2) {
        return longOperator2.applyAsLong(this.first, this.second);
    }

    public boolean test(@NotNull LongPredicate2 longPredicate2) {
        return longPredicate2.testLongs(this.first, this.second);
    }

    @NotNull
    public Tuple2<Long, Long> toTuple() {
        return Tuple.of(this.first, this.second);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LongPair longPair = (LongPair)object;
        return longPair.first == this.first && longPair.second == this.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @NotNull
    public String toString() {
        return String.format(Locale.US, "LongPair(%s, %s)", this.first, this.second);
    }
}

