/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.ByteIndexable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntIndexable;
import de.caff.generics.MutableLongIndexable;
import de.caff.generics.Order;
import de.caff.generics.PrimitiveLongIterable;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Sizeable;
import de.caff.generics.Types;
import de.caff.generics.function.LongOrdering;
import de.caff.generics.range.Range;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntToLongFunction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;

public interface LongIndexable
extends PrimitiveLongIterable,
Sizeable {
    @NotNull
    public static final Base EMPTY = new Base(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public long get(int n) {
            throw new IndexOutOfBoundsException("Empty indexable has no elements!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public long[] toArray() {
            return Empty.LONG_ARRAY;
        }

        @Override
        public int addToArray(@NotNull long[] lArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull long[] lArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        public long foldLeft(long l, @NotNull LongBinaryOperator longBinaryOperator) {
            return l;
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        @NotNull
        public LongIndexable rotated(int n) {
            return this;
        }

        @Override
        @NotNull
        public Iterator<Long> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public ListIterator<Long> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfLong longIterator() {
            return Types.EMPTY_LONG_ITERATOR;
        }

        @Override
        public int compareTo(@NotNull LongIndexable longIndexable) {
            return longIndexable.isEmpty() ? 0 : -1;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof LongIndexable && ((LongIndexable)object).isEmpty();
        }

        @Override
        @NotNull
        public Collection<Long> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Long> asList() {
            return Collections.emptyList();
        }

        @Override
        public void forEachLong(@NotNull LongConsumer longConsumer) {
        }

        @Override
        public boolean containsLong(long l) {
            return false;
        }

        @Override
        @NotNull
        public Base frozen() {
            return this;
        }

        @Override
        public <E> Indexable<E> view(@NotNull LongFunction<E> longFunction) {
            return Indexable.emptyIndexable();
        }

        @Override
        public void forEach(Consumer<? super Long> consumer) {
        }

        @Override
        public long sum() {
            return 0L;
        }

        @Override
        public long sumX() {
            return 0L;
        }

        @Override
        @NotNull
        public OptionalDouble average() {
            return OptionalDouble.empty();
        }

        @Override
        @NotNull
        public Spliterator.OfLong longSpliterator() {
            return Spliterators.emptyLongSpliterator();
        }
    };

    public long get(int var1);

    default public long gyt(int n) {
        return this.get(Pythonesque.mapX(n, this));
    }

    default public long getMod(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw new IndexOutOfBoundsException("No element for empty indexable!");
        }
        return this.gyt(n % n2);
    }

    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public int size() {
                return LongIndexable.this.size();
            }

            @Override
            public long get(int n) {
                return LongIndexable.this.get(LongIndexable.this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return LongIndexable.this.asBase();
            }
        };
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    default public PrimitiveIterator.OfLong longIterator() {
        return this.longIterator(0, this.size());
    }

    @NotNull
    default public PrimitiveIterator.OfLong longIterator(final int n, final int n2) {
        return new PrimitiveIterator.OfLong(){
            private int index;
            {
                this.index = n;
            }

            @Override
            public long nextLong() {
                if (this.index >= n2) {
                    throw new NoSuchElementException(String.format("Index %s out of allowed range [%d, %d[!", this.index, n, n2));
                }
                return LongIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < n2;
            }
        };
    }

    @Override
    @NotNull
    default public Iterator<Long> iterator() {
        return this.listIterator();
    }

    @NotNull
    default public ListIterator<Long> listIterator() {
        return new ListIterator<Long>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < LongIndexable.this.size();
            }

            @Override
            public Long next() {
                if (this.index >= LongIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return LongIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Long previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                return LongIndexable.this.get(--this.index);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Long l) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Long l) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    default public Base subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return n3 == 0 ? EMPTY : new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public long get(int n2) {
                if (n2 >= n3) {
                    throw new IndexOutOfBoundsException("No such element: " + n2);
                }
                return LongIndexable.this.get(n2 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > n3) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return LongIndexable.this.subSet(n + n4, n + n2);
            }
        };
    }

    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    default public Base headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @NotNull
    default public Collection<Long> asCollection() {
        return new AbstractCollection<Long>(){

            @Override
            @NotNull
            public Iterator<Long> iterator() {
                return LongIndexable.this.iterator();
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public List<Long> asList() {
        return new AbstractList<Long>(){

            @Override
            public Long get(int n) {
                return LongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }

            @Override
            @NotNull
            public Iterator<Long> iterator() {
                return LongIndexable.this.iterator();
            }
        };
    }

    @NotNull
    default public ArrayList<Long> toList() {
        ArrayList<Long> arrayList = new ArrayList<Long>(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    default public void addAllTo(@NotNull Collection<? super Long> collection) {
        for (Long l : this) {
            collection.add(l);
        }
    }

    @NotNull
    default public Indexable<Long> asIndexable() {
        return new Indexable.Base<Long>(){

            @Override
            public Long get(int n) {
                return LongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public long[] toArray() {
        if (this.isEmpty()) {
            return Empty.LONG_ARRAY;
        }
        long[] lArray = new long[this.size()];
        this.addToArray(lArray, 0);
        return lArray;
    }

    default public int addToArray(@NotNull long[] lArray, int n) {
        return this.addToArray(lArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull long[] lArray, int n, int n2, int n3) {
        PrimitiveIterator.OfLong ofLong = this.longIterator(n2, n2 + n3);
        while (ofLong.hasNext()) {
            lArray[n++] = ofLong.nextLong();
        }
        return n;
    }

    @NotNull
    default public Iterable<Integer> indexes() {
        return Range.indexes(this.size());
    }

    @NotNull
    default public IntIndexable intIndexes() {
        return IntIndexable.rangeFromSize(this.size());
    }

    default public long foldLeft(long l, @NotNull LongBinaryOperator longBinaryOperator) {
        long l2 = l;
        PrimitiveIterator.OfLong ofLong = this.longIterator();
        while (ofLong.hasNext()) {
            l2 = longBinaryOperator.applyAsLong(l2, ofLong.nextLong());
        }
        return l2;
    }

    default public int nextMatch(int n, @NotNull LongPredicate longPredicate) {
        int n2 = this.size();
        for (int i = Pythonesque.mapX(n, this); i < n2; ++i) {
            if (!longPredicate.test(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int firstMatch(@NotNull LongPredicate longPredicate) {
        return this.nextMatch(0, longPredicate);
    }

    default public int previousMatch(int n, @NotNull LongPredicate longPredicate) {
        for (int i = Pythonesque.mapX(n, this); i >= 0; --i) {
            if (!longPredicate.test(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int lastMatch(@NotNull LongPredicate longPredicate) {
        return this.previousMatch(-1, longPredicate);
    }

    @NotNull
    default public LongIndexable frozen() {
        return IndexableHelper.frozenFromArray(this.toArray());
    }

    @NotNull
    default public Spliterator.OfLong longSpliterator() {
        return new LongIndexableSpliterator(this);
    }

    @NotNull
    default public Spliterator.OfLong frozenLongSpliterator() {
        LongIndexable longIndexable = this.frozen();
        return new LongIndexableSpliterator(longIndexable, 0, longIndexable.size(), true);
    }

    @NotNull
    default public LongIndexable withInsertedValueAt(int n, final long l) {
        final int n2 = n;
        final int n3 = this.size() + 1;
        if (n2 == 0) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public long get(int n) {
                    return n == 0 ? l : LongIndexable.this.get(n - 1);
                }
            };
        }
        if (n2 == n3 - 1) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public long get(int n) {
                    return n == n3 - 1 ? l : LongIndexable.this.get(n);
                }
            };
        }
        return new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public long get(int n) {
                if (n == n2) {
                    return l;
                }
                return LongIndexable.this.get(n < n2 ? n : n - 1);
            }
        };
    }

    @NotNull
    default public LongIndexable withAppendedValue(long l) {
        return this.withInsertedValueAt(this.size(), l);
    }

    @NotNull
    default public LongIndexable withExchangedValueAt(int n, final long l) {
        final int n2 = Pythonesque.mapX(n, this);
        return new Base(){

            @Override
            public long get(int n) {
                return n == n2 ? l : LongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable withRemovedValueAt(int n) {
        final int n2 = Pythonesque.mapX(n, this);
        if (n2 == 0) {
            return this.tailSet(1);
        }
        final int n3 = this.size() - 1;
        if (n2 == n3) {
            return this.headSet(-1);
        }
        return new Base(){

            @Override
            public long get(int n) {
                return n < n2 ? LongIndexable.this.get(n) : LongIndexable.this.get(n + 1);
            }

            @Override
            public int size() {
                return n3;
            }
        };
    }

    @NotNull
    default public LongIndexable withSwappedValuesAt(int n, int n2) {
        int n3;
        final int n4 = Pythonesque.mapX(n, this);
        if (n4 == (n3 = Pythonesque.mapX(n2, this))) {
            return this;
        }
        return new Base(){

            @Override
            public long get(int n) {
                if (n == n4) {
                    return LongIndexable.this.get(n3);
                }
                if (n == n3) {
                    return LongIndexable.this.get(n4);
                }
                return LongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable rotated(int n) {
        if ((n %= this.size()) == 0) {
            return this;
        }
        if (n < 0) {
            n += this.size();
        }
        final int n2 = n;
        return new Base(){

            @Override
            public long get(int n) {
                return LongIndexable.this.get((n + n2) % this.size());
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }

            @Override
            @NotNull
            public LongIndexable rotated(int n) {
                return LongIndexable.this.rotated(n2 + n);
            }
        };
    }

    @NotNull
    default public LongIndexable viewOp(@NotNull LongUnaryOperator longUnaryOperator) {
        return LongIndexable.viewByIndex(this.size(), n -> longUnaryOperator.applyAsLong(this.get(n)));
    }

    @NotNull
    default public DoubleIndexable viewAsDouble() {
        return new DoubleIndexable.Base(){

            @Override
            public double get(int n) {
                return LongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public DoubleIndexable viewAsDouble(final @NotNull LongToDoubleFunction longToDoubleFunction) {
        return new DoubleIndexable.Base(){

            @Override
            public double get(int n) {
                return longToDoubleFunction.applyAsDouble(LongIndexable.this.get(n));
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public FloatIndexable viewAsFloat() {
        return new FloatIndexable.Base(){

            @Override
            public float get(int n) {
                return LongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable viewAsInt() {
        return new IntIndexable.Base(){

            @Override
            public int get(int n) {
                return (int)LongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable viewAsInt(final @NotNull LongToIntFunction longToIntFunction) {
        return new IntIndexable.Base(){

            @Override
            public int get(int n) {
                return longToIntFunction.applyAsInt(LongIndexable.this.get(n));
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ShortIndexable viewAsShort() {
        return new ShortIndexable.Base(){

            @Override
            public short get(int n) {
                return (short)LongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ByteIndexable viewAsByte() {
        return new ByteIndexable.Base(){

            @Override
            public byte get(int n) {
                return (byte)LongIndexable.this.get(n);
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    default public BooleanIndexable viewAsBoolean(final @NotNull LongPredicate longPredicate) {
        return new BooleanIndexable.Base(){

            @Override
            public boolean get(int n) {
                return longPredicate.test(LongIndexable.this.get(n));
            }

            @Override
            public int size() {
                return LongIndexable.this.size();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public long get(int n) {
                return ((Number)list.get(n)).longValue();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list, final int n) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public long get(int n2) {
                Number number = (Number)list.get(n2);
                return number != null ? number.longValue() : (long)n;
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static <T> Base viewList(final @NotNull List<T> list, final @NotNull ToLongFunction<? super T> toLongFunction) {
        return new Base(){

            @Override
            public long get(int n) {
                return toLongFunction.applyAsLong(list.get(n));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable) {
        if (indexable.isEmpty()) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public long get(int n) {
                return ((Number)indexable.get(n)).longValue();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable, final long l) {
        if (indexable.isEmpty()) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public long get(int n) {
                Number number = (Number)indexable.get(n);
                return number != null ? number.longValue() : l;
            }
        };
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToLongFunction<? super T> toLongFunction) {
        return new Base(){

            @Override
            public long get(int n) {
                return toLongFunction.applyAsLong(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean isEmpty() {
                return indexable.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewNumberArray(final Number ... numberArray) {
        return new Base(){

            @Override
            public int size() {
                return numberArray.length;
            }

            @Override
            public long get(int n) {
                return numberArray[n].longValue();
            }
        };
    }

    @NotNull
    public static Base viewArray(final long ... lArray) {
        return new Base(){

            @Override
            public int size() {
                return lArray.length;
            }

            @Override
            public long get(int n) {
                return lArray[n];
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull long[] lArray, final int n, final int n2) {
        if (n < 0 || n2 < 0 || n + n2 > lArray.length) {
            throw new IndexOutOfBoundsException("Start or end outside of range!");
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            public long get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("Index %d outside range [0, %d[!", n3, n2));
                }
                return lArray[n3 + n];
            }
        };
    }

    @NotNull
    public static <T> Base viewArray(final @NotNull T[] TArray, final @NotNull ToLongFunction<? super T> toLongFunction) {
        if (TArray.length == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public long get(int n) {
                return toLongFunction.applyAsLong(TArray[n]);
            }

            @Override
            public int size() {
                return TArray.length;
            }
        };
    }

    @NotNull
    public static Base singleton(final long l) {
        return new Base(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public long get(int n) {
                if (n != 0) {
                    throw new IndexOutOfBoundsException(String.format("Index %d for indexable of size 1!", n));
                }
                return l;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Base reverse() {
                return this;
            }

            @Override
            @NotNull
            public Collection<Long> asCollection() {
                return Collections.singleton(l);
            }

            @Override
            @NotNull
            public List<Long> asList() {
                return Collections.singletonList(l);
            }

            @Override
            @NotNull
            public long[] toArray() {
                return new long[]{l};
            }

            @Override
            public int addToArray(@NotNull long[] lArray, int n) {
                lArray[n] = l;
                return n + 1;
            }

            @Override
            @NotNull
            public DoubleIndexable viewAsDouble() {
                return super.viewAsDouble();
            }

            @Override
            @NotNull
            public Iterable<Integer> indexes() {
                return IntIndexable.singleton(0);
            }

            @Override
            public long sum() {
                return l;
            }

            @Override
            public long sumX() {
                return l;
            }

            @Override
            @NotNull
            public OptionalDouble average() {
                return OptionalDouble.of(l);
            }
        };
    }

    @NotNull
    public static Base init(final int n, final long l) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public long get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return l;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            @NotNull
            public LongIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    public static Base viewByIndex(final int n, final @NotNull IntToLongFunction intToLongFunction) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public long get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return intToLongFunction.applyAsLong(n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public static LongIndexable initByIndex(int n, @NotNull IntToLongFunction intToLongFunction) {
        return LongIndexable.viewByIndex(n, intToLongFunction).frozen();
    }

    @NotNull
    public static Base emptyIndexable() {
        return EMPTY;
    }

    @NotNull
    public static String toString(@NotNull LongIndexable longIndexable) {
        if (longIndexable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(longIndexable.get(0));
        PrimitiveIterator.OfLong ofLong = longIndexable.tailSet(1).longIterator();
        while (ofLong.hasNext()) {
            stringBuilder.append(',').append(ofLong.nextLong());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static boolean equal(@NotNull LongIndexable longIndexable, @NotNull LongIndexable longIndexable2) {
        if (longIndexable == longIndexable2) {
            return true;
        }
        if (longIndexable.size() != longIndexable2.size()) {
            return false;
        }
        PrimitiveIterator.OfLong ofLong = longIndexable.longIterator();
        PrimitiveIterator.OfLong ofLong2 = longIndexable2.longIterator();
        while (ofLong.hasNext() && ofLong2.hasNext()) {
            if (ofLong.nextLong() == ofLong2.nextLong()) continue;
            return false;
        }
        return !ofLong.hasNext() && !ofLong2.hasNext();
    }

    public static boolean equal(@NotNull LongIndexable longIndexable, @Nullable Object object) {
        if (object instanceof LongIndexable) {
            return LongIndexable.equal(longIndexable, (LongIndexable)object);
        }
        return false;
    }

    public static int compare(@NotNull LongIndexable longIndexable, @NotNull LongIndexable longIndexable2) {
        PrimitiveIterator.OfLong ofLong = longIndexable.longIterator();
        PrimitiveIterator.OfLong ofLong2 = longIndexable2.longIterator();
        while (ofLong.hasNext() && ofLong2.hasNext()) {
            int n = Long.compare(ofLong.nextLong(), ofLong2.nextLong());
            if (n == 0) continue;
            return n;
        }
        if (ofLong.hasNext()) {
            return 1;
        }
        if (ofLong2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int compareUnsigned(@NotNull LongIndexable longIndexable, @NotNull LongIndexable longIndexable2) {
        PrimitiveIterator.OfLong ofLong = longIndexable.longIterator();
        PrimitiveIterator.OfLong ofLong2 = longIndexable2.longIterator();
        while (ofLong.hasNext() && ofLong2.hasNext()) {
            int n = Long.compareUnsigned(ofLong.nextLong(), ofLong2.nextLong());
            if (n == 0) continue;
            return n;
        }
        if (ofLong.hasNext()) {
            return 1;
        }
        if (ofLong2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int hash(@NotNull LongIndexable longIndexable) {
        int n = 1;
        PrimitiveIterator.OfLong ofLong = longIndexable.longIterator();
        while (ofLong.hasNext()) {
            n = 31 * n + Long.hashCode(ofLong.next());
        }
        return n;
    }

    @NotNull
    public static Base withCachedHash(final @NotNull LongIndexable longIndexable) {
        final int n = LongIndexable.hash(longIndexable);
        return new Base(){

            @Override
            public int size() {
                return longIndexable.size();
            }

            @Override
            public long get(int n2) {
                return longIndexable.get(n2);
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfLong longIterator() {
                return longIndexable.longIterator();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfLong longIterator(int n3, int n2) {
                return longIndexable.longIterator(n3, n2);
            }

            @Override
            @NotNull
            public Iterator<Long> iterator() {
                return longIndexable.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Long> listIterator() {
                return longIndexable.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n2) {
                return longIndexable.subSet(n3, n2);
            }

            @Override
            public int addToArray(@NotNull long[] lArray, int n2) {
                return longIndexable.addToArray(lArray, n2);
            }

            @Override
            public int addToArray(@NotNull long[] lArray, int n4, int n2, int n3) {
                return longIndexable.addToArray(lArray, n4, n2, n3);
            }

            @Override
            public int hashCode() {
                return n;
            }

            @Override
            public boolean equals(Object object) {
                return LongIndexable.equal(longIndexable, object);
            }

            @Override
            public String toString() {
                return LongIndexable.toString(longIndexable);
            }
        };
    }

    default public <E> Indexable<E> view(final @NotNull LongFunction<E> longFunction) {
        return new Indexable.Base<E>(){

            @Override
            public int size() {
                return LongIndexable.this.size();
            }

            @Override
            public E get(int n) {
                return longFunction.apply(LongIndexable.this.get(n));
            }
        };
    }

    default public boolean isOrdered(@NotNull LongOrdering longOrdering) {
        if (this.size() < 2) {
            return true;
        }
        long l = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            long l2 = this.get(i);
            if (longOrdering.checkLong(l2, l) == Order.Descending) {
                return false;
            }
            l = l2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered(@NotNull LongOrdering longOrdering) {
        if (this.size() < 2) {
            return true;
        }
        long l = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            long l2 = this.get(i);
            if (longOrdering.checkLong(l2, l) != Order.Ascending) {
                return false;
            }
            l = l2;
        }
        return true;
    }

    default public int binarySearch(long l) {
        int n = 0;
        int n2 = this.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            long l2 = this.get(n3);
            if (l2 < l) {
                n = n3 + 1;
                continue;
            }
            if (l2 > l) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    default public int binarySearch(long l, @NotNull LongOrdering longOrdering) {
        int n = 0;
        int n2 = this.size() - 1;
        block4: while (n <= n2) {
            int n3 = n + n2 >>> 1;
            long l2 = this.get(n3);
            switch (longOrdering.checkLong(l2, l)) {
                case Ascending: {
                    n = n3 + 1;
                    continue block4;
                }
                case Descending: {
                    n2 = n3 - 1;
                    continue block4;
                }
            }
            return n3;
        }
        return -(n + 1);
    }

    @NotNull
    default public MutableLongIndexable ordered(@NotNull LongOrdering longOrdering) {
        MutableLongIndexable.Base base = MutableLongIndexable.fromLongIndexable(this);
        base.order(longOrdering);
        return base;
    }

    @NotNull
    default public MutableLongIndexable ordered() {
        MutableLongIndexable.Base base = MutableLongIndexable.fromLongIndexable(this);
        base.order();
        return base;
    }

    @NotNull
    default public Base asBase() {
        return new Base(){

            @Override
            public int size() {
                return LongIndexable.this.size();
            }

            @Override
            public long get(int n) {
                return LongIndexable.this.get(n);
            }

            @Override
            @NotNull
            public Base reverse() {
                return LongIndexable.this.reverse();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfLong longIterator() {
                return LongIndexable.this.longIterator();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfLong longIterator(int n, int n2) {
                return LongIndexable.this.longIterator(n, n2);
            }

            @Override
            @NotNull
            public Iterator<Long> iterator() {
                return LongIndexable.this.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Long> listIterator() {
                return LongIndexable.this.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return LongIndexable.this.subSet(n, n2);
            }

            @Override
            @NotNull
            public long[] toArray() {
                return LongIndexable.this.toArray();
            }

            @Override
            public int addToArray(@NotNull long[] lArray, int n) {
                return LongIndexable.this.addToArray(lArray, n);
            }

            @Override
            public int addToArray(@NotNull long[] lArray, int n, int n2, int n3) {
                return LongIndexable.this.addToArray(lArray, n, n2, n3);
            }
        };
    }

    public static abstract class Base
    implements LongIndexable,
    Comparable<LongIndexable> {
        @Override
        public int compareTo(@NotNull LongIndexable longIndexable) {
            Objects.requireNonNull(longIndexable);
            return LongIndexable.compare(this, longIndexable);
        }

        public int hashCode() {
            return LongIndexable.hash(this);
        }

        public boolean equals(Object object) {
            return LongIndexable.equal((LongIndexable)this, object);
        }

        public String toString() {
            return LongIndexable.toString(this);
        }

        @Override
        @NotNull
        public Base asBase() {
            return this;
        }
    }

    public static class LongIndexableSpliterator
    implements Spliterator.OfLong {
        @NotNull
        private final LongIndexable indexable;
        private int index;
        private final int fence;
        private final int character;

        public LongIndexableSpliterator(@NotNull LongIndexable longIndexable) {
            this(longIndexable, 0, longIndexable.size(), false);
        }

        public LongIndexableSpliterator(@NotNull LongIndexable longIndexable, int n, int n2, boolean bl) {
            this(longIndexable, n, n2, bl ? 17488 : 16464);
        }

        private LongIndexableSpliterator(@NotNull LongIndexable longIndexable, int n, int n2, int n3) {
            this.indexable = longIndexable;
            this.index = n;
            this.fence = n2;
            this.character = n3;
        }

        @Override
        public Spliterator.OfLong trySplit() {
            int n = this.index;
            int n2 = (n + this.fence) / 2;
            if (n < n2) {
                this.index = n2;
                return new LongIndexableSpliterator(this.indexable, n, n2, this.character);
            }
            return null;
        }

        @Override
        public boolean tryAdvance(@NotNull LongConsumer longConsumer) {
            if (this.index < this.fence) {
                longConsumer.accept(this.indexable.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.character;
        }
    }
}

