/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import java.util.ListIterator;
import java.util.function.Function;

public class ListIteratorConverter<T, S>
implements ListIterator<T> {
    @NotNull
    private final ListIterator<S> sourceIterator;
    @NotNull
    private final Function<? super S, T> mapper;

    public ListIteratorConverter(@NotNull ListIterator<S> listIterator, @NotNull Function<? super S, T> function) {
        this.sourceIterator = listIterator;
        this.mapper = function;
    }

    @Override
    public boolean hasNext() {
        return this.sourceIterator.hasNext();
    }

    @Override
    public T next() {
        return this.mapper.apply(this.sourceIterator.next());
    }

    @Override
    public boolean hasPrevious() {
        return this.sourceIterator.hasPrevious();
    }

    @Override
    public T previous() {
        return this.mapper.apply(this.sourceIterator.previous());
    }

    @Override
    public int nextIndex() {
        return this.sourceIterator.nextIndex();
    }

    @Override
    public int previousIndex() {
        return this.sourceIterator.previousIndex();
    }

    @Override
    public void remove() {
        this.sourceIterator.remove();
    }

    @Override
    public void set(T t) {
        throw new UnsupportedOperationException("No set() for wrapping list iterator!");
    }

    @Override
    public void add(T t) {
        throw new UnsupportedOperationException("No add() for wrapping list iterator!");
    }
}

