/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.util.Counter;
import de.caff.generics.util.ThreadSafeCounter;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public class LeastRecentlyUsedCache<K, V> {
    private final int leastRecentLimit;
    @NotNull
    protected final Map<K, SoftReference<V>> map;
    @NotNull
    private final LinkedList<V> leastRecentCache = new LinkedList();
    @NotNull
    private final Counter numHits = new ThreadSafeCounter();
    @NotNull
    private final Counter numGarbageCollected = new ThreadSafeCounter();
    @NotNull
    private final Counter numMisses = new ThreadSafeCounter();

    public LeastRecentlyUsedCache(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("leastRecentLimit has to be non-negative, but is " + n);
        }
        this.leastRecentLimit = n;
        this.map = new HashMap<K, SoftReference<V>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLeastRecent(@NotNull V v) {
        if (this.leastRecentLimit == 0) {
            return;
        }
        LinkedList<V> linkedList = this.leastRecentCache;
        synchronized (linkedList) {
            this.leastRecentCache.removeIf(object2 -> Objects.deepEquals(object2, v));
            this.leastRecentCache.add(v);
            if (this.leastRecentCache.size() > this.leastRecentLimit) {
                this.leastRecentCache.removeFirst();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromLeastRecent(@Nullable V v) {
        if (v == null || this.leastRecentLimit == 0) {
            return;
        }
        LinkedList<V> linkedList = this.leastRecentCache;
        synchronized (linkedList) {
            this.leastRecentCache.removeIf(object2 -> Objects.deepEquals(object2, v));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Map<K, SoftReference<V>> map = this.map;
        synchronized (map) {
            for (Map.Entry<K, SoftReference<V>> entry : new HashSet<Map.Entry<K, SoftReference<V>>>(this.map.entrySet())) {
                if (entry.getValue().get() != null) continue;
                this.numGarbageCollected.add1();
                this.map.remove(entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map<K, SoftReference<V>> map = this.map;
        synchronized (map) {
            this.cleanup();
            return this.map.size();
        }
    }

    public int getLeastRecentCacheDepth() {
        return this.leastRecentLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<K, SoftReference<V>> map = this.map;
        synchronized (map) {
            this.cleanup();
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V get(@NotNull K k) {
        V v;
        Map<K, SoftReference<V>> map = this.map;
        synchronized (map) {
            SoftReference<V> softReference = this.map.get(k);
            if (softReference == null) {
                this.numMisses.add1();
                return null;
            }
            v = softReference.get();
            if (v == null) {
                assert (!this.leastRecentCache.contains(v));
                this.numGarbageCollected.add1();
                this.map.remove(k);
            }
        }
        if (v != null) {
            this.numHits.add1();
            this.updateLeastRecent(v);
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k, @NotNull V v) {
        SoftReference<V> softReference;
        Objects.requireNonNull(v);
        Map<K, SoftReference<V>> map = this.map;
        synchronized (map) {
            softReference = this.map.put(k, new SoftReference<V>(v));
        }
        if (softReference != null) {
            this.removeFromLeastRecent(softReference.get());
        }
        this.updateLeastRecent(v);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V computeIfAbsent(K k, @NotNull Function<? super K, ? extends V> function) {
        Map<K, SoftReference<V>> map = this.map;
        synchronized (map) {
            V v = this.get(k);
            if (v != null) {
                return v;
            }
            V v2 = function.apply(k);
            if (v2 != null) {
                this.put(k, v2);
            }
            return v2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<K> keys() {
        Map<K, SoftReference<V>> map = this.map;
        synchronized (map) {
            this.cleanup();
            return this.map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public V remove(K k) {
        SoftReference<V> softReference;
        Map<K, SoftReference<V>> map = this.map;
        synchronized (map) {
            softReference = this.map.remove(k);
        }
        if (softReference != null) {
            map = softReference.get();
            this.removeFromLeastRecent(map);
            return (V)map;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.map;
        synchronized (object) {
            this.map.clear();
        }
        object = this.leastRecentCache;
        synchronized (object) {
            this.leastRecentCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<V> getLeastRecentlyUsed() {
        ArrayList<V> arrayList;
        if (this.leastRecentLimit == 0) {
            return Collections.emptyList();
        }
        LinkedList<V> linkedList = this.leastRecentCache;
        synchronized (linkedList) {
            arrayList = new ArrayList<V>(this.leastRecentCache);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public int getNumHits() {
        return this.numHits.getValue();
    }

    public int getNumGarbageCollected() {
        return this.numGarbageCollected.getValue();
    }

    public int getNumMisses() {
        return this.numMisses.getValue();
    }
}

