/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.LazyEvalutionFailure;
import de.caff.generics.function.FragileFunction0;
import de.caff.generics.util.IReference;
import de.caff.generics.util.ReferenceType;
import java.util.function.Supplier;

public interface Lazy<T>
extends Supplier<T> {
    @NotNull
    public static <V> Lazy<V> from(final @NotNull Supplier<? extends V> supplier) {
        return new Lazy<V>(){
            private boolean initialized = false;
            private V value;

            @Override
            public synchronized V get() {
                if (!this.initialized) {
                    this.value = supplier.get();
                    this.initialized = true;
                }
                return this.value;
            }
        };
    }

    @NotNull
    public static <V> Lazy<V> fromFragile(@NotNull FragileFunction0<? extends V, ?> fragileFunction0) {
        return Lazy.from(Lazy.wrapFragile(fragileFunction0));
    }

    @NotNull
    public static <V> Lazy<V> from(final @NotNull ReferenceType referenceType, final @NotNull Supplier<? extends V> supplier) {
        if (referenceType == ReferenceType.Hard) {
            return Lazy.from(supplier);
        }
        return new Lazy<V>(){
            private IReference<V> reference;

            @Override
            public synchronized V get() {
                Object object;
                if (this.reference != null) {
                    object = this.reference.get();
                    if (object != null) {
                        return object;
                    }
                    if (this.reference.isNull()) {
                        return null;
                    }
                }
                this.reference = (object = supplier.get()) == null ? IReference.nullRef() : referenceType.makeReference(object);
                return object;
            }
        };
    }

    @NotNull
    public static <V> Lazy<V> softFrom(@NotNull Supplier<? extends V> supplier) {
        return Lazy.from(ReferenceType.Soft, supplier);
    }

    @NotNull
    public static <V> Lazy<V> softFromFragile(@NotNull FragileFunction0<? extends V, ?> fragileFunction0) {
        return Lazy.from(ReferenceType.Soft, Lazy.wrapFragile(fragileFunction0));
    }

    @NotNull
    public static <V> Lazy<V> weakFrom(@NotNull Supplier<? extends V> supplier) {
        return Lazy.from(ReferenceType.Weak, supplier);
    }

    @NotNull
    public static <V> Lazy<V> weakFromFragile(@NotNull FragileFunction0<? extends V, ?> fragileFunction0) {
        return Lazy.from(ReferenceType.Weak, Lazy.wrapFragile(fragileFunction0));
    }

    @NotNull
    public static <V> Supplier<V> wrapFragile(@NotNull FragileFunction0<? extends V, ?> fragileFunction0) {
        return () -> {
            try {
                return fragileFunction0.apply();
            }
            catch (Exception exception) {
                throw new LazyEvalutionFailure(exception);
            }
        };
    }
}

