/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import java.util.Iterator;
import java.util.function.Function;

public class IteratorConverter<T, S>
implements Iterator<T> {
    @NotNull
    private final Iterator<S> iterator;
    @NotNull
    private final Function<? super S, ? extends T> typeConverter;

    public IteratorConverter(@NotNull Iterator<S> iterator, @NotNull Function<? super S, ? extends T> function) {
        this.iterator = iterator;
        this.typeConverter = function;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return this.typeConverter.apply(this.iterator.next());
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

