/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongPair;
import de.caff.generics.Primitives;
import de.caff.generics.function.IntFunction2;
import de.caff.generics.function.IntOperator2;
import de.caff.generics.function.IntPredicate2;
import de.caff.generics.tuple.Tuple;
import de.caff.generics.tuple.Tuple2;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public final class IntPair
implements Serializable,
IntIndexable {
    private static final long serialVersionUID = -7731025648686928268L;
    public final int first;
    public final int second;

    public IntPair(int n, int n2) {
        this.first = n;
        this.second = n2;
    }

    @NotNull
    public LongPair toLongPair() {
        return new LongPair(this.first, this.second);
    }

    @NotNull
    public LongPair toUnsignedLongPair() {
        return new LongPair(Primitives.unsigned(this.first), Primitives.unsigned(this.second));
    }

    @NotNull
    public IntPair withFirst(int n) {
        if (n == this.first) {
            return this;
        }
        return new IntPair(n, this.second);
    }

    @NotNull
    public IntPair withSecond(int n) {
        if (n == this.second) {
            return this;
        }
        return new IntPair(this.first, n);
    }

    @NotNull
    public IntPair swapped() {
        if (this.first == this.second) {
            return this;
        }
        return new IntPair(this.second, this.first);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public int get(int n) {
        switch (n) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Pair has only 2 elements, so %d is out of bounds!", n));
    }

    public <T> T applyAsInts(@NotNull IntFunction2<T> intFunction2) {
        return intFunction2.applyAsInt(this.first, this.second);
    }

    public int operate(@NotNull IntOperator2 intOperator2) {
        return intOperator2.applyAsInt(this.first, this.second);
    }

    public boolean test(@NotNull IntPredicate2 intPredicate2) {
        return intPredicate2.testInts(this.first, this.second);
    }

    @NotNull
    public Tuple2<Integer, Integer> toTuple() {
        return Tuple.of(this.first, this.second);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        IntPair intPair = (IntPair)object;
        return intPair.first == this.first && intPair.second == this.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @NotNull
    public String toString() {
        return String.format(Locale.US, "IntPair(%s, %s)", this.first, this.second);
    }
}

