/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.ByteIndexable;
import de.caff.generics.CharIndexable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntCountable;
import de.caff.generics.LongIndexable;
import de.caff.generics.MutableIntIndexable;
import de.caff.generics.Order;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Types;
import de.caff.generics.function.FragileIntConsumer;
import de.caff.generics.function.IntOrdering;
import de.caff.generics.function.IntToCharFunction1;
import de.caff.generics.range.Range;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.ToIntFunction;

public interface IntIndexable
extends IntCountable {
    @NotNull
    public static final Base EMPTY = new Base(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int get(int n) {
            throw new IndexOutOfBoundsException("Empty indexable has no elements!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public int[] toArray() {
            return Empty.INT_ARRAY;
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return EMPTY;
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        @NotNull
        public IntIndexable rotated(int n) {
            return this;
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public ListIterator<Integer> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfInt intIterator() {
            return Types.EMPTY_INT_ITERATOR;
        }

        @Override
        public int foldLeft(int n, @NotNull IntBinaryOperator intBinaryOperator) {
            return n;
        }

        @Override
        @NotNull
        public Collection<Integer> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Integer> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public LongIndexable.Base asLongIndexable() {
            return LongIndexable.EMPTY;
        }

        @Override
        @NotNull
        public LongIndexable.Base asUnsignedIndexable() {
            return LongIndexable.EMPTY;
        }

        @Override
        public void forEachInt(@NotNull IntConsumer intConsumer) {
        }

        @Override
        public <E extends Exception> void forEachIntFragile(@NotNull FragileIntConsumer<E> fragileIntConsumer) throws E {
        }

        @Override
        public boolean containsInt(int n) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Integer> consumer) {
        }

        @Override
        @NotNull
        public Base frozen() {
            return this;
        }

        @Override
        public int sum() {
            return 0;
        }

        @Override
        public int sumX() {
            return 0;
        }

        @Override
        public long longSum() {
            return 0L;
        }

        @Override
        public long longSumX() {
            return 0L;
        }

        @Override
        @NotNull
        public OptionalDouble average() {
            return OptionalDouble.empty();
        }

        @Override
        @NotNull
        public Spliterator.OfInt intSpliterator() {
            return Spliterators.emptyIntSpliterator();
        }

        @Override
        public int compareTo(@NotNull IntIndexable intIndexable) {
            return intIndexable.isEmpty() ? 0 : -1;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof IntIndexable && ((IntIndexable)object).isEmpty();
        }
    };
    @NotNull
    public static final Base SINGLE_0 = IntIndexable.singleton(0);

    public int get(int var1);

    default public int gyt(int n) {
        return this.get(Pythonesque.mapX(n, this));
    }

    default public int getMod(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw new IndexOutOfBoundsException("No element for empty indexable!");
        }
        return this.gyt(n % n2);
    }

    @NotNull
    default public Base with(int n, int n2) {
        int[] nArray = this.toArray();
        nArray[n] = n2;
        return IntIndexable.viewArray(nArray);
    }

    @NotNull
    default public Base wyth(int n, int n2) {
        if (n > 0) {
            return this.with(n, n2);
        }
        int n3 = n + this.size();
        if (n3 < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        return this.with(n3, n2);
    }

    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public int size() {
                return IntIndexable.this.size();
            }

            @Override
            public int get(int n) {
                return IntIndexable.this.get(IntIndexable.this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return IntIndexable.this.asBase();
            }
        };
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    default public PrimitiveIterator.OfInt intIterator() {
        return this.intIterator(0, this.size());
    }

    @NotNull
    default public PrimitiveIterator.OfInt intIterator(final int n, final int n2) {
        return new PrimitiveIterator.OfInt(){
            private int index;
            {
                this.index = n;
            }

            @Override
            public int nextInt() {
                if (this.index >= n2) {
                    throw new NoSuchElementException(String.format("Index %s out of allowed range [%d, %d[!", this.index, n, n2));
                }
                return IntIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < n2;
            }
        };
    }

    default public void forEachIntEntry(@NotNull EntryConsumer entryConsumer) {
        for (int i = 0; i < this.size(); ++i) {
            entryConsumer.accept(i, this.get(i));
        }
    }

    @Override
    @NotNull
    default public Iterator<Integer> iterator() {
        return this.listIterator();
    }

    @NotNull
    default public ListIterator<Integer> listIterator() {
        return new ListIterator<Integer>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < IntIndexable.this.size();
            }

            @Override
            public Integer next() {
                if (this.index >= IntIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return IntIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Integer previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                return IntIndexable.this.get(--this.index);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Integer n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Integer n) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    default public Base subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return n3 == 0 ? EMPTY : new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public int get(int n2) {
                if (n2 >= n3) {
                    throw new IndexOutOfBoundsException("No such element: " + n2);
                }
                return IntIndexable.this.get(n2 + n);
            }

            @Override
            public int addToArray(@NotNull int[] nArray, int n4, int n2, int n32) {
                return IntIndexable.this.addToArray(nArray, n4, n2 + n, n32);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > n3) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return IntIndexable.this.subSet(n + n4, n + n2);
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator(int n4, int n2) {
                return IntIndexable.this.intIterator(n4 + n, n2 + n);
            }
        };
    }

    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @Override
    @NotNull
    default public int[] toArray() {
        if (this.isEmpty()) {
            return Empty.INT_ARRAY;
        }
        int[] nArray = new int[this.size()];
        this.addToArray(nArray, 0);
        return nArray;
    }

    @Override
    default public int addToArray(@NotNull int[] nArray, int n) {
        return this.addToArray(nArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull int[] nArray, int n, int n2, int n3) {
        PrimitiveIterator.OfInt ofInt = this.intIterator(n2, n2 + n3);
        while (ofInt.hasNext()) {
            nArray[n++] = ofInt.nextInt();
        }
        return n;
    }

    @Override
    @NotNull
    default public Collection<Integer> asCollection() {
        return new AbstractCollection<Integer>(){

            @Override
            @NotNull
            public Iterator<Integer> iterator() {
                return IntIndexable.this.iterator();
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public List<Integer> asList() {
        return new AbstractList<Integer>(){

            @Override
            public Integer get(int n) {
                return IntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }

            @Override
            @NotNull
            public Iterator<Integer> iterator() {
                return IntIndexable.this.iterator();
            }
        };
    }

    @Override
    @NotNull
    default public ArrayList<Integer> toList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    @Override
    default public void addAllTo(@NotNull Collection<? super Integer> collection) {
        for (Integer n : this) {
            collection.add(n);
        }
    }

    @NotNull
    default public Indexable<Integer> asIndexable() {
        return new Indexable.Base<Integer>(){

            @Override
            public Integer get(int n) {
                return IntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public Iterable<Integer> indexes() {
        return Range.indexes(this.size());
    }

    @NotNull
    default public IntIndexable intIndexes() {
        return IntIndexable.rangeFromSize(this.size());
    }

    @NotNull
    default public LongIndexable.Base asLongIndexable() {
        return new LongIndexable.Base(){

            @Override
            public int size() {
                return IntIndexable.this.size();
            }

            @Override
            public long get(int n) {
                return IntIndexable.this.get(n);
            }
        };
    }

    @NotNull
    default public <T> Indexable<T> view(final @NotNull IntFunction<? extends T> intFunction) {
        return new Indexable.Base<T>(){

            @Override
            public int size() {
                return IntIndexable.this.size();
            }

            @Override
            public T get(int n) {
                return intFunction.apply(IntIndexable.this.get(n));
            }
        };
    }

    @NotNull
    default public LongIndexable.Base asUnsignedIndexable() {
        return new LongIndexable.Base(){

            @Override
            public int size() {
                return IntIndexable.this.size();
            }

            @Override
            public long get(int n) {
                return (long)IntIndexable.this.get(n) & 0xFFFFFFFFL;
            }
        };
    }

    default public int foldLeft(int n, @NotNull IntBinaryOperator intBinaryOperator) {
        int n2 = n;
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            n2 = intBinaryOperator.applyAsInt(n2, ofInt.nextInt());
        }
        return n2;
    }

    default public int nextMatch(int n, @NotNull IntPredicate intPredicate) {
        int n2 = this.size();
        for (int i = Pythonesque.mapX(n, this); i < n2; ++i) {
            if (!intPredicate.test(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int firstMatch(@NotNull IntPredicate intPredicate) {
        return this.nextMatch(0, intPredicate);
    }

    default public int previousMatch(int n, @NotNull IntPredicate intPredicate) {
        for (int i = Pythonesque.mapX(n, this); i >= 0; --i) {
            if (!intPredicate.test(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int lastMatch(@NotNull IntPredicate intPredicate) {
        return this.previousMatch(-1, intPredicate);
    }

    @Override
    @NotNull
    default public IntIndexable frozen() {
        return IndexableHelper.frozenFromArray(this.toArray());
    }

    @NotNull
    default public Spliterator.OfInt intSpliterator() {
        return new IntIndexableSpliterator(this);
    }

    @NotNull
    default public Spliterator.OfInt frozenIntSpliterator() {
        IntIndexable intIndexable = this.frozen();
        return new IntIndexableSpliterator(intIndexable, 0, intIndexable.size(), true);
    }

    @NotNull
    default public IntIndexable withInsertedValueAt(int n, final int n2) {
        final int n3 = n;
        final int n4 = this.size() + 1;
        if (n3 == 0) {
            return new Base(){

                @Override
                public int size() {
                    return n4;
                }

                @Override
                public int get(int n) {
                    return n == 0 ? n2 : IntIndexable.this.get(n - 1);
                }
            };
        }
        if (n3 == n4 - 1) {
            return new Base(){

                @Override
                public int size() {
                    return n4;
                }

                @Override
                public int get(int n) {
                    return n == n4 - 1 ? n2 : IntIndexable.this.get(n);
                }
            };
        }
        return new Base(){

            @Override
            public int size() {
                return n4;
            }

            @Override
            public int get(int n) {
                if (n == n3) {
                    return n2;
                }
                return IntIndexable.this.get(n < n3 ? n : n - 1);
            }
        };
    }

    @NotNull
    default public IntIndexable withAppendedValue(int n) {
        return this.withInsertedValueAt(this.size(), n);
    }

    @NotNull
    default public IntIndexable withExchangedValueAt(int n, final int n2) {
        final int n3 = Pythonesque.mapX(n, this);
        return new Base(){

            @Override
            public int get(int n) {
                return n == n3 ? n2 : IntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable withRemovedValueAt(int n) {
        final int n2 = Pythonesque.mapX(n, this);
        if (n2 == 0) {
            return this.tailSet(1);
        }
        final int n3 = this.size() - 1;
        if (n2 == n3) {
            return this.headSet(-1);
        }
        return new Base(){

            @Override
            public int get(int n) {
                return n < n2 ? IntIndexable.this.get(n) : IntIndexable.this.get(n + 1);
            }

            @Override
            public int size() {
                return n3;
            }
        };
    }

    @NotNull
    default public IntIndexable withSwappedValuesAt(int n, int n2) {
        int n3;
        final int n4 = Pythonesque.mapX(n, this);
        if (n4 == (n3 = Pythonesque.mapX(n2, this))) {
            return this;
        }
        return new Base(){

            @Override
            public int get(int n) {
                if (n == n4) {
                    return IntIndexable.this.get(n3);
                }
                if (n == n3) {
                    return IntIndexable.this.get(n4);
                }
                return IntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable rotated(int n) {
        if ((n %= this.size()) == 0) {
            return this;
        }
        if (n < 0) {
            n += this.size();
        }
        final int n2 = n;
        return new Base(){

            @Override
            public int get(int n) {
                return IntIndexable.this.get((n + n2) % this.size());
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }

            @Override
            @NotNull
            public IntIndexable rotated(int n) {
                return IntIndexable.this.rotated(n2 + n);
            }
        };
    }

    @NotNull
    default public IntIndexable viewOp(@NotNull IntUnaryOperator intUnaryOperator) {
        return IntIndexable.viewByIndex(this.size(), n -> intUnaryOperator.applyAsInt(this.get(n)));
    }

    @NotNull
    default public DoubleIndexable viewAsDouble() {
        return new DoubleIndexable.Base(){

            @Override
            public double get(int n) {
                return IntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public DoubleIndexable viewAsDouble(final @NotNull IntToDoubleFunction intToDoubleFunction) {
        return new DoubleIndexable.Base(){

            @Override
            public double get(int n) {
                return intToDoubleFunction.applyAsDouble(IntIndexable.this.get(n));
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public FloatIndexable viewAsFloat() {
        return new FloatIndexable.Base(){

            @Override
            public float get(int n) {
                return IntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsLong() {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return IntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsUnsignedLong() {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return (long)IntIndexable.this.get(n) & 0xFFFFFFFFL;
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsLong(final @NotNull IntToLongFunction intToLongFunction) {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return intToLongFunction.applyAsLong(IntIndexable.this.get(n));
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ShortIndexable viewAsShort() {
        return new ShortIndexable.Base(){

            @Override
            public short get(int n) {
                return (short)IntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ByteIndexable viewAsByte() {
        return new ByteIndexable.Base(){

            @Override
            public byte get(int n) {
                return (byte)IntIndexable.this.get(n);
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public BooleanIndexable viewAsBoolean(final @NotNull IntPredicate intPredicate) {
        return new BooleanIndexable.Base(){

            @Override
            public boolean get(int n) {
                return intPredicate.test(IntIndexable.this.get(n));
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    default public CharIndexable viewAsChar(final @NotNull IntToCharFunction1 intToCharFunction1) {
        return new CharIndexable.Base(){

            @Override
            public char get(int n) {
                return intToCharFunction1.applyAsChar(IntIndexable.this.get(n));
            }

            @Override
            public int size() {
                return IntIndexable.this.size();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public int get(int n) {
                return ((Number)list.get(n)).intValue();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list, final int n) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public int get(int n2) {
                Number number = (Number)list.get(n2);
                return number != null ? number.intValue() : n;
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static <T> Base viewList(final @NotNull List<T> list, final @NotNull ToIntFunction<? super T> toIntFunction) {
        return new Base(){

            @Override
            public int get(int n) {
                return toIntFunction.applyAsInt(list.get(n));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public int get(int n) {
                return ((Number)indexable.get(n)).intValue();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable, final int n) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public int get(int n2) {
                Number number = (Number)indexable.get(n2);
                return number != null ? number.intValue() : n;
            }
        };
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToIntFunction<? super T> toIntFunction) {
        return new Base(){

            @Override
            public int get(int n) {
                return toIntFunction.applyAsInt(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean isEmpty() {
                return indexable.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewNumberArray(final Number ... numberArray) {
        return new Base(){

            @Override
            public int size() {
                return numberArray.length;
            }

            @Override
            public int get(int n) {
                return numberArray[n].intValue();
            }
        };
    }

    @NotNull
    public static Base viewArray(final int ... nArray) {
        return new Base(){

            @Override
            public int size() {
                return nArray.length;
            }

            @Override
            public int get(int n) {
                return nArray[n];
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull int[] nArray, final int n, final int n2) {
        if (n < 0 || n2 < 0 || n + n2 > nArray.length) {
            throw new IndexOutOfBoundsException("Start or end outside of range!");
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            public int get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("Index %d outside range [0, %d[!", n3, n2));
                }
                return nArray[n3 + n];
            }
        };
    }

    @NotNull
    public static <T> Base viewArray(final @NotNull T[] TArray, final @NotNull ToIntFunction<? super T> toIntFunction) {
        if (TArray.length == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int get(int n) {
                return toIntFunction.applyAsInt(TArray[n]);
            }

            @Override
            public int size() {
                return TArray.length;
            }
        };
    }

    @NotNull
    public static Base init(final int n, final int n2) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public int get(int n3) {
                if (n3 < 0 || n3 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n3, n));
                }
                return n2;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            @NotNull
            public IntIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    public static Base viewByIndex(final int n, final @NotNull IntUnaryOperator intUnaryOperator) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public int get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return intUnaryOperator.applyAsInt(n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public static IntIndexable initByIndex(int n, @NotNull IntUnaryOperator intUnaryOperator) {
        return IntIndexable.viewByIndex(n, intUnaryOperator).frozen();
    }

    @NotNull
    public static Base singleton(final int n) {
        return new Base(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public int get(int n2) {
                if (n2 != 0) {
                    throw new IndexOutOfBoundsException(String.format("Index %d for indexable of size 1!", n2));
                }
                return n;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Base reverse() {
                return this;
            }

            @Override
            @NotNull
            public IntIndexable rotated(int n2) {
                return this;
            }

            @Override
            @NotNull
            public Collection<Integer> asCollection() {
                return Collections.singleton(n);
            }

            @Override
            @NotNull
            public List<Integer> asList() {
                return Collections.singletonList(n);
            }

            @Override
            @NotNull
            public int[] toArray() {
                return new int[]{n};
            }

            @Override
            public int addToArray(@NotNull int[] nArray, int n2) {
                nArray[n2] = n;
                return n2 + 1;
            }

            @Override
            @NotNull
            public Iterable<Integer> indexes() {
                return SINGLE_0;
            }

            @Override
            @NotNull
            public IntIndexable intIndexes() {
                return SINGLE_0;
            }

            @Override
            public int sum() {
                return n;
            }

            @Override
            public int sumX() {
                return n;
            }

            @Override
            public long longSum() {
                return n;
            }

            @Override
            public long longSumX() {
                return n;
            }

            @Override
            @NotNull
            public OptionalDouble average() {
                return OptionalDouble.of(n);
            }
        };
    }

    @NotNull
    public static Base emptyIndexable() {
        return EMPTY;
    }

    @NotNull
    public static String toString(@NotNull IntIndexable intIndexable) {
        if (intIndexable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(intIndexable.get(0));
        PrimitiveIterator.OfInt ofInt = intIndexable.tailSet(1).intIterator();
        while (ofInt.hasNext()) {
            stringBuilder.append(',').append(ofInt.nextInt());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static boolean equal(@NotNull IntIndexable intIndexable, @NotNull IntIndexable intIndexable2) {
        if (intIndexable == intIndexable2) {
            return true;
        }
        if (intIndexable.size() != intIndexable2.size()) {
            return false;
        }
        PrimitiveIterator.OfInt ofInt = intIndexable.intIterator();
        PrimitiveIterator.OfInt ofInt2 = intIndexable2.intIterator();
        while (ofInt.hasNext() && ofInt2.hasNext()) {
            if (ofInt.nextInt() == ofInt2.nextInt()) continue;
            return false;
        }
        return !ofInt.hasNext() && !ofInt2.hasNext();
    }

    public static boolean equal(@NotNull IntIndexable intIndexable, @Nullable Object object) {
        if (object instanceof IntIndexable) {
            return IntIndexable.equal(intIndexable, (IntIndexable)object);
        }
        return false;
    }

    public static int compare(@NotNull IntIndexable intIndexable, @NotNull IntIndexable intIndexable2) {
        PrimitiveIterator.OfInt ofInt = intIndexable.intIterator();
        PrimitiveIterator.OfInt ofInt2 = intIndexable2.intIterator();
        while (ofInt.hasNext() && ofInt2.hasNext()) {
            int n = Integer.compare(ofInt.nextInt(), ofInt2.nextInt());
            if (n == 0) continue;
            return n;
        }
        if (ofInt.hasNext()) {
            return 1;
        }
        if (ofInt2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int compareUnsigned(@NotNull IntIndexable intIndexable, @NotNull IntIndexable intIndexable2) {
        PrimitiveIterator.OfInt ofInt = intIndexable.intIterator();
        PrimitiveIterator.OfInt ofInt2 = intIndexable2.intIterator();
        while (ofInt.hasNext() && ofInt2.hasNext()) {
            int n = Integer.compareUnsigned(ofInt.nextInt(), ofInt2.nextInt());
            if (n == 0) continue;
            return n;
        }
        if (ofInt.hasNext()) {
            return 1;
        }
        if (ofInt2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int hash(@NotNull IntIndexable intIndexable) {
        int n = 1;
        PrimitiveIterator.OfInt ofInt = intIndexable.intIterator();
        while (ofInt.hasNext()) {
            n = 31 * n + Integer.hashCode(ofInt.next());
        }
        return n;
    }

    @NotNull
    public static Base withCachedHash(final @NotNull IntIndexable intIndexable) {
        final int n = IntIndexable.hash(intIndexable);
        return new Base(){

            @Override
            public int size() {
                return intIndexable.size();
            }

            @Override
            public int get(int n2) {
                return intIndexable.get(n2);
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator() {
                return intIndexable.intIterator();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator(int n3, int n2) {
                return intIndexable.intIterator(n3, n2);
            }

            @Override
            @NotNull
            public Iterator<Integer> iterator() {
                return intIndexable.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Integer> listIterator() {
                return intIndexable.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n2) {
                return IntIndexable.withCachedHash(intIndexable.subSet(n3, n2));
            }

            @Override
            public int addToArray(@NotNull int[] nArray, int n2) {
                return intIndexable.addToArray(nArray, n2);
            }

            @Override
            public int addToArray(@NotNull int[] nArray, int n4, int n2, int n3) {
                return intIndexable.addToArray(nArray, n4, n2, n3);
            }

            @Override
            public int hashCode() {
                return n;
            }

            @Override
            public boolean equals(Object object) {
                return IntIndexable.equal(intIndexable, object);
            }

            @Override
            public String toString() {
                return IntIndexable.toString(intIndexable);
            }
        };
    }

    @NotNull
    public static IntIndexable range(final int n, int n2, final int n3) {
        if (n3 == 0) {
            throw new IllegalArgumentException("stepSize must not be 0!");
        }
        long l = ((long)n2 - (long)n + (long)n3) / (long)n3;
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(String.format("Cannot create indexable with too large size %s", l));
        }
        if (l <= 0L) {
            return EMPTY;
        }
        final int n4 = (int)l;
        return new Base(){

            @Override
            public int size() {
                return n4;
            }

            @Override
            public int get(int n2) {
                if (n2 < 0 || n2 >= n4) {
                    throw new IndexOutOfBoundsException("[" + n2 + "]");
                }
                return n + n2 * n3;
            }
        };
    }

    @NotNull
    public static IntIndexable range(int n, int n2) {
        return IntIndexable.range(n, n2, n2 < n ? -1 : 1);
    }

    @NotNull
    public static IntIndexable rangeFromSize(final int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size must not be negative!");
        }
        switch (n) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                return SINGLE_0;
            }
        }
        return new Base(){

            @Override
            public int get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException("[" + n2 + "]");
                }
                return n2;
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    default public boolean isOrdered(@NotNull IntOrdering intOrdering) {
        if (this.size() < 2) {
            return true;
        }
        int n = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            int n2 = this.get(i);
            if (intOrdering.checkInt(n2, n) == Order.Descending) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered(@NotNull IntOrdering intOrdering) {
        if (this.size() < 2) {
            return true;
        }
        int n = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            int n2 = this.get(i);
            if (intOrdering.checkInt(n2, n) != Order.Ascending) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    default public int binarySearch(int n) {
        int n2 = 0;
        int n3 = this.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.get(n4);
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    default public int binarySearch(int n, @NotNull IntOrdering intOrdering) {
        int n2 = 0;
        int n3 = this.size() - 1;
        block4: while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.get(n4);
            switch (intOrdering.checkInt(n5, n)) {
                case Ascending: {
                    n2 = n4 + 1;
                    continue block4;
                }
                case Descending: {
                    n3 = n4 - 1;
                    continue block4;
                }
            }
            return n4;
        }
        return -(n2 + 1);
    }

    @NotNull
    default public MutableIntIndexable ordered(@NotNull IntOrdering intOrdering) {
        MutableIntIndexable.Base base = MutableIntIndexable.fromIntIndexable(this);
        base.order(intOrdering);
        return base;
    }

    @NotNull
    default public MutableIntIndexable ordered() {
        MutableIntIndexable.Base base = MutableIntIndexable.fromIntIndexable(this);
        base.order();
        return base;
    }

    @Override
    @NotNull
    default public Base asBase() {
        return new Base(){

            @Override
            public int size() {
                return IntIndexable.this.size();
            }

            @Override
            public int get(int n) {
                return IntIndexable.this.get(n);
            }

            @Override
            @NotNull
            public Base reverse() {
                return IntIndexable.this.reverse();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator() {
                return IntIndexable.this.intIterator();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator(int n, int n2) {
                return IntIndexable.this.intIterator(n, n2);
            }

            @Override
            @NotNull
            public Iterator<Integer> iterator() {
                return IntIndexable.this.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Integer> listIterator() {
                return IntIndexable.this.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return IntIndexable.this.subSet(n, n2);
            }

            @Override
            @NotNull
            public int[] toArray() {
                return IntIndexable.this.toArray();
            }

            @Override
            public int addToArray(@NotNull int[] nArray, int n) {
                return IntIndexable.this.addToArray(nArray, n);
            }

            @Override
            public int addToArray(@NotNull int[] nArray, int n, int n2, int n3) {
                return IntIndexable.this.addToArray(nArray, n, n2, n3);
            }

            @Override
            @NotNull
            public LongIndexable.Base asLongIndexable() {
                return IntIndexable.this.asLongIndexable();
            }

            @Override
            @NotNull
            public LongIndexable.Base asUnsignedIndexable() {
                return IntIndexable.this.asUnsignedIndexable();
            }
        };
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void accept(int var1, int var2);
    }

    public static abstract class Base
    extends IntCountable.Base
    implements IntIndexable,
    Comparable<IntIndexable> {
        @Override
        public int compareTo(@NotNull IntIndexable intIndexable) {
            Objects.requireNonNull(intIndexable);
            return IntIndexable.compare(this, intIndexable);
        }

        @Override
        public int hashCode() {
            return IntIndexable.hash(this);
        }

        @Override
        public boolean equals(Object object) {
            return IntIndexable.equal((IntIndexable)this, object);
        }

        @Override
        public String toString() {
            return IntIndexable.toString(this);
        }

        @Override
        @NotNull
        public Base asBase() {
            return this;
        }
    }

    public static class IntIndexableSpliterator
    implements Spliterator.OfInt {
        @NotNull
        private final IntIndexable indexable;
        private int index;
        private final int fence;
        private final int character;

        public IntIndexableSpliterator(@NotNull IntIndexable intIndexable) {
            this(intIndexable, 0, intIndexable.size(), false);
        }

        public IntIndexableSpliterator(@NotNull IntIndexable intIndexable, int n, int n2, boolean bl) {
            this(intIndexable, n, n2, bl ? 17488 : 16464);
        }

        private IntIndexableSpliterator(@NotNull IntIndexable intIndexable, int n, int n2, int n3) {
            this.indexable = intIndexable;
            this.index = n;
            this.fence = n2;
            this.character = n3;
        }

        @Override
        public Spliterator.OfInt trySplit() {
            int n = this.index;
            int n2 = (n + this.fence) / 2;
            if (n < n2) {
                this.index = n2;
                return new IntIndexableSpliterator(this.indexable, n, n2, this.character);
            }
            return null;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (this.index < this.fence) {
                intConsumer.accept(this.indexable.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.character;
        }
    }
}

