/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Countable;
import de.caff.generics.Empty;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntIndexable;
import de.caff.generics.MutableIntIndexable;
import de.caff.generics.PrimitiveIntIterable;
import de.caff.generics.Sizeable;
import de.caff.generics.function.FragileIntConsumer;
import de.caff.generics.function.IntOrdering;
import de.caff.generics.util.Counter;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.ToIntFunction;

public interface IntCountable
extends PrimitiveIntIterable,
Sizeable {
    public static final IntCountable EMPTY = new Base(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfInt intIterator() {
            return new PrimitiveIterator.OfInt(){

                @Override
                public int nextInt() {
                    throw new NoSuchElementException();
                }

                @Override
                public boolean hasNext() {
                    return false;
                }
            };
        }

        @Override
        @NotNull
        public Collection<Integer> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public int[] toArray() {
            return Empty.INT_ARRAY;
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public ArrayList<Integer> toList() {
            return new ArrayList<Integer>();
        }

        @Override
        public void addAllTo(@NotNull Collection<? super Integer> collection) {
        }

        @Override
        @NotNull
        public PrimitiveIntIterable filtered(@NotNull IntPredicate intPredicate) {
            return this;
        }

        @Override
        public <E extends Exception> void forEachIntFragile(@NotNull FragileIntConsumer<E> fragileIntConsumer) throws E {
        }

        @Override
        public void forEachInt(@NotNull IntConsumer intConsumer) {
        }

        @Override
        @NotNull
        public IntIndexable sorted(@NotNull IntOrdering intOrdering) {
            return IntIndexable.emptyIndexable();
        }

        @Override
        public boolean isSorted(@NotNull IntOrdering intOrdering) {
            return true;
        }

        @Override
        public boolean isStrictlySorted(@NotNull IntOrdering intOrdering) {
            return true;
        }

        @Override
        public int first() {
            throw new NoSuchElementException("No first element in an empty countable!");
        }

        @Override
        public int last() {
            throw new NoSuchElementException("No last element in an empty countable!");
        }

        @Override
        @NotNull
        public IntIndexable frozen() {
            return IntIndexable.EMPTY;
        }
    };

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @NotNull
    default public Collection<Integer> asCollection() {
        return new AbstractCollection<Integer>(){

            @Override
            @NotNull
            public Iterator<Integer> iterator() {
                return IntCountable.this.intIterator();
            }

            @Override
            public int size() {
                return IntCountable.this.size();
            }
        };
    }

    @NotNull
    default public ArrayList<Integer> toList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    default public void addAllTo(@NotNull Collection<? super Integer> collection) {
        for (Integer n : this) {
            collection.add(n);
        }
    }

    @NotNull
    default public int[] toArray() {
        int n = this.size();
        if (n == 0) {
            return Empty.INT_ARRAY;
        }
        int[] nArray = new int[n];
        this.addToArray(nArray, 0);
        return nArray;
    }

    default public int addToArray(@NotNull int[] nArray, int n2) {
        Counter counter = Counter.simple(n2);
        this.forEachInt(n -> {
            nArray[counter.getValue()] = n;
            counter.add1();
        });
        return counter.getValue();
    }

    @NotNull
    default public <R> Countable<R> view(final @NotNull IntFunction<? extends R> intFunction) {
        return new Countable.Base<R>(){

            @Override
            public int size() {
                return IntCountable.this.size();
            }

            @Override
            @NotNull
            public Iterator<R> iterator() {
                final PrimitiveIterator.OfInt ofInt = IntCountable.this.intIterator();
                return new Iterator<R>(){

                    @Override
                    public boolean hasNext() {
                        return ofInt.hasNext();
                    }

                    @Override
                    public R next() {
                        return intFunction.apply(ofInt.nextInt());
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return IntCountable.this.isEmpty();
            }
        };
    }

    @NotNull
    default public PrimitiveIntIterable filtered(final @NotNull IntPredicate intPredicate) {
        return () -> {
            final PrimitiveIterator.OfInt ofInt = this.intIterator();
            return new PrimitiveIterator.OfInt(){
                boolean hasNext;
                int nextValue;

                private void forward() {
                    while (ofInt.hasNext()) {
                        this.nextValue = ofInt.next();
                        if (!intPredicate.test(this.nextValue)) continue;
                        this.hasNext = true;
                    }
                    this.hasNext = false;
                }

                @Override
                public int nextInt() {
                    if (!this.hasNext) {
                        throw new NoSuchElementException();
                    }
                    try {
                        int n = this.nextValue;
                        return n;
                    }
                    finally {
                        this.forward();
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.hasNext;
                }
            };
        };
    }

    @NotNull
    default public IntIndexable sorted(@NotNull IntOrdering intOrdering) {
        MutableIntIndexable.Base base = MutableIntIndexable.viewArray(this.toArray());
        base.order(intOrdering);
        return base;
    }

    default public boolean isSorted(@NotNull IntOrdering intOrdering) {
        if (this.size() < 2) {
            return true;
        }
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        int n = ofInt.next();
        while (ofInt.hasNext()) {
            int n2 = ofInt.nextInt();
            if (intOrdering.descending(n, n2)) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    default public boolean isStrictlySorted(@NotNull IntOrdering intOrdering) {
        if (this.size() < 2) {
            return true;
        }
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        int n = ofInt.next();
        while (ofInt.hasNext()) {
            int n2 = ofInt.nextInt();
            if (intOrdering.descendingOrSame(n, n2)) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    @NotNull
    default public IntIndexable frozen() {
        return IndexableHelper.frozenFromArray(this.toArray());
    }

    default public int first() {
        return this.intIterator().nextInt();
    }

    default public int last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("No last element because there are no elements!");
        }
        int n = 0;
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        while (ofInt.hasNext()) {
            n = ofInt.nextInt();
        }
        return n;
    }

    @NotNull
    default public Base asBase() {
        return new Base(){

            @Override
            public PrimitiveIterator.OfInt intIterator() {
                return IntCountable.this.intIterator();
            }

            @Override
            public int size() {
                return IntCountable.this.size();
            }
        };
    }

    default public <E> boolean isEqual(@NotNull IntCountable intCountable) {
        if (this.size() != intCountable.size()) {
            return false;
        }
        PrimitiveIterator.OfInt ofInt = this.intIterator();
        PrimitiveIterator.OfInt ofInt2 = intCountable.intIterator();
        while (ofInt.hasNext() && ofInt2.hasNext()) {
            if (ofInt.nextInt() == ofInt2.nextInt()) continue;
            return false;
        }
        return !ofInt.hasNext() && !ofInt2.hasNext();
    }

    @NotNull
    public static IntCountable viewCollection(final @NotNull Collection<? extends Number> collection) {
        return new Base(){

            @Override
            public int size() {
                return collection.size();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator() {
                final Iterator iterator = collection.iterator();
                return new PrimitiveIterator.OfInt(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public int nextInt() {
                        return ((Number)iterator.next()).intValue();
                    }
                };
            }
        };
    }

    @NotNull
    public static IntCountable viewCollectionN(@Nullable Collection<? extends Number> collection) {
        return collection == null ? IntCountable.empty() : IntCountable.viewCollection(collection);
    }

    @NotNull
    public static <E> IntCountable viewCollection(final @NotNull Collection<E> collection, final @NotNull ToIntFunction<? super E> toIntFunction) {
        return new Base(){

            @Override
            public int size() {
                return collection.size();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator() {
                final Iterator iterator = collection.iterator();
                return new PrimitiveIterator.OfInt(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public int nextInt() {
                        return toIntFunction.applyAsInt(iterator.next());
                    }
                };
            }
        };
    }

    @NotNull
    public static <E> IntCountable viewCollectionN(@Nullable Collection<E> collection, @NotNull ToIntFunction<? super E> toIntFunction) {
        return collection == null ? IntCountable.empty() : IntCountable.viewCollection(collection, toIntFunction);
    }

    @NotNull
    public static IntCountable empty() {
        return EMPTY;
    }

    @NotNull
    public static IntCountable singleton(final int n) {
        return new Base(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator() {
                return new PrimitiveIterator.OfInt(){
                    boolean finished;

                    @Override
                    public int nextInt() {
                        if (this.finished) {
                            throw new NoSuchElementException();
                        }
                        this.finished = true;
                        return n;
                    }

                    @Override
                    public boolean hasNext() {
                        return !this.finished;
                    }
                };
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public IntIndexable frozen() {
                return IntIndexable.singleton(n);
            }

            @Override
            @NotNull
            public IntIndexable sorted(@NotNull IntOrdering intOrdering) {
                return IntIndexable.singleton(n);
            }

            @Override
            public boolean isSorted(@NotNull IntOrdering intOrdering) {
                return true;
            }

            @Override
            public boolean isStrictlySorted(@NotNull IntOrdering intOrdering) {
                return true;
            }

            @Override
            public int first() {
                return n;
            }

            @Override
            public int last() {
                return n;
            }
        };
    }

    @NotNull
    public static IntCountable uniform(final int n, final int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Count has to be positive or 0, but is " + n2);
        }
        if (n2 == 0) {
            return IntCountable.empty();
        }
        if (n2 == 1) {
            return IntCountable.singleton(n);
        }
        return new Base(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator() {
                return new PrimitiveIterator.OfInt(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < n2;
                    }

                    @Override
                    public int nextInt() {
                        if (this.index >= n2) {
                            throw new NoSuchElementException("No value for " + this.index + " in this Countable!");
                        }
                        ++this.index;
                        return n;
                    }
                };
            }
        };
    }

    @NotNull
    public static String toString(@NotNull IntCountable intCountable) {
        if (intCountable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean bl = true;
        PrimitiveIterator.OfInt ofInt = intCountable.intIterator();
        while (ofInt.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(ofInt.nextInt());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static abstract class Base
    implements IntCountable {
        public int hashCode() {
            int n = 1;
            PrimitiveIterator.OfInt ofInt = this.intIterator();
            while (ofInt.hasNext()) {
                n = 31 * n + ofInt.nextInt();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IntCountable)) {
                return false;
            }
            return this.isEqual((IntCountable)object);
        }

        public String toString() {
            return IntCountable.toString(this);
        }

        @Override
        @NotNull
        public Base asBase() {
            return this;
        }
    }
}

